/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableUtils;
import io.questdb.cutlass.line.tcp.DefaultColumnTypes;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.std.Chars;
import io.questdb.std.LowerCaseCharSequenceHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8s;

public class TableStructureAdapter
implements TableStructure {
    private static final String DEFAULT_TIMESTAMP_FIELD = "timestamp";
    private static final ThreadLocal<StringSink> tempSink = new ThreadLocal<StringSink>(StringSink::new);
    private final CairoConfiguration cairoConfiguration;
    private final DefaultColumnTypes defaultColumnTypes;
    private final int defaultPartitionBy;
    private final ObjList<LineTcpParser.ProtoEntity> entities = new ObjList();
    private final LowerCaseCharSequenceHashSet entityNamesUtf16 = new LowerCaseCharSequenceHashSet();
    private final boolean walEnabledDefault;
    private CharSequence tableName;
    private int timestampIndex = -1;

    public TableStructureAdapter(CairoConfiguration configuration, DefaultColumnTypes defaultColumnTypes, int defaultPartitionBy, boolean walEnabledDefault) {
        this.cairoConfiguration = configuration;
        this.defaultColumnTypes = defaultColumnTypes;
        this.defaultPartitionBy = defaultPartitionBy;
        this.walEnabledDefault = walEnabledDefault;
    }

    @Override
    public int getColumnCount() {
        int size = this.entities.size();
        return this.timestampIndex == -1 ? size + 1 : size;
    }

    @Override
    public CharSequence getColumnName(int columnIndex) {
        assert (columnIndex < this.getColumnCount());
        if (columnIndex == this.getTimestampIndex()) {
            return DEFAULT_TIMESTAMP_FIELD;
        }
        String colName = this.entities.get(columnIndex).getName().toString();
        if (TableUtils.isValidColumnName(colName, this.cairoConfiguration.getMaxFileNameLength())) {
            return colName;
        }
        throw CairoException.nonCritical().put("column name contains invalid characters [colName=").put(colName).put(']');
    }

    public CharSequence getColumnNameNoValidation(int columnIndex) {
        assert (columnIndex < this.getColumnCount());
        if (columnIndex == this.getTimestampIndex()) {
            return DEFAULT_TIMESTAMP_FIELD;
        }
        return this.entities.get(columnIndex).getName().toString();
    }

    @Override
    public int getColumnType(int columnIndex) {
        if (columnIndex == this.getTimestampIndex()) {
            return 8;
        }
        int columnType = this.defaultColumnTypes.DEFAULT_COLUMN_TYPES[this.entities.get(columnIndex).getType()];
        if (columnType == 27) {
            columnType = this.entities.get(columnIndex).getArray().getType();
        }
        return columnType;
    }

    @Override
    public int getIndexBlockCapacity(int columnIndex) {
        return 0;
    }

    @Override
    public int getMaxUncommittedRows() {
        return this.cairoConfiguration.getMaxUncommittedRows();
    }

    @Override
    public long getO3MaxLag() {
        return this.cairoConfiguration.getO3MaxLag();
    }

    @Override
    public int getPartitionBy() {
        return this.defaultPartitionBy;
    }

    @Override
    public boolean getSymbolCacheFlag(int columnIndex) {
        return this.cairoConfiguration.getDefaultSymbolCacheFlag();
    }

    @Override
    public int getSymbolCapacity(int columnIndex) {
        return this.cairoConfiguration.getDefaultSymbolCapacity();
    }

    @Override
    public CharSequence getTableName() {
        return this.tableName;
    }

    @Override
    public int getTimestampIndex() {
        return this.timestampIndex == -1 ? this.entities.size() : this.timestampIndex;
    }

    @Override
    public boolean isDedupKey(int columnIndex) {
        return false;
    }

    @Override
    public boolean isIndexed(int columnIndex) {
        return false;
    }

    @Override
    public boolean isWalEnabled() {
        return this.walEnabledDefault && PartitionBy.isPartitioned(this.getPartitionBy());
    }

    public TableStructureAdapter of(CharSequence tableName, LineTcpParser parser) {
        this.tableName = tableName;
        this.entityNamesUtf16.clear();
        this.entities.clear();
        this.timestampIndex = -1;
        for (int i = 0; i < parser.getEntityCount(); ++i) {
            LineTcpParser.ProtoEntity entity = parser.getEntity(i);
            DirectUtf8Sequence colNameUtf8 = entity.getName();
            CharSequence colNameUtf16 = Utf8s.directUtf8ToUtf16(colNameUtf8, tempSink.get());
            int index = this.entityNamesUtf16.keyIndex(colNameUtf16);
            if (index <= -1) continue;
            this.entityNamesUtf16.addAt(index, colNameUtf16.toString());
            if (Chars.equals(colNameUtf16, (CharSequence)DEFAULT_TIMESTAMP_FIELD)) {
                this.timestampIndex = this.entities.size();
            }
            this.entities.add(entity);
        }
        return this;
    }
}

