/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cutlass.text.AbstractTextLexer;
import io.questdb.cutlass.text.CsvTextLexer;
import io.questdb.cutlass.text.GenericTextLexer;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.std.Misc;
import io.questdb.std.QuietCloseable;

public class TextLexerWrapper
implements QuietCloseable {
    private final TextConfiguration configuration;
    private final CsvTextLexer csvLexer;
    private GenericTextLexer genericTextLexer;

    public TextLexerWrapper(TextConfiguration configuration) {
        this.configuration = configuration;
        this.csvLexer = new CsvTextLexer(configuration);
    }

    @Override
    public void close() {
        Misc.free(this.csvLexer);
        this.genericTextLexer = Misc.free(this.genericTextLexer);
    }

    public AbstractTextLexer getLexer(byte delimiter) {
        if (delimiter == 44) {
            this.csvLexer.clear();
            return this.csvLexer;
        }
        if (this.genericTextLexer == null) {
            this.genericTextLexer = new GenericTextLexer(this.configuration);
        }
        this.genericTextLexer.clear();
        this.genericTextLexer.of(delimiter);
        return this.genericTextLexer;
    }
}

