/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;

public interface TernaryFunction
extends Function {
    @Override
    default public void close() {
        this.getLeft().close();
        this.getCenter().close();
        this.getRight().close();
    }

    @Override
    default public void cursorClosed() {
        this.getLeft().cursorClosed();
        this.getCenter().cursorClosed();
        this.getRight().cursorClosed();
    }

    public Function getCenter();

    public Function getLeft();

    public Function getRight();

    @Override
    default public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        this.getLeft().init(symbolTableSource, executionContext);
        this.getCenter().init(symbolTableSource, executionContext);
        this.getRight().init(symbolTableSource, executionContext);
    }

    @Override
    default public boolean isConstant() {
        return this.getLeft().isConstant() && this.getCenter().isConstant() && this.getRight().isConstant();
    }

    @Override
    default public boolean isNonDeterministic() {
        return this.getLeft().isNonDeterministic() || this.getCenter().isNonDeterministic() || this.getRight().isNonDeterministic();
    }

    @Override
    default public boolean isRandom() {
        return this.getLeft().isRandom() || this.getCenter().isRandom() || this.getRight().isRandom();
    }

    @Override
    default public boolean isRuntimeConstant() {
        boolean arc = this.getLeft().isRuntimeConstant();
        boolean brc = this.getCenter().isRuntimeConstant();
        boolean crc = this.getRight().isRuntimeConstant();
        boolean ac = this.getLeft().isConstant();
        boolean bc = this.getCenter().isConstant();
        boolean cc = this.getRight().isConstant();
        return !(!ac && !arc || !bc && !brc || !cc && !crc || !arc && !brc && !crc);
    }

    @Override
    default public boolean isThreadSafe() {
        return this.getLeft().isThreadSafe() && this.getCenter().isThreadSafe() && this.getRight().isThreadSafe();
    }

    @Override
    default public void memoize(Record record) {
        this.getLeft().memoize(record);
        this.getCenter().memoize(record);
        this.getRight().memoize(record);
    }

    @Override
    default public void offerStateTo(Function that) {
        if (that instanceof TernaryFunction) {
            this.getLeft().offerStateTo(((TernaryFunction)that).getLeft());
            this.getCenter().offerStateTo(((TernaryFunction)that).getCenter());
            this.getRight().offerStateTo(((TernaryFunction)that).getRight());
        }
    }

    @Override
    default public boolean shouldMemoize() {
        return this.getLeft().shouldMemoize() || this.getCenter().shouldMemoize() || this.getRight().shouldMemoize();
    }

    @Override
    default public boolean supportsParallelism() {
        return this.getLeft().supportsParallelism() && this.getCenter().supportsParallelism() && this.getRight().supportsParallelism();
    }

    @Override
    default public boolean supportsRandomAccess() {
        return this.getLeft().supportsRandomAccess() && this.getRight().supportsRandomAccess() && this.getCenter().supportsRandomAccess();
    }

    @Override
    default public void toPlan(PlanSink sink) {
        sink.val(this.getName()).val('(').val(this.getLeft()).val(',').val(this.getCenter()).val(',').val(this.getRight()).val(')');
    }

    @Override
    default public void toTop() {
        this.getLeft().toTop();
        this.getCenter().toTop();
        this.getRight().toTop();
    }
}

