/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IntervalFunction;
import io.questdb.std.IntList;
import io.questdb.std.Interval;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class IntIntervalFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return ":(II)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new IntIntervalFunction(args.getQuick(0), args.getQuick(1));
    }

    static class IntIntervalFunction
    extends IntervalFunction
    implements BinaryFunction {
        private final Interval interval = new Interval();
        private final Function left;
        private final Function right;

        public IntIntervalFunction(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        @NotNull
        public Interval getInterval(Record rec) {
            this.interval.of(this.left.getInt(rec), this.right.getInt(rec));
            return this.interval;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public String getName() {
            return ":";
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public boolean isOperator() {
            return true;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }
    }
}

