/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToDoubleFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class CastSymbolToDoubleFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Kd)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToDoubleFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public double getDouble(Record rec) {
            CharSequence value = this.arg.getSymbol(rec);
            try {
                return value == null ? Double.NaN : Numbers.parseDouble(value);
            }
            catch (NumericException e) {
                return Double.NaN;
            }
        }
    }
}

