/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToStrFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastVarcharToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(\u00d8s)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            return new StrConstant(Chars.toString(arg.getStrB(null)));
        }
        return new Func(arg);
    }

    public static class Func
    extends AbstractCastToStrFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.arg.getStrA(rec);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.arg.getStrB(rec);
        }

        @Override
        public int getStrLen(Record rec) {
            return this.arg.getStrLen(rec);
        }
    }
}

