/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.Timestamps;
import org.jetbrains.annotations.Nullable;

public class TimestampAddFunctionFactory
implements FunctionFactory {
    private static final LongAddIntFunction ADD_DAYS_FUNCTION = Timestamps::addDays;
    private static final LongAddIntFunction ADD_HOURS_FUNCTION = Timestamps::addHours;
    private static final LongAddIntFunction ADD_MICROS_FUNCTION = Timestamps::addMicros;
    private static final LongAddIntFunction ADD_MILLIS_FUNCTION = Timestamps::addMillis;
    private static final LongAddIntFunction ADD_MINUTES_FUNCTION = Timestamps::addMinutes;
    private static final LongAddIntFunction ADD_MONTHS_FUNCTION = Timestamps::addMonths;
    private static final LongAddIntFunction ADD_SECONDS_FUNCTION = Timestamps::addSeconds;
    private static final LongAddIntFunction ADD_WEEKS_FUNCTION = Timestamps::addWeeks;
    private static final LongAddIntFunction ADD_YEARS_FUNCTION = Timestamps::addYears;

    @Nullable
    public static LongAddIntFunction lookupAddFunction(char period) {
        switch (period) {
            case 'U': 
            case 'u': {
                return ADD_MICROS_FUNCTION;
            }
            case 'T': {
                return ADD_MILLIS_FUNCTION;
            }
            case 's': {
                return ADD_SECONDS_FUNCTION;
            }
            case 'm': {
                return ADD_MINUTES_FUNCTION;
            }
            case 'h': {
                return ADD_HOURS_FUNCTION;
            }
            case 'd': {
                return ADD_DAYS_FUNCTION;
            }
            case 'w': {
                return ADD_WEEKS_FUNCTION;
            }
            case 'M': {
                return ADD_MONTHS_FUNCTION;
            }
            case 'y': {
                return ADD_YEARS_FUNCTION;
            }
        }
        return null;
    }

    @Override
    public String getSignature() {
        return "dateadd(AIN)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function periodFunc = args.getQuick(0);
        Function strideFunc = args.getQuick(1);
        Function timestampFunc = args.getQuick(2);
        if (periodFunc.isConstant()) {
            char period = periodFunc.getChar(null);
            LongAddIntFunction periodAddFunc = TimestampAddFunctionFactory.lookupAddFunction(period);
            if (periodAddFunc == null) {
                throw SqlException.$(argPositions.getQuick(0), "invalid time period [unit=").put(period).put(']');
            }
            if (strideFunc.isConstant()) {
                int stride = strideFunc.getInt(null);
                if (stride != Integer.MIN_VALUE) {
                    return new TimestampAddConstConstVar(period, periodAddFunc, stride, timestampFunc);
                }
                throw SqlException.$(argPositions.getQuick(1), "`null` is not a valid stride");
            }
            return new TimestampAddConstVarVar(period, periodAddFunc, strideFunc, timestampFunc);
        }
        return new TimestampAddFunc(periodFunc, strideFunc, argPositions.getQuick(1), timestampFunc);
    }

    @FunctionalInterface
    public static interface LongAddIntFunction {
        public long add(long var1, int var3);
    }

    private static class TimestampAddConstConstVar
    extends TimestampFunction
    implements UnaryFunction {
        private final char period;
        private final LongAddIntFunction periodAddFunction;
        private final int stride;
        private final Function timestampFunc;

        public TimestampAddConstConstVar(char period, LongAddIntFunction periodAddFunction, int stride, Function timestampFunc) {
            this.period = period;
            this.periodAddFunction = periodAddFunction;
            this.stride = stride;
            this.timestampFunc = timestampFunc;
        }

        @Override
        public Function getArg() {
            return this.timestampFunc;
        }

        @Override
        public long getTimestamp(Record rec) {
            long timestamp = this.timestampFunc.getTimestamp(rec);
            if (timestamp == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return this.periodAddFunction.add(timestamp, this.stride);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("dateadd('").val(this.period).val("',").val(this.stride).val(',').val(this.timestampFunc).val(')');
        }
    }

    private static class TimestampAddConstVarVar
    extends TimestampFunction
    implements BinaryFunction {
        private final char period;
        private final LongAddIntFunction periodAddFunc;
        private final Function strideFunc;
        private final Function timestampFunc;

        public TimestampAddConstVarVar(char period, LongAddIntFunction periodAddFunc, Function strideFunc, Function timestampFunc) {
            this.period = period;
            this.periodAddFunc = periodAddFunc;
            this.strideFunc = strideFunc;
            this.timestampFunc = timestampFunc;
        }

        @Override
        public Function getLeft() {
            return this.timestampFunc;
        }

        @Override
        public Function getRight() {
            return this.strideFunc;
        }

        @Override
        public long getTimestamp(Record rec) {
            int stride = this.strideFunc.getInt(rec);
            long timestamp = this.timestampFunc.getTimestamp(rec);
            if (timestamp == Long.MIN_VALUE || stride == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return this.periodAddFunc.add(timestamp, stride);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("dateadd('").val(this.period).val("',").val(this.strideFunc).val(',').val(this.timestampFunc).val(')');
        }
    }

    private static class TimestampAddFunc
    extends TimestampFunction
    implements TernaryFunction {
        private final Function periodFunc;
        private final Function strideFunc;
        private final int stridePosition;
        private final Function timestampFunc;

        public TimestampAddFunc(Function periodFunc, Function strideFunc, int stridePosition, Function timestampFunc) {
            this.periodFunc = periodFunc;
            this.strideFunc = strideFunc;
            this.stridePosition = stridePosition;
            this.timestampFunc = timestampFunc;
        }

        @Override
        public Function getCenter() {
            return this.strideFunc;
        }

        @Override
        public Function getLeft() {
            return this.periodFunc;
        }

        @Override
        public String getName() {
            return "dateadd";
        }

        @Override
        public Function getRight() {
            return this.timestampFunc;
        }

        @Override
        public long getTimestamp(Record rec) {
            char period = this.periodFunc.getChar(rec);
            int stride = this.strideFunc.getInt(rec);
            long timestamp = this.timestampFunc.getTimestamp(rec);
            if (stride == Integer.MIN_VALUE) {
                throw CairoException.nonCritical().position(this.stridePosition).put("`null` is not a valid stride");
            }
            if (timestamp == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return Timestamps.addPeriod(timestamp, period, stride);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("dateadd('").val(this.periodFunc).val("',").val(this.strideFunc).val(',').val(this.timestampFunc).val(')');
        }
    }
}

