/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.LongFunction;

public class CountLongConstGroupByFunction
extends LongFunction
implements GroupByFunction {
    private int valueIndex;

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putLong(this.valueIndex, 1L);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        mapValue.addLong(this.valueIndex, 1L);
    }

    @Override
    public long getLong(Record rec) {
        return rec.getLong(this.valueIndex);
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long srcCount = srcValue.getLong(this.valueIndex);
        destValue.addLong(this.valueIndex, srcCount);
    }

    @Override
    public void setEmpty(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, 0L);
    }

    @Override
    public void setLong(MapValue mapValue, long value) {
        mapValue.putLong(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
    }

    @Override
    public boolean supportsParallelism() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val("count(*)");
    }
}

