/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class RegressionInterceptFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "regr_intercept(DD)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new RegressionInterceptFunction(args.getQuick(0), args.getQuick(1));
    }

    private static class RegressionInterceptFunction
    extends DoubleFunction
    implements GroupByFunction,
    BinaryFunction {
        protected final Function xFunc;
        protected final Function yFunc;
        protected int valueIndex;

        public RegressionInterceptFunction(@NotNull Function arg0, @NotNull Function arg1) {
            this.yFunc = arg0;
            this.xFunc = arg1;
        }

        @Override
        public void computeFirst(MapValue mapValue, Record record, long rowId) {
            double y = this.yFunc.getDouble(record);
            double x = this.xFunc.getDouble(record);
            mapValue.putDouble(this.valueIndex, 0.0);
            mapValue.putDouble(this.valueIndex + 1, 0.0);
            mapValue.putDouble(this.valueIndex + 2, 0.0);
            mapValue.putDouble(this.valueIndex + 3, 0.0);
            mapValue.putLong(this.valueIndex + 4, 0L);
            if (Numbers.isFinite(y) && Numbers.isFinite(x)) {
                this.aggregate(mapValue, y, x);
            }
        }

        @Override
        public void computeNext(MapValue mapValue, Record record, long rowId) {
            double y = this.yFunc.getDouble(record);
            double x = this.xFunc.getDouble(record);
            if (Numbers.isFinite(y) && Numbers.isFinite(x)) {
                this.aggregate(mapValue, y, x);
            }
        }

        @Override
        public double getDouble(Record rec) {
            long count = rec.getLong(this.valueIndex + 4);
            if (count > 0L) {
                double sumXY = rec.getDouble(this.valueIndex + 2);
                double covar = sumXY / (double)count;
                double sumX = rec.getDouble(this.valueIndex + 3);
                double var = sumX / (double)count;
                double slope = covar / var;
                double meanY = rec.getDouble(this.valueIndex);
                double meanX = rec.getDouble(this.valueIndex + 1);
                return meanY - meanX * slope;
            }
            return Double.NaN;
        }

        @Override
        public Function getLeft() {
            return this.yFunc;
        }

        @Override
        public String getName() {
            return "regr_intercept";
        }

        @Override
        public Function getRight() {
            return this.xFunc;
        }

        @Override
        public int getValueIndex() {
            return this.valueIndex;
        }

        @Override
        public void initValueIndex(int valueIndex) {
            this.valueIndex = valueIndex;
        }

        @Override
        public void initValueTypes(ArrayColumnTypes columnTypes) {
            this.valueIndex = columnTypes.getColumnCount();
            columnTypes.add(10);
            columnTypes.add(10);
            columnTypes.add(10);
            columnTypes.add(10);
            columnTypes.add(6);
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean isThreadSafe() {
            return BinaryFunction.super.isThreadSafe();
        }

        @Override
        public void merge(MapValue destValue, MapValue srcValue) {
            double srcMeanY = srcValue.getDouble(this.valueIndex);
            double srcMeanX = srcValue.getDouble(this.valueIndex + 1);
            double srcSumXY = srcValue.getDouble(this.valueIndex + 2);
            double srcSumX = srcValue.getDouble(this.valueIndex + 3);
            long srcCount = srcValue.getLong(this.valueIndex + 4);
            double destMeanY = destValue.getDouble(this.valueIndex);
            double destMeanX = destValue.getDouble(this.valueIndex + 1);
            double destSumXY = destValue.getDouble(this.valueIndex + 2);
            double destSumX = destValue.getDouble(this.valueIndex + 3);
            long destCount = destValue.getLong(this.valueIndex + 4);
            long mergedCount = srcCount + destCount;
            double deltaY = destMeanY - srcMeanY;
            double deltaX = destMeanX - srcMeanX;
            double mergedMeanY = ((double)srcCount * srcMeanY + (double)destCount * destMeanY) / (double)mergedCount;
            double mergedMeanX = ((double)srcCount * srcMeanX + (double)destCount * destMeanX) / (double)mergedCount;
            double mergedSumXY = srcSumXY + destSumXY + deltaY * deltaX * ((double)srcCount * (double)destCount / (double)mergedCount);
            double mergedSumX = srcSumX + destSumX + deltaX * deltaX * ((double)(srcCount * destCount) / (double)mergedCount);
            destValue.putDouble(this.valueIndex, mergedMeanY);
            destValue.putDouble(this.valueIndex + 1, mergedMeanX);
            destValue.putDouble(this.valueIndex + 2, mergedSumXY);
            destValue.putDouble(this.valueIndex + 3, mergedSumX);
            destValue.putLong(this.valueIndex + 4, mergedCount);
        }

        @Override
        public void setNull(MapValue mapValue) {
            mapValue.putDouble(this.valueIndex, Double.NaN);
            mapValue.putDouble(this.valueIndex + 1, Double.NaN);
            mapValue.putDouble(this.valueIndex + 2, Double.NaN);
            mapValue.putDouble(this.valueIndex + 3, Double.NaN);
            mapValue.putLong(this.valueIndex + 4, 0L);
        }

        @Override
        public boolean supportsParallelism() {
            return true;
        }

        protected void aggregate(MapValue mapValue, double y, double x) {
            double meanY = mapValue.getDouble(this.valueIndex);
            double meanX = mapValue.getDouble(this.valueIndex + 1);
            double sumXY = mapValue.getDouble(this.valueIndex + 2);
            double sumX = mapValue.getDouble(this.valueIndex + 3);
            long count = mapValue.getLong(this.valueIndex + 4) + 1L;
            double oldMeanY = meanY;
            double oldMeanX = meanX;
            meanY += (y - meanY) / (double)count;
            meanX += (x - meanX) / (double)count;
            mapValue.putDouble(this.valueIndex, meanY);
            mapValue.putDouble(this.valueIndex + 1, meanX);
            mapValue.putDouble(this.valueIndex + 2, sumXY += (y - oldMeanY) * (x - meanX));
            mapValue.putDouble(this.valueIndex + 3, sumX += (x - meanX) * (x - oldMeanX));
            mapValue.addLong(this.valueIndex + 4, 1L);
        }
    }
}

