/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.griffin.engine.groupby.AbstractNoRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.AbstractSampleByNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdaterFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNoneNotKeyedRecordCursor;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class SampleByFillNoneNotKeyedRecordCursorFactory
extends AbstractSampleByNotKeyedRecordCursorFactory {
    private final SampleByFillNoneNotKeyedRecordCursor cursor;

    public SampleByFillNoneNotKeyedRecordCursorFactory(@NotNull BytecodeAssembler asm, CairoConfiguration configuration, RecordCursorFactory base, @NotNull TimestampSampler timestampSampler, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int valueCount, int timestampIndex, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos, Function sampleFromFunc, int sampleFromFuncPos, Function sampleToFunc, int sampleToFuncPos) {
        super(base, groupByMetadata, recordFunctions);
        SimpleMapValue simpleMapValue = new SimpleMapValue(valueCount);
        GroupByFunctionsUpdater updater = GroupByFunctionsUpdaterFactory.getInstance(asm, groupByFunctions);
        this.cursor = new SampleByFillNoneNotKeyedRecordCursor(configuration, simpleMapValue, groupByFunctions, updater, recordFunctions, timestampIndex, timestampSampler, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Sample By");
        sink.attr("fill").val("none");
        if (this.cursor.sampleFromFunc != TimestampConstant.NULL || this.cursor.sampleToFunc != TimestampConstant.NULL) {
            sink.attr("range").val('(').val(this.cursor.sampleFromFunc).val(',').val(this.cursor.sampleToFunc).val(')');
        }
        sink.optAttr((CharSequence)"values", this.cursor.groupByFunctions, true);
        sink.child(this.base);
    }

    @Override
    protected AbstractNoRecordSampleByCursor getRawCursor() {
        return this.cursor;
    }
}

