/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.ColumnFilter;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.std.IntList;
import io.questdb.std.Misc;

public abstract class AbstractSymbolWrapOverCursor
implements NoRandomAccessRecordCursor {
    protected final int masterSlaveSplit;
    private final ColumnFilter masterTableKeyColumns;
    private final IntList slaveColumnIndex;
    private final int slaveWrappedOverMaster;
    protected RecordCursor masterCursor;
    protected RecordCursor slaveCursor;

    public AbstractSymbolWrapOverCursor(int masterSlaveSplit, int slaveWrappedOverMaster, ColumnFilter masterTableKeyColumns, IntList slaveColumnIndex) {
        this.masterSlaveSplit = masterSlaveSplit;
        this.slaveWrappedOverMaster = slaveWrappedOverMaster;
        this.masterTableKeyColumns = masterTableKeyColumns;
        this.slaveColumnIndex = slaveColumnIndex;
    }

    @Override
    public void close() {
        this.masterCursor = Misc.free(this.masterCursor);
        this.slaveCursor = Misc.free(this.slaveCursor);
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        if (columnIndex < this.masterSlaveSplit) {
            return this.masterCursor.getSymbolTable(columnIndex);
        }
        int slaveCol = columnIndex - this.masterSlaveSplit;
        if (slaveCol >= this.slaveWrappedOverMaster) {
            int masterCol = this.masterTableKeyColumns.getColumnIndexFactored(slaveCol -= this.slaveWrappedOverMaster);
            return this.masterCursor.getSymbolTable(masterCol);
        }
        slaveCol = this.slaveColumnIndex.getQuick(slaveCol);
        return this.slaveCursor.getSymbolTable(slaveCol);
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        if (columnIndex < this.masterSlaveSplit) {
            return this.masterCursor.newSymbolTable(columnIndex);
        }
        int slaveCol = columnIndex - this.masterSlaveSplit;
        if (slaveCol >= this.slaveWrappedOverMaster) {
            int masterCol = this.masterTableKeyColumns.getColumnIndexFactored(slaveCol -= this.slaveWrappedOverMaster);
            return this.masterCursor.newSymbolTable(masterCol);
        }
        slaveCol = this.slaveColumnIndex.getQuick(slaveCol);
        return this.slaveCursor.newSymbolTable(slaveCol);
    }
}

