/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.MessageBus;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameReduceTaskFactory;
import io.questdb.cairo.sql.async.PageFrameReducer;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.GroupByRecordCursorFactory;
import io.questdb.griffin.engine.table.AsyncFilterUtils;
import io.questdb.griffin.engine.table.AsyncGroupByAtom;
import io.questdb.griffin.engine.table.AsyncGroupByRecordCursor;
import io.questdb.jit.CompiledFilter;
import io.questdb.mp.SCSequence;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncGroupByRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final PageFrameReducer AGGREGATE = AsyncGroupByRecordCursorFactory::aggregate;
    private static final PageFrameReducer FILTER_AND_AGGREGATE = AsyncGroupByRecordCursorFactory::filterAndAggregate;
    private final RecordCursorFactory base;
    private final SCSequence collectSubSeq = new SCSequence();
    private final AsyncGroupByRecordCursor cursor;
    private final PageFrameSequence<AsyncGroupByAtom> frameSequence;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final ObjList<Function> recordFunctions;
    private final int workerCount;

    public AsyncGroupByRecordCursorFactory(@NotNull BytecodeAssembler asm, @NotNull CairoConfiguration configuration, @NotNull MessageBus messageBus, @NotNull RecordCursorFactory base, @NotNull RecordMetadata groupByMetadata, @NotNull ListColumnFilter listColumnFilter, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, @NotNull ObjList<GroupByFunction> groupByFunctions, @Nullable ObjList<ObjList<GroupByFunction>> perWorkerGroupByFunctions, @NotNull ObjList<Function> keyFunctions, @Nullable ObjList<ObjList<Function>> perWorkerKeyFunctions, @NotNull ObjList<Function> recordFunctions, @Nullable CompiledFilter compiledFilter, @Nullable MemoryCARW bindVarMemory, @Nullable ObjList<Function> bindVarFunctions, @Nullable Function filter, @NotNull PageFrameReduceTaskFactory reduceTaskFactory, @Nullable ObjList<Function> perWorkerFilters, int workerCount) {
        super(groupByMetadata);
        try {
            this.base = base;
            this.groupByFunctions = groupByFunctions;
            this.recordFunctions = recordFunctions;
            AsyncGroupByAtom atom = new AsyncGroupByAtom(asm, configuration, base.getMetadata(), keyTypes, valueTypes, listColumnFilter, groupByFunctions, perWorkerGroupByFunctions, keyFunctions, perWorkerKeyFunctions, compiledFilter, bindVarMemory, bindVarFunctions, filter, perWorkerFilters, workerCount);
            this.frameSequence = new PageFrameSequence<AsyncGroupByAtom>(configuration, messageBus, atom, filter != null ? FILTER_AND_AGGREGATE : AGGREGATE, reduceTaskFactory, workerCount, 1);
            this.cursor = new AsyncGroupByRecordCursor(groupByFunctions, recordFunctions, messageBus);
            this.workerCount = workerCount;
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public PageFrameSequence<AsyncGroupByAtom> execute(SqlExecutionContext executionContext, SCSequence collectSubSeq, int order) throws SqlException {
        return this.frameSequence.of(this.base, executionContext, collectSubSeq, order);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        int order = this.base.getScanDirection() == 2 ? 1 : 0;
        this.cursor.of(this.execute(executionContext, this.collectSubSeq, order), executionContext);
        return this.cursor;
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsLongTopK() {
        return true;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        if (this.usesCompiledFilter()) {
            sink.type("Async JIT Group By");
        } else {
            sink.type("Async Group By");
        }
        sink.meta("workers").val(this.workerCount);
        sink.optAttr((CharSequence)"keys", GroupByRecordCursorFactory.getKeys(this.recordFunctions, this.getMetadata()));
        sink.optAttr((CharSequence)"values", this.groupByFunctions, true);
        sink.optAttr((CharSequence)"filter", this.frameSequence.getAtom(), true);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.frameSequence.getAtom().getCompiledFilter() != null;
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void aggregate(int workerId, @NotNull PageFrameMemoryRecord record, @NotNull PageFrameReduceTask task, @NotNull SqlExecutionCircuitBreaker circuitBreaker, @Nullable PageFrameSequence<?> stealingFrameSequence) {
        long frameRowCount = task.getFrameRowCount();
        assert (frameRowCount > 0L);
        AsyncGroupByAtom atom = task.getFrameSequence(AsyncGroupByAtom.class).getAtom();
        PageFrameMemory frameMemory = task.populateFrameMemory();
        record.init(frameMemory);
        boolean owner = stealingFrameSequence != null && stealingFrameSequence == task.getFrameSequence();
        try {
            int slotId = atom.maybeAcquire(workerId, owner, circuitBreaker);
            GroupByFunctionsUpdater functionUpdater = atom.getFunctionUpdater(slotId);
            AsyncGroupByAtom.MapFragment fragment = atom.getFragment(slotId);
            RecordSink mapSink = atom.getMapSink(slotId);
            try {
                if (atom.isSharded()) {
                    fragment.shard();
                }
                record.setRowIndex(0L);
                long baseRowId = record.getRowId();
                if (fragment.isNotSharded()) {
                    AsyncGroupByRecordCursorFactory.aggregateNonSharded(record, frameRowCount, baseRowId, functionUpdater, fragment, mapSink);
                } else {
                    AsyncGroupByRecordCursorFactory.aggregateSharded(record, frameRowCount, baseRowId, functionUpdater, fragment, mapSink);
                }
                atom.requestSharding(fragment);
            }
            finally {
                atom.release(slotId);
            }
        }
        finally {
            task.releaseFrameMemory();
        }
    }

    private static void aggregateFilteredNonSharded(PageFrameMemoryRecord record, DirectLongList rows, long baseRowId, GroupByFunctionsUpdater functionUpdater, AsyncGroupByAtom.MapFragment fragment, RecordSink mapSink) {
        Map map = fragment.reopenMap();
        long n = rows.size();
        for (long p = 0L; p < n; ++p) {
            long r = rows.get(p);
            record.setRowIndex(r);
            MapKey key = map.withKey();
            mapSink.copy(record, key);
            MapValue value = key.createValue();
            if (value.isNew()) {
                functionUpdater.updateNew(value, record, baseRowId + r);
                continue;
            }
            functionUpdater.updateExisting(value, record, baseRowId + r);
        }
    }

    private static void aggregateFilteredSharded(PageFrameMemoryRecord record, DirectLongList rows, long baseRowId, GroupByFunctionsUpdater functionUpdater, AsyncGroupByAtom.MapFragment fragment, RecordSink mapSink) {
        Map lookupShard = fragment.getShards().getQuick(0);
        long n = rows.size();
        for (long p = 0L; p < n; ++p) {
            MapKey shardKey;
            long r = rows.get(p);
            record.setRowIndex(r);
            MapKey lookupKey = lookupShard.withKey();
            mapSink.copy(record, lookupKey);
            lookupKey.commit();
            long hashCode = lookupKey.hash();
            Map shard = fragment.getShardMap(hashCode);
            if (shard != lookupShard) {
                shardKey = shard.withKey();
                shardKey.copyFrom(lookupKey);
            } else {
                shardKey = lookupKey;
            }
            MapValue shardValue = shardKey.createValue(hashCode);
            if (shardValue.isNew()) {
                functionUpdater.updateNew(shardValue, record, baseRowId + r);
                continue;
            }
            functionUpdater.updateExisting(shardValue, record, baseRowId + r);
        }
    }

    private static void aggregateNonSharded(PageFrameMemoryRecord record, long frameRowCount, long baseRowId, GroupByFunctionsUpdater functionUpdater, AsyncGroupByAtom.MapFragment fragment, RecordSink mapSink) {
        Map map = fragment.reopenMap();
        for (long r = 0L; r < frameRowCount; ++r) {
            record.setRowIndex(r);
            MapKey key = map.withKey();
            mapSink.copy(record, key);
            MapValue value = key.createValue();
            if (value.isNew()) {
                functionUpdater.updateNew(value, record, baseRowId + r);
                continue;
            }
            functionUpdater.updateExisting(value, record, baseRowId + r);
        }
    }

    private static void aggregateSharded(PageFrameMemoryRecord record, long frameRowCount, long baseRowId, GroupByFunctionsUpdater functionUpdater, AsyncGroupByAtom.MapFragment fragment, RecordSink mapSink) {
        Map lookupShard = fragment.getShards().getQuick(0);
        for (long r = 0L; r < frameRowCount; ++r) {
            MapKey shardKey;
            record.setRowIndex(r);
            MapKey lookupKey = lookupShard.withKey();
            mapSink.copy(record, lookupKey);
            lookupKey.commit();
            long hashCode = lookupKey.hash();
            Map shard = fragment.getShardMap(hashCode);
            if (shard != lookupShard) {
                shardKey = shard.withKey();
                shardKey.copyFrom(lookupKey);
            } else {
                shardKey = lookupKey;
            }
            MapValue shardValue = shardKey.createValue(hashCode);
            if (shardValue.isNew()) {
                functionUpdater.updateNew(shardValue, record, baseRowId + r);
                continue;
            }
            functionUpdater.updateExisting(shardValue, record, baseRowId + r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterAndAggregate(int workerId, @NotNull PageFrameMemoryRecord record, @NotNull PageFrameReduceTask task, @NotNull SqlExecutionCircuitBreaker circuitBreaker, @Nullable PageFrameSequence<?> stealingFrameSequence) {
        DirectLongList rows = task.getFilteredRows();
        PageFrameSequence<AsyncGroupByAtom> frameSequence = task.getFrameSequence(AsyncGroupByAtom.class);
        PageFrameMemory frameMemory = task.populateFrameMemory();
        record.init(frameMemory);
        rows.clear();
        long frameRowCount = task.getFrameRowCount();
        assert (frameRowCount > 0L);
        AsyncGroupByAtom atom = frameSequence.getAtom();
        boolean owner = stealingFrameSequence != null && stealingFrameSequence == frameSequence;
        try {
            int slotId = atom.maybeAcquire(workerId, owner, circuitBreaker);
            GroupByFunctionsUpdater functionUpdater = atom.getFunctionUpdater(slotId);
            AsyncGroupByAtom.MapFragment fragment = atom.getFragment(slotId);
            CompiledFilter compiledFilter = atom.getCompiledFilter();
            Function filter = atom.getFilter(slotId);
            RecordSink mapSink = atom.getMapSink(slotId);
            try {
                if (compiledFilter == null || frameMemory.hasColumnTops()) {
                    AsyncFilterUtils.applyFilter(filter, rows, record, frameRowCount);
                } else {
                    AsyncFilterUtils.applyCompiledFilter(compiledFilter, atom.getBindVarMemory(), atom.getBindVarFunctions(), task);
                }
                if (atom.isSharded()) {
                    fragment.shard();
                }
                record.setRowIndex(0L);
                long baseRowId = record.getRowId();
                if (fragment.isNotSharded()) {
                    AsyncGroupByRecordCursorFactory.aggregateFilteredNonSharded(record, rows, baseRowId, functionUpdater, fragment, mapSink);
                } else {
                    AsyncGroupByRecordCursorFactory.aggregateFilteredSharded(record, rows, baseRowId, functionUpdater, fragment, mapSink);
                }
                atom.requestSharding(fragment);
            }
            finally {
                atom.release(slotId);
            }
        }
        finally {
            task.releaseFrameMemory();
        }
    }

    @Override
    protected void _close() {
        Misc.free(this.base);
        Misc.free(this.cursor);
        Misc.free(this.frameSequence);
        Misc.freeObjList(this.recordFunctions);
    }
}

