/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractPageFrameRecordCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LatestByValuesIndexedFilteredRecordCursor
extends AbstractPageFrameRecordCursor {
    private final int columnIndex;
    private final IntHashSet deferredSymbolKeys;
    private final Function filter;
    private final IntHashSet found = new IntHashSet();
    private final DirectLongList rows;
    private final IntHashSet symbolKeys;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private long index;
    private boolean isTreeMapBuilt;
    private int keyCount;
    private long lim;

    public LatestByValuesIndexedFilteredRecordCursor(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, int columnIndex, DirectLongList rows, @NotNull IntHashSet symbolKeys, @Nullable IntHashSet deferredSymbolKeys, Function filter) {
        super(configuration, metadata);
        this.rows = rows;
        this.columnIndex = columnIndex;
        this.symbolKeys = symbolKeys;
        this.deferredSymbolKeys = deferredSymbolKeys;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (!this.isTreeMapBuilt) {
            this.buildTreeMap();
            this.isTreeMapBuilt = true;
        }
        if (this.index < this.lim) {
            long rowId = this.rows.get(this.index++);
            int frameIndex = 524287 - Rows.toPartitionIndex(rowId);
            this.frameMemoryPool.navigateTo(frameIndex, this.recordA);
            this.recordA.setRowIndex(Rows.toLocalRowID(rowId));
            return true;
        }
        return false;
    }

    @Override
    public void of(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.frameCursor = pageFrameCursor;
        this.recordA.of(pageFrameCursor);
        this.recordB.of(pageFrameCursor);
        this.filter.init(pageFrameCursor, executionContext);
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.rows.clear();
        this.found.clear();
        this.keyCount = -1;
        this.isTreeMapBuilt = false;
        super.init();
    }

    @Override
    public long preComputedStateSize() {
        return this.isTreeMapBuilt ? 1L : 0L;
    }

    @Override
    public long size() {
        return this.isTreeMapBuilt ? this.lim : -1L;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index backward scan").meta("on").putColumnName(this.columnIndex);
        sink.optAttr((CharSequence)"filter", this.filter);
    }

    @Override
    public void toTop() {
        this.index = 0L;
        this.filter.toTop();
    }

    private void addFoundKey(int symbolKey, BitmapIndexReader indexReader, int frameIndex, long partitionLo, long partitionHi) {
        int index = this.found.keyIndex(symbolKey);
        if (index > -1) {
            RowCursor cursor = indexReader.getCursor(false, symbolKey, partitionLo, partitionHi);
            while (cursor.hasNext()) {
                long row = cursor.next();
                this.recordA.setRowIndex(row - partitionLo);
                if (!this.filter.getBool(this.recordA)) continue;
                this.rows.add(Rows.toRowID(frameIndex, row - partitionLo));
                this.found.addAt(index, symbolKey);
                break;
            }
        }
    }

    private void buildTreeMap() {
        PageFrame frame;
        if (this.keyCount < 0) {
            this.keyCount = this.symbolKeys.size();
            if (this.deferredSymbolKeys != null) {
                this.keyCount += this.deferredSymbolKeys.size();
            }
        }
        while ((frame = this.frameCursor.next()) != null && this.found.size() < this.keyCount) {
            int symbolKey;
            int i;
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            int frameIndex = this.frameCount;
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(this.columnIndex, 2);
            long partitionLo = frame.getPartitionLo();
            long partitionHi = frame.getPartitionHi() - 1L;
            this.frameAddressCache.add(this.frameCount, frame);
            this.frameMemoryPool.navigateTo(this.frameCount++, this.recordA);
            int invertedFrameIndex = 524287 - frameIndex;
            int n = this.symbolKeys.size();
            for (i = 0; i < n; ++i) {
                symbolKey = this.symbolKeys.get(i);
                this.addFoundKey(symbolKey, indexReader, invertedFrameIndex, partitionLo, partitionHi);
            }
            if (this.deferredSymbolKeys == null) continue;
            n = this.deferredSymbolKeys.size();
            for (i = 0; i < n; ++i) {
                symbolKey = this.deferredSymbolKeys.get(i);
                if (this.symbolKeys.contains(symbolKey)) continue;
                this.addFoundKey(symbolKey, indexReader, invertedFrameIndex, partitionLo, partitionHi);
            }
        }
        this.rows.sortAsUnsigned();
        this.index = 0L;
        this.lim = this.rows.size();
    }
}

