/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.union;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.engine.union.AbstractSetRecordCursorFactory;
import io.questdb.griffin.engine.union.IntersectCastRecordCursor;
import io.questdb.griffin.engine.union.IntersectRecordCursor;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class IntersectRecordCursorFactory
extends AbstractSetRecordCursorFactory {
    public IntersectRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory factoryA, RecordCursorFactory factoryB, ObjList<Function> castFunctionsA, ObjList<Function> castFunctionsB, RecordSink recordSink, @NotNull ColumnTypes mapKeyTypes, @NotNull ColumnTypes mapValueTypes) {
        super(metadata, factoryA, factoryB, castFunctionsA, castFunctionsB);
        Map mapA = null;
        Map mapB = null;
        try {
            mapA = MapFactory.createOrderedMap(configuration, mapKeyTypes, mapValueTypes);
            mapB = MapFactory.createOrderedMap(configuration, mapKeyTypes, mapValueTypes);
            if (castFunctionsA == null && castFunctionsB == null) {
                this.cursor = new IntersectRecordCursor(mapA, mapB, recordSink);
            } else {
                assert (castFunctionsA != null && castFunctionsB != null);
                this.cursor = new IntersectCastRecordCursor(mapA, mapB, recordSink, castFunctionsA, castFunctionsB);
            }
        }
        catch (Throwable t) {
            Misc.free(mapA);
            Misc.free(mapB);
            this.close();
            throw t;
        }
    }

    @Override
    public int getScanDirection() {
        return this.factoryA.getScanDirection();
    }

    @Override
    protected void _close() {
        Misc.free(this.cursor);
        super._close();
    }

    @Override
    protected CharSequence getOperation() {
        return "Intersect";
    }

    @Override
    protected boolean isSecondFactoryHashed() {
        return true;
    }
}

