/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.AbstractIODispatcher;
import io.questdb.network.Epoll;
import io.questdb.network.EpollAccessor;
import io.questdb.network.IOContext;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.IOEvent;
import io.questdb.network.SuspendEvent;
import io.questdb.std.LongMatrix;
import io.questdb.std.Misc;

public class IODispatcherLinux<C extends IOContext<C>>
extends AbstractIODispatcher<C> {
    private static final int EVM_DEADLINE = 1;
    private static final int EVM_ID = 0;
    private static final int EVM_OPERATION_ID = 2;
    protected final LongMatrix pendingEvents = new LongMatrix(3);
    private final Epoll epoll;
    private long idSeq = 1L;

    public IODispatcherLinux(IODispatcherConfiguration configuration, IOContextFactory<C> ioContextFactory) {
        super(configuration, ioContextFactory);
        this.epoll = new Epoll(configuration.getEpollFacade(), configuration.getEventCapacity());
        this.registerListenerFd();
    }

    @Override
    public void close() {
        super.close();
        Misc.free(this.epoll);
        this.LOG.info().$("closed").$();
    }

    private static boolean isEventId(long id) {
        return (id & 1L) == 1L;
    }

    private void doDisconnect(C context, long id, int reason) {
        SuspendEvent suspendEvent = ((IOContext)context).getSuspendEvent();
        if (suspendEvent != null) {
            int eventRow = this.pendingEvents.binarySearch(id, 2);
            if (eventRow < 0) {
                this.LOG.critical().$("internal error: suspend event not found [id=").$(id).I$();
            } else {
                long eventId = this.pendingEvents.get(eventRow, 0);
                if (this.epoll.control(suspendEvent.getFd(), eventId, EpollAccessor.EPOLL_CTL_DEL, 0) < 0) {
                    this.LOG.critical().$("internal error: epoll_ctl remove suspend event failure [eventId=").$(eventId).$(", err=").$(this.nf.errno()).I$();
                }
                this.pendingEvents.deleteRow(eventRow);
            }
        }
        this.doDisconnect(context, reason);
    }

    private void enqueuePending(int watermark) {
        int i = watermark;
        int sz = this.pending.size();
        int offset = 0;
        while (i < sz) {
            IOContext context = (IOContext)this.pending.get(i);
            long id = this.pending.get(i, 4);
            long fd = this.pending.get(i, 1);
            int operation = this.initialBias == 1 ? 1 : 4;
            this.pending.set(i, 2, operation);
            if (this.epoll.control(fd, id, EpollAccessor.EPOLL_CTL_ADD, this.epollOp(operation, context)) < 0) {
                this.LOG.critical().$("internal error: epoll_ctl failure [id=").$(id).$(", err=").$(this.nf.errno()).I$();
            }
            ++i;
            offset += EpollAccessor.SIZEOF_EVENT;
        }
    }

    private int epollOp(int operation, C context) {
        int op;
        int n = op = operation == 1 ? EpollAccessor.EPOLLIN : EpollAccessor.EPOLLOUT;
        if (((IOContext)context).getSocket().wantsTlsRead()) {
            op |= EpollAccessor.EPOLLIN;
        }
        if (((IOContext)context).getSocket().wantsTlsWrite()) {
            op |= EpollAccessor.EPOLLOUT;
        }
        return op;
    }

    private boolean handleSocketOperation(long id) {
        int row = this.pending.binarySearch(id, 4);
        if (row < 0) {
            this.LOG.critical().$("internal error: epoll returned unexpected id [id=").$(id).I$();
            return false;
        }
        IOContext context = (IOContext)this.pending.get(row);
        SuspendEvent suspendEvent = context.getSuspendEvent();
        if (suspendEvent != null) {
            if (this.testConnection(context.getFd())) {
                this.doDisconnect(context, id, 3);
                this.pending.deleteRow(row);
                return true;
            }
            this.rearmEpoll(context, id, 1);
        } else {
            boolean readyForRead;
            int requestedOp = (int)this.pending.get(row, 2);
            boolean readyForWrite = (this.epoll.getEvent() & EpollAccessor.EPOLLOUT) > 0;
            boolean bl = readyForRead = !readyForWrite || (this.epoll.getEvent() & EpollAccessor.EPOLLIN) > 0;
            if (requestedOp == 4 && readyForWrite || requestedOp == 1 && readyForRead) {
                if (context.getSocket().tlsIO(IODispatcherLinux.tlsIOFlags(requestedOp, readyForRead, readyForWrite)) < 0) {
                    this.doDisconnect(context, id, 4);
                    this.pending.deleteRow(row);
                    return true;
                }
                this.publishOperation(requestedOp, context);
                this.pending.deleteRow(row);
                return true;
            }
            if (context.getSocket().tlsIO(IODispatcherLinux.tlsIOFlags(readyForRead, readyForWrite)) < 0) {
                this.doDisconnect(context, id, 4);
                this.pending.deleteRow(row);
                return true;
            }
            this.rearmEpoll(context, id, requestedOp);
        }
        return false;
    }

    private void handleSuspendEvent(long id) {
        int eventsRow = this.pendingEvents.binarySearch(id, 0);
        if (eventsRow < 0) {
            this.LOG.critical().$("internal error: epoll returned unexpected event id [eventId=").$(id).I$();
            return;
        }
        long opId = this.pendingEvents.get(eventsRow, 2);
        int row = this.pending.binarySearch(opId, 4);
        if (row < 0) {
            this.LOG.critical().$("internal error: suspended operation not found [id=").$(opId).$(", eventId=").$(id).I$();
            return;
        }
        int operation = (int)this.pending.get(row, 2);
        IOContext context = (IOContext)this.pending.get(row);
        SuspendEvent suspendEvent = context.getSuspendEvent();
        assert (suspendEvent != null);
        this.resumeOperation(context, opId, operation);
        this.pendingEvents.deleteRow(eventsRow);
    }

    private long nextEventId() {
        return (this.idSeq++ << 1) + 1L;
    }

    private long nextOpId() {
        return this.idSeq++ << 1;
    }

    private void processHeartbeats(int watermark, long timestamp) {
        int count = 0;
        int i = 0;
        while (i < watermark && this.pending.get(i, 3) < timestamp) {
            long opId;
            IOContext context = (IOContext)this.pending.get(i);
            long fd = context.getFd();
            if (this.epoll.control(fd, opId = this.pending.get(i, 4), EpollAccessor.EPOLL_CTL_DEL, 0) < 0) {
                this.LOG.critical().$("internal error: epoll_ctl remove operation failure [id=").$(opId).$(", err=").$(this.nf.errno()).I$();
            } else {
                context.setHeartbeatId(opId);
                this.publishOperation(8, context);
                int operation = (int)this.pending.get(i, 2);
                int r = this.pendingHeartbeats.addRow();
                this.pendingHeartbeats.set(r, 0, this.pending.get(i, 0));
                this.pendingHeartbeats.set(r, 1, fd);
                this.pendingHeartbeats.set(r, 4, opId);
                this.pendingHeartbeats.set(r, 2, operation);
                this.pendingHeartbeats.set(r, context);
                this.LOG.debug().$("published heartbeat [fd=").$(fd).$(", op=").$(operation).$(", id=").$(opId).I$();
            }
            SuspendEvent suspendEvent = context.getSuspendEvent();
            if (suspendEvent != null) {
                int eventRow = this.pendingEvents.binarySearch(opId, 2);
                if (eventRow < 0) {
                    this.LOG.critical().$("internal error: suspend event not found on heartbeat [id=").$(opId).I$();
                } else {
                    long eventId = this.pendingEvents.get(eventRow, 0);
                    if (this.epoll.control(suspendEvent.getFd(), eventId, EpollAccessor.EPOLL_CTL_DEL, 0) < 0) {
                        this.LOG.critical().$("internal error: epoll_ctl remove suspend event failure [eventId=").$(eventId).$(", err=").$(this.nf.errno()).I$();
                    }
                    this.pendingEvents.deleteRow(eventRow);
                }
            }
            ++i;
            ++count;
        }
        this.pending.zapTop(count);
    }

    private int processIdleConnections(long idleTimestamp) {
        int count = 0;
        int i = 0;
        int n = this.pending.size();
        while (i < n && this.pending.get(i, 0) < idleTimestamp) {
            this.doDisconnect((IOContext)this.pending.get(i), this.pending.get(i, 4), 1);
            ++i;
            ++count;
        }
        this.pending.zapTop(count);
        return count;
    }

    private boolean processRegistrations(long timestamp) {
        long cursor;
        boolean useful = false;
        while ((cursor = this.interestSubSeq.next()) > -1L) {
            IOEvent event = (IOEvent)this.interestQueue.get(cursor);
            Object context = event.context;
            int requestedOperation = event.operation;
            long srcOpId = ((IOContext)context).getAndResetHeartbeatId();
            this.interestSubSeq.done(cursor);
            useful = true;
            long opId = this.nextOpId();
            long fd = ((IOContext)context).getFd();
            int operation = requestedOperation;
            SuspendEvent suspendEvent = ((IOContext)context).getSuspendEvent();
            int epollCmd = EpollAccessor.EPOLL_CTL_MOD;
            if (requestedOperation == 8) {
                assert (srcOpId != -1L);
                int heartbeatRow = this.pendingHeartbeats.binarySearch(srcOpId, 4);
                if (heartbeatRow < 0) continue;
                epollCmd = EpollAccessor.EPOLL_CTL_ADD;
                operation = (int)this.pendingHeartbeats.get(heartbeatRow, 2);
                this.LOG.debug().$("processing heartbeat registration [fd=").$(fd).$(", op=").$(operation).$(", srcId=").$(srcOpId).$(", id=").$(opId).I$();
                int r = this.pending.addRow();
                this.pending.set(r, 0, this.pendingHeartbeats.get(heartbeatRow, 0));
                this.pending.set(r, 3, timestamp);
                this.pending.set(r, 1, fd);
                this.pending.set(r, 4, opId);
                this.pending.set(r, 2, operation);
                this.pending.set(r, context);
                this.pendingHeartbeats.deleteRow(heartbeatRow);
            } else {
                if (requestedOperation == 1 && suspendEvent == null && ((IOContext)context).getSocket().isMorePlaintextBuffered()) {
                    this.publishOperation(1, context);
                    continue;
                }
                this.LOG.debug().$("processing registration [fd=").$(fd).$(", op=").$(operation).$(", id=").$(opId).I$();
                int opRow = this.pending.addRow();
                this.pending.set(opRow, 0, timestamp);
                this.pending.set(opRow, 3, timestamp);
                this.pending.set(opRow, 1, fd);
                this.pending.set(opRow, 4, opId);
                this.pending.set(opRow, 2, requestedOperation);
                this.pending.set(opRow, context);
            }
            if (suspendEvent != null) {
                operation = 1;
                long eventId = this.nextEventId();
                this.LOG.debug().$("registering suspend event [fd=").$(fd).$(", op=").$(operation).$(", eventId=").$(eventId).$(", suspendedOpId=").$(opId).$(", deadline=").$(suspendEvent.getDeadline()).I$();
                int eventRow = this.pendingEvents.addRow();
                this.pendingEvents.set(eventRow, 0, eventId);
                this.pendingEvents.set(eventRow, 2, opId);
                this.pendingEvents.set(eventRow, 1, suspendEvent.getDeadline());
                if (this.epoll.control(suspendEvent.getFd(), eventId, EpollAccessor.EPOLL_CTL_ADD, EpollAccessor.EPOLLIN) < 0) {
                    this.LOG.critical().$("internal error: epoll_ctl add suspend event failure [id=").$(eventId).$(", err=").$(this.nf.errno()).I$();
                }
            }
            if (this.epoll.control(fd, opId, epollCmd, this.epollOp(operation, context)) >= 0) continue;
            this.LOG.critical().$("internal error: epoll_ctl modify operation failure [id=").$(opId).$(", err=").$(this.nf.errno()).I$();
        }
        return useful;
    }

    private void processSuspendEventDeadlines(long timestamp) {
        int count = 0;
        int i = 0;
        int n = this.pendingEvents.size();
        while (i < n && this.pendingEvents.get(i, 1) < timestamp) {
            long eventId = this.pendingEvents.get(i, 0);
            long opId = this.pendingEvents.get(i, 2);
            int pendingRow = this.pending.binarySearch(opId, 4);
            if (pendingRow < 0) {
                this.LOG.critical().$("internal error: failed to find operation for expired suspend event [id=").$(opId).I$();
            } else {
                IOContext context = (IOContext)this.pending.get(pendingRow);
                int operation = (int)this.pending.get(pendingRow, 2);
                SuspendEvent suspendEvent = context.getSuspendEvent();
                assert (suspendEvent != null);
                if (this.epoll.control(suspendEvent.getFd(), eventId, EpollAccessor.EPOLL_CTL_DEL, 0) < 0) {
                    this.LOG.critical().$("internal error: epoll_ctl remove suspend event failure [eventId=").$(eventId).$(", err=").$(this.nf.errno()).I$();
                }
                this.resumeOperation(context, opId, operation);
            }
            ++i;
            ++count;
        }
        this.pendingEvents.zapTop(count);
    }

    private void rearmEpoll(C context, long id, int operation) {
        if (this.epoll.control(((IOContext)context).getFd(), id, EpollAccessor.EPOLL_CTL_MOD, this.epollOp(operation, context)) < 0) {
            this.LOG.critical().$("internal error: epoll_ctl modify operation failure [id=").$(id).$(", err=").$(this.nf.errno()).I$();
        }
    }

    private void resumeOperation(C context, long id, int operation) {
        this.rearmEpoll(context, id, operation);
        ((IOContext)context).clearSuspendEvent();
    }

    @Override
    protected void pendingAdded(int index) {
        this.pending.set(index, 4, this.nextOpId());
    }

    @Override
    protected void registerListenerFd() {
        this.epoll.listen(this.serverFd);
    }

    @Override
    protected boolean runSerially() {
        boolean useful = false;
        long timestamp = this.clock.getTicks();
        this.processDisconnects(timestamp);
        int n = this.epoll.poll();
        int watermark = this.pending.size();
        int offset = 0;
        if (n > 0) {
            this.LOG.debug().$("epoll [n=").$(n).$(']').$();
            for (int i = 0; i < n; ++i) {
                this.epoll.setOffset(offset);
                offset += EpollAccessor.SIZEOF_EVENT;
                long id = this.epoll.getData();
                if (id == 0L) {
                    this.accept(timestamp);
                    useful = true;
                    continue;
                }
                if (IODispatcherLinux.isEventId(id)) {
                    this.handleSuspendEvent(id);
                    continue;
                }
                if (!this.handleSocketOperation(id)) continue;
                useful = true;
                --watermark;
            }
        }
        if (watermark < this.pending.size()) {
            this.enqueuePending(watermark);
        }
        if (this.pendingEvents.size() > 0 && this.pendingEvents.get(0, 1) < timestamp) {
            this.processSuspendEventDeadlines(timestamp);
        }
        long idleTimestamp = timestamp - this.idleConnectionTimeout;
        if (this.pending.size() > 0 && this.pending.get(0, 0) < idleTimestamp) {
            watermark -= this.processIdleConnections(idleTimestamp);
            useful = true;
        }
        long heartbeatTimestamp = timestamp - this.heartbeatIntervalMs;
        if (watermark > 0 && this.pending.get(0, 3) < heartbeatTimestamp) {
            this.processHeartbeats(watermark, heartbeatTimestamp);
            useful = true;
        }
        return this.processRegistrations(timestamp) || useful;
    }

    @Override
    protected void unregisterListenerFd() {
        this.epoll.removeListen(this.serverFd);
    }
}

