/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.KqueueAccessor;
import io.questdb.network.AbstractIODispatcher;
import io.questdb.network.IOContext;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.IOEvent;
import io.questdb.network.Kqueue;
import io.questdb.network.NetworkError;
import io.questdb.network.SuspendEvent;
import io.questdb.std.LongHashSet;
import io.questdb.std.LongMatrix;
import io.questdb.std.Misc;

public class IODispatcherOsx<C extends IOContext<C>>
extends AbstractIODispatcher<C> {
    private static final int EVM_DEADLINE = 1;
    private static final int EVM_ID = 0;
    private static final int EVM_OPERATION_ID = 2;
    protected final LongMatrix pendingEvents = new LongMatrix(3);
    private final LongHashSet alreadyHandledFds = new LongHashSet();
    private final int capacity;
    private final KeventWriter keventWriter = new KeventWriter();
    private final Kqueue kqueue;
    private int idSeq = 0x7FFFFFFE;

    public IODispatcherOsx(IODispatcherConfiguration configuration, IOContextFactory<C> ioContextFactory) {
        super(configuration, ioContextFactory);
        this.capacity = configuration.getEventCapacity();
        try {
            this.kqueue = new Kqueue(configuration.getKqueueFacade(), this.capacity);
            this.registerListenerFd();
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void close() {
        super.close();
        Misc.free(this.kqueue);
        this.LOG.info().$("closed").$();
    }

    private static boolean isEventId(long id) {
        return (id & 1L) == 1L;
    }

    private void doDisconnect(C context, long id, int reason) {
        SuspendEvent suspendEvent = ((IOContext)context).getSuspendEvent();
        if (suspendEvent != null) {
            int eventRow = this.pendingEvents.binarySearch(id, 2);
            if (eventRow < 0) {
                this.LOG.critical().$("internal error: suspend event not found [id=").$(id).I$();
            } else {
                this.keventWriter.prepare().removeReadFD(suspendEvent.getFd()).done();
                this.pendingEvents.deleteRow(eventRow);
            }
        }
        this.doDisconnect(context, reason);
    }

    private void enqueuePending(int watermark) {
        this.keventWriter.prepare();
        int sz = this.pending.size();
        for (int i = watermark; i < sz; ++i) {
            IOContext context = (IOContext)this.pending.get(i);
            int id = (int)this.pending.get(i, 4);
            int operation = this.initialBias == 1 ? 1 : 4;
            this.pending.set(i, 2, operation);
            if (operation == 4 || context.getSocket().wantsTlsWrite()) {
                this.keventWriter.writeFD(context.getFd(), id);
            }
            if (operation != 1 && !context.getSocket().wantsTlsRead()) continue;
            this.keventWriter.readFD(context.getFd(), id);
        }
        this.keventWriter.done();
    }

    private boolean handleSocketOperation(int id) {
        int row = this.pending.binarySearch(id, 4);
        if (row < 0) {
            this.LOG.critical().$("internal error: kqueue returned unexpected id [id=").$(id).I$();
            return false;
        }
        IOContext context = (IOContext)this.pending.get(row);
        SuspendEvent suspendEvent = context.getSuspendEvent();
        if (suspendEvent != null) {
            if (this.testConnection(context.getFd())) {
                this.doDisconnect(context, id, 3);
                this.pending.deleteRow(row);
                return true;
            }
            this.rearmKqueue(context, id, 1);
        } else {
            boolean readyForRead;
            int requestedOp = (int)this.pending.get(row, 2);
            boolean readyForWrite = this.kqueue.getFilter() == KqueueAccessor.EVFILT_WRITE;
            boolean bl = readyForRead = this.kqueue.getFilter() == KqueueAccessor.EVFILT_READ;
            if (requestedOp == 4 && readyForWrite || requestedOp == 1 && readyForRead) {
                this.keventWriter.prepare().tolerateErrors();
                if (requestedOp == 1 && context.getSocket().wantsTlsWrite()) {
                    this.keventWriter.removeWriteFD(context.getFd());
                }
                if (requestedOp == 4 && context.getSocket().wantsTlsRead()) {
                    this.keventWriter.removeReadFD(context.getFd());
                }
                this.keventWriter.done();
                this.publishOperation(requestedOp, context);
                this.pending.deleteRow(row);
                return true;
            }
            if (context.getSocket().tlsIO(IODispatcherOsx.tlsIOFlags(readyForRead, readyForWrite)) < 0) {
                this.doDisconnect(context, id, 4);
                this.pending.deleteRow(row);
                return true;
            }
            this.rearmKqueue(context, id, requestedOp);
        }
        return false;
    }

    private void handleSuspendEvent(long id) {
        int eventsRow = this.pendingEvents.binarySearch(id, 0);
        if (eventsRow < 0) {
            this.LOG.critical().$("internal error: kqueue returned unexpected event id [eventId=").$(id).I$();
            return;
        }
        int opId = (int)this.pendingEvents.get(eventsRow, 2);
        int row = this.pending.binarySearch(opId, 4);
        if (row < 0) {
            this.LOG.critical().$("internal error: suspended operation not found [id=").$(opId).$(", eventId=").$(id).I$();
            return;
        }
        long eventId = this.pendingEvents.get(eventsRow, 0);
        int operation = (int)this.pending.get(row, 2);
        IOContext context = (IOContext)this.pending.get(row);
        SuspendEvent suspendEvent = context.getSuspendEvent();
        assert (suspendEvent != null);
        this.LOG.debug().$("handling triggered suspend event and resuming original operation [fd=").$(context.getFd()).$(", opId=").$(opId).$(", eventId=").$(eventId).I$();
        this.rearmKqueue(context, opId, operation);
        context.clearSuspendEvent();
        this.pendingEvents.deleteRow(eventsRow);
    }

    private int nextEventId() {
        return (this.idSeq++ << 1) + 1;
    }

    private int nextOpId() {
        return this.idSeq++ << 1;
    }

    private void processHeartbeats(int watermark, long timestamp) {
        int count = 0;
        int i = 0;
        while (i < watermark && this.pending.get(i, 3) < timestamp) {
            IOContext context = (IOContext)this.pending.get(i);
            long fd = context.getFd();
            long opId = this.pending.get(i, 4);
            long op = context.getSuspendEvent() != null ? 1L : this.pending.get(i, 2);
            this.keventWriter.prepare().tolerateErrors();
            if (op == 1L || context.getSocket().wantsTlsRead()) {
                this.keventWriter.removeReadFD(fd);
            }
            if (op == 4L || context.getSocket().wantsTlsWrite()) {
                this.keventWriter.removeWriteFD(fd);
            }
            if (this.keventWriter.done() != 0) {
                this.LOG.critical().$("internal error: kqueue remove fd failure [fd=").$(fd).$(", err=").$(this.nf.errno()).I$();
            } else {
                context.setHeartbeatId(opId);
                this.publishOperation(8, context);
                int operation = (int)this.pending.get(i, 2);
                int r = this.pendingHeartbeats.addRow();
                this.pendingHeartbeats.set(r, 0, this.pending.get(i, 0));
                this.pendingHeartbeats.set(r, 1, fd);
                this.pendingHeartbeats.set(r, 4, opId);
                this.pendingHeartbeats.set(r, 2, operation);
                this.pendingHeartbeats.set(r, context);
                this.LOG.debug().$("published heartbeat [fd=").$(fd).$(", op=").$(operation).$(", id=").$(opId).I$();
            }
            SuspendEvent suspendEvent = context.getSuspendEvent();
            if (suspendEvent != null) {
                int eventRow = this.pendingEvents.binarySearch(opId, 2);
                if (eventRow < 0) {
                    this.LOG.critical().$("internal error: suspend event not found on heartbeat [id=").$(opId).I$();
                } else {
                    int eventId = (int)this.pendingEvents.get(eventRow, 0);
                    this.keventWriter.prepare().readFD(suspendEvent.getFd(), eventId).done();
                    this.pendingEvents.deleteRow(eventRow);
                }
            }
            ++i;
            ++count;
        }
        this.pending.zapTop(count);
    }

    private int processIdleConnections(long deadline) {
        int count = 0;
        int i = 0;
        int n = this.pending.size();
        while (i < n && this.pending.get(i, 0) < deadline) {
            this.doDisconnect((IOContext)this.pending.get(i), this.pending.get(i, 4), 1);
            ++i;
            ++count;
        }
        this.pending.zapTop(count);
        return count;
    }

    private boolean processRegistrations(long timestamp) {
        long cursor;
        boolean useful = false;
        this.keventWriter.prepare();
        while ((cursor = this.interestSubSeq.next()) > -1L) {
            IOEvent event = (IOEvent)this.interestQueue.get(cursor);
            Object context = event.context;
            int requestedOperation = event.operation;
            long srcOpId = ((IOContext)context).getAndResetHeartbeatId();
            this.interestSubSeq.done(cursor);
            useful = true;
            int opId = this.nextOpId();
            long fd = ((IOContext)context).getFd();
            int operation = requestedOperation;
            SuspendEvent suspendEvent = ((IOContext)context).getSuspendEvent();
            if (requestedOperation == 8) {
                assert (srcOpId != -1L);
                int heartbeatRow = this.pendingHeartbeats.binarySearch(srcOpId, 4);
                if (heartbeatRow < 0) continue;
                operation = (int)this.pendingHeartbeats.get(heartbeatRow, 2);
                this.LOG.debug().$("processing heartbeat registration [fd=").$(fd).$(", op=").$(operation).$(", srcId=").$(srcOpId).$(", id=").$(opId).I$();
                int r = this.pending.addRow();
                this.pending.set(r, 0, this.pendingHeartbeats.get(heartbeatRow, 0));
                this.pending.set(r, 3, timestamp);
                this.pending.set(r, 1, fd);
                this.pending.set(r, 4, opId);
                this.pending.set(r, 2, operation);
                this.pending.set(r, context);
                this.pendingHeartbeats.deleteRow(heartbeatRow);
            } else {
                if (requestedOperation == 1 && suspendEvent == null && ((IOContext)context).getSocket().isMorePlaintextBuffered()) {
                    this.publishOperation(1, context);
                    continue;
                }
                this.LOG.debug().$("processing registration [fd=").$(fd).$(", op=").$(operation).$(", id=").$(opId).I$();
                int opRow = this.pending.addRow();
                this.pending.set(opRow, 0, timestamp);
                this.pending.set(opRow, 3, timestamp);
                this.pending.set(opRow, 1, fd);
                this.pending.set(opRow, 4, opId);
                this.pending.set(opRow, 2, requestedOperation);
                this.pending.set(opRow, context);
            }
            if (suspendEvent != null) {
                operation = 1;
                int eventId = this.nextEventId();
                this.LOG.debug().$("registering suspend event [fd=").$(fd).$(", op=").$(operation).$(", eventId=").$(eventId).$(", suspendedOpId=").$(opId).$(", deadline=").$(suspendEvent.getDeadline()).I$();
                int eventRow = this.pendingEvents.addRow();
                this.pendingEvents.set(eventRow, 0, eventId);
                this.pendingEvents.set(eventRow, 2, opId);
                this.pendingEvents.set(eventRow, 1, suspendEvent.getDeadline());
                this.keventWriter.readFD(suspendEvent.getFd(), eventId);
            }
            if (operation == 4 || ((IOContext)context).getSocket().wantsTlsWrite()) {
                this.keventWriter.writeFD(fd, opId);
            }
            if (operation != 1 && !((IOContext)context).getSocket().wantsTlsRead()) continue;
            this.keventWriter.readFD(fd, opId);
        }
        this.keventWriter.done();
        return useful;
    }

    private void processSuspendEventDeadlines(long timestamp) {
        int count = 0;
        int i = 0;
        int n = this.pendingEvents.size();
        while (i < n && this.pendingEvents.get(i, 1) < timestamp) {
            int opId = (int)this.pendingEvents.get(i, 2);
            int pendingRow = this.pending.binarySearch(opId, 4);
            if (pendingRow < 0) {
                this.LOG.critical().$("internal error: failed to find operation for expired suspend event [id=").$(opId).I$();
            } else {
                IOContext context = (IOContext)this.pending.get(pendingRow);
                int operation = (int)this.pending.get(pendingRow, 2);
                SuspendEvent suspendEvent = context.getSuspendEvent();
                assert (suspendEvent != null);
                this.keventWriter.prepare().removeReadFD(suspendEvent.getFd()).done();
                this.rearmKqueue(context, opId, operation);
                context.clearSuspendEvent();
            }
            ++i;
            ++count;
        }
        this.pendingEvents.zapTop(count);
    }

    private void rearmKqueue(C context, int id, int operation) {
        this.keventWriter.prepare();
        if (operation == 4 || ((IOContext)context).getSocket().wantsTlsWrite()) {
            this.keventWriter.writeFD(((IOContext)context).getFd(), id);
        }
        if (operation == 1 || ((IOContext)context).getSocket().wantsTlsRead()) {
            this.keventWriter.readFD(((IOContext)context).getFd(), id);
        }
        this.keventWriter.done();
    }

    @Override
    protected void pendingAdded(int index) {
        this.pending.set(index, 4, this.nextOpId());
    }

    @Override
    protected void registerListenerFd() {
        if (this.kqueue.listen(this.serverFd) != 0) {
            throw NetworkError.instance(this.nf.errno(), "could not kqueue.listen()");
        }
    }

    @Override
    protected boolean runSerially() {
        boolean useful = false;
        long timestamp = this.clock.getTicks();
        this.processDisconnects(timestamp);
        this.alreadyHandledFds.clear();
        int n = this.kqueue.poll(0);
        int watermark = this.pending.size();
        int offset = 0;
        if (n > 0) {
            this.LOG.debug().$("poll [n=").$(n).$(']').$();
            for (int i = 0; i < n; ++i) {
                this.kqueue.setReadOffset(offset);
                offset += KqueueAccessor.SIZEOF_KEVENT;
                long fd = this.kqueue.getFd();
                int id = this.kqueue.getData();
                if (fd == this.serverFd) {
                    this.accept(timestamp);
                    useful = true;
                    continue;
                }
                if (!this.alreadyHandledFds.add(fd)) continue;
                if (IODispatcherOsx.isEventId(id)) {
                    this.handleSuspendEvent(id);
                    continue;
                }
                if (!this.handleSocketOperation(id)) continue;
                useful = true;
                --watermark;
            }
        }
        if (watermark < this.pending.size()) {
            this.enqueuePending(watermark);
        }
        if (this.pendingEvents.size() > 0 && this.pendingEvents.get(0, 1) < timestamp) {
            this.processSuspendEventDeadlines(timestamp);
        }
        long idleTimestamp = timestamp - this.idleConnectionTimeout;
        if (this.pending.size() > 0 && this.pending.get(0, 0) < idleTimestamp) {
            watermark -= this.processIdleConnections(idleTimestamp);
            useful = true;
        }
        long heartbeatTimestamp = timestamp - this.heartbeatIntervalMs;
        if (watermark > 0 && this.pending.get(0, 3) < heartbeatTimestamp) {
            this.processHeartbeats(watermark, heartbeatTimestamp);
            useful = true;
        }
        return this.processRegistrations(timestamp) || useful;
    }

    @Override
    protected void unregisterListenerFd() {
        if (this.kqueue.removeListen(this.serverFd) != 0) {
            throw NetworkError.instance(this.nf.errno(), "could not kqueue.removeListen()");
        }
    }

    private class KeventWriter {
        private int index;
        private int lastError;
        private int offset;
        private boolean tolerateErrors;

        private KeventWriter() {
        }

        public int done() {
            if (this.index > 0) {
                this.register(this.index);
            }
            this.index = 0;
            this.offset = 0;
            this.tolerateErrors = false;
            int lastError = this.lastError;
            this.lastError = 0;
            return lastError;
        }

        public KeventWriter readFD(long fd, int id) {
            IODispatcherOsx.this.kqueue.setWriteOffset(this.offset);
            IODispatcherOsx.this.kqueue.readFD(fd, id);
            this.offset += KqueueAccessor.SIZEOF_KEVENT;
            if (++this.index > IODispatcherOsx.this.capacity - 1) {
                this.register(this.index);
                this.offset = 0;
                this.index = 0;
            }
            return this;
        }

        public KeventWriter removeReadFD(long fd) {
            IODispatcherOsx.this.kqueue.setWriteOffset(this.offset);
            IODispatcherOsx.this.kqueue.removeReadFD(fd);
            this.offset += KqueueAccessor.SIZEOF_KEVENT;
            if (++this.index > IODispatcherOsx.this.capacity - 1) {
                this.register(this.index);
                this.offset = 0;
                this.index = 0;
            }
            return this;
        }

        public KeventWriter removeWriteFD(long fd) {
            IODispatcherOsx.this.kqueue.setWriteOffset(this.offset);
            IODispatcherOsx.this.kqueue.removeWriteFD(fd);
            this.offset += KqueueAccessor.SIZEOF_KEVENT;
            if (++this.index > IODispatcherOsx.this.capacity - 1) {
                this.register(this.index);
                this.offset = 0;
                this.index = 0;
            }
            return this;
        }

        public KeventWriter tolerateErrors() {
            this.tolerateErrors = true;
            return this;
        }

        public KeventWriter writeFD(long fd, int id) {
            IODispatcherOsx.this.kqueue.setWriteOffset(this.offset);
            IODispatcherOsx.this.kqueue.writeFD(fd, id);
            this.offset += KqueueAccessor.SIZEOF_KEVENT;
            if (++this.index > IODispatcherOsx.this.capacity - 1) {
                this.register(this.index);
                this.offset = 0;
                this.index = 0;
            }
            return this;
        }

        private KeventWriter prepare() {
            if (this.index > 0 || this.offset > 0) {
                throw new IllegalStateException("missing done() call");
            }
            return this;
        }

        private void register(int changeCount) {
            int res = IODispatcherOsx.this.kqueue.register(changeCount);
            if (!this.tolerateErrors && res != 0) {
                throw NetworkError.instance(IODispatcherOsx.this.nf.errno()).put("could not register [changeCount=").put(changeCount).put(']');
            }
            this.lastError = res != 0 ? res : this.lastError;
            IODispatcherOsx.this.LOG.debug().$("kqueued [count=").$(changeCount).$(']').$();
        }
    }
}

