/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Chars;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class CompactCharSequenceHashSet
implements Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private final int initialCapacity;
    private final double loadFactor;
    private int capacity;
    private int free;
    private String[] keys;
    private int mask;

    public CompactCharSequenceHashSet() {
        this(16);
    }

    public CompactCharSequenceHashSet(int initialCapacity) {
        this(initialCapacity, 0.6);
    }

    public CompactCharSequenceHashSet(int initialCapacity, double loadFactor) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        this.loadFactor = loadFactor;
        this.initialCapacity = initialCapacity < 16 ? 16 : Numbers.ceilPow2(initialCapacity);
        this.resetCapacity();
    }

    public boolean add(CharSequence key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        this.addAt(index, key);
        return true;
    }

    public void addAt(int index, CharSequence key) {
        String s;
        this.keys[index] = s = Chars.toString(key);
        if (--this.free < 1) {
            this.rehash();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, null);
        this.free = this.capacity;
    }

    public boolean contains(CharSequence key) {
        return this.keyIndex(key) < 0;
    }

    public boolean excludes(CharSequence key) {
        return this.keyIndex(key) > -1;
    }

    public int keyIndex(CharSequence key) {
        int hashCode = Chars.hashCode(key);
        int index = hashCode & this.mask;
        if (this.keys[index] == null) {
            return index;
        }
        if (hashCode == this.keys[index].hashCode() && Chars.equals(key, (CharSequence)this.keys[index])) {
            return -index - 1;
        }
        return this.probe(key, index, hashCode);
    }

    public void resetCapacity() {
        this.free = this.capacity = this.initialCapacity;
        int len = Numbers.ceilPow2((int)((double)this.capacity / this.loadFactor));
        this.keys = new String[len];
        this.mask = len - 1;
    }

    public int size() {
        return this.capacity - this.free;
    }

    public String toString() {
        return Arrays.toString(this.keys);
    }

    private int probe(CharSequence key, int index, int hashCode) {
        do {
            if (this.keys[index = index + 1 & this.mask] != null) continue;
            return index;
        } while (hashCode != this.keys[index].hashCode() || !Chars.equals(key, (CharSequence)this.keys[index]));
        return -index - 1;
    }

    private void rehash() {
        int newCapacity;
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        String[] oldKeys = this.keys;
        this.keys = new String[len];
        this.mask = len - 1;
        for (String key : oldKeys) {
            if (key == null) continue;
            this.keys[this.keyIndex((CharSequence)key)] = key;
            --this.free;
        }
    }
}

