/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import org.jetbrains.annotations.NotNull;

public class ObjectPool<T extends Mutable>
implements Mutable {
    private static final Log LOG = LogFactory.getLog(ObjectPool.class);
    private final ObjectFactory<T> factory;
    private final int initialSize;
    private ObjList<T> list;
    private int pos = 0;
    private int size;

    public ObjectPool(@NotNull ObjectFactory<T> factory, int size) {
        this.list = new ObjList(size);
        this.factory = factory;
        this.size = size;
        this.initialSize = size;
        this.fill();
    }

    @Override
    public void clear() {
        this.pos = 0;
    }

    public int getPos() {
        return this.pos;
    }

    public T next() {
        if (this.pos == this.size) {
            this.expand();
        }
        Mutable o = (Mutable)this.list.getQuick(this.pos++);
        o.clear();
        return (T)o;
    }

    public T peekQuick(int pos) {
        return (T)((Mutable)this.list.getQuick(pos));
    }

    public void release(T o) {
        assert (this.pos > 0) : "returnObject called more times than next()";
        --this.pos;
        int objectPos = this.pos;
        while (this.list.getQuick(objectPos) != o) {
            if (--objectPos < 0) {
                throw new AssertionError((Object)("Object not found in pool [object=" + String.valueOf(o) + "]"));
            }
        }
        Mutable objectToSwap = (Mutable)this.list.getQuick(this.pos);
        this.list.setQuick(this.pos, o);
        this.list.setQuick(objectPos, objectToSwap);
    }

    public void resetCapacity() {
        this.list = new ObjList(this.initialSize);
        this.size = this.initialSize;
        this.fill();
        this.pos = 0;
    }

    private void expand() {
        this.fill();
        this.size <<= 1;
        LOG.debug().$("pool resize [class=").$(this.factory.getClass().getName()).$(", size=").$(this.size).$(']').$();
    }

    private void fill() {
        for (int i = 0; i < this.size; ++i) {
            this.list.add((Mutable)this.factory.newInstance());
        }
    }
}

