/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.cairo.TableToken;
import io.questdb.std.Files;
import io.questdb.std.Os;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.bytes.Bytes;
import io.questdb.std.str.AsciiCharSequence;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Path
implements Utf8Sink,
DirectUtf8Sequence,
Closeable {
    private static final byte NULL = 0;
    private static final int OVERHEAD = 4;
    private static final boolean PARANOIA_MODE = false;
    public static final ThreadLocal<Path> PATH = new ThreadLocal<Path>(Path::new);
    public static final ThreadLocal<Path> PATH2 = new ThreadLocal<Path>(Path::new);
    public static final Closeable THREAD_LOCAL_CLEANER = Path::clearThreadLocals;
    private static final ThreadLocal<StringSink> tlSink = new ThreadLocal<StringSink>(StringSink::new);
    private final AsciiCharSequence asciiCharSequence = new AsciiCharSequence();
    private final int initialCapacity;
    private final LPSZ lpsz = new PathLPSZ();
    private final int memoryTag;
    private boolean ascii;
    private int capacity;
    private long headPtr;
    private long tailPtr;

    public Path() {
        this(255);
    }

    public Path(int capacity) {
        this(capacity, 18);
    }

    public Path(int capacity, int memoryTag) {
        assert (capacity > 0);
        this.capacity = capacity;
        this.initialCapacity = capacity;
        this.memoryTag = memoryTag;
        this.headPtr = this.tailPtr = Unsafe.malloc(capacity + 1, memoryTag);
        this.ascii = true;
    }

    public static void clearThreadLocals() {
        PATH.close();
        PATH2.close();
    }

    public static Path getThreadLocal(CharSequence root) {
        return PATH.get().of(root);
    }

    public static Path getThreadLocal(Utf8Sequence root) {
        return PATH.get().of(root);
    }

    public static Path getThreadLocal(Path root) {
        return PATH.get().of(root);
    }

    public static Path getThreadLocal2(Path root) {
        return PATH2.get().of(root);
    }

    public static Path getThreadLocal2(CharSequence root) {
        return PATH2.get().of(root);
    }

    public LPSZ $() {
        if (this.tailPtr == this.headPtr || Unsafe.getUnsafe().getByte(this.tailPtr) != 0) {
            Unsafe.getUnsafe().putByte(this.tailPtr, (byte)0);
        }
        return this.lpsz;
    }

    public void $at(int index) {
        Unsafe.getUnsafe().putByte(this.headPtr + (long)index, (byte)0);
    }

    @Override
    @NotNull
    public CharSequence asAsciiCharSequence() {
        return this.asciiCharSequence.of(this);
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public void close() {
        if (this.headPtr != 0L) {
            Unsafe.free(this.headPtr, this.capacity + 1, this.memoryTag);
            this.tailPtr = 0L;
            this.headPtr = 0L;
        }
    }

    public Path concat(CharSequence str) {
        return this.concat(str, 0, str.length());
    }

    public Path concat(Utf8Sequence str) {
        this.ensureSeparator();
        return this.put(str);
    }

    public Path concat(TableToken token) {
        return this.concat(token.getDirName());
    }

    public Path concat(long pUtf8NameZ) {
        int b;
        this.ascii = false;
        this.ensureSeparator();
        long p = pUtf8NameZ;
        while ((b = Unsafe.getUnsafe().getByte(p++)) != 0) {
            int requiredCapacity = this.size();
            if (requiredCapacity + 4 >= this.capacity) {
                this.extend(requiredCapacity * 2 + 4);
            }
            Unsafe.getUnsafe().putByte(this.tailPtr++, (byte)(b == 47 && Os.isWindows() ? 92 : b));
        }
        return this;
    }

    public Path concat(CharSequence str, int from, int to) {
        this.ensureSeparator();
        return this.put(str, from, to);
    }

    public void extend(int newCapacity) {
        assert (newCapacity > this.capacity);
        int size = this.size();
        this.headPtr = Unsafe.realloc(this.headPtr, this.capacity + 1, newCapacity + 1, 18);
        this.tailPtr = this.headPtr + (long)size;
        this.capacity = newCapacity;
    }

    public void flush() {
        this.$();
    }

    @Override
    public boolean isAscii() {
        return this.ascii;
    }

    public Path of(CharSequence str) {
        this.ascii = true;
        this.checkClosed();
        this.tailPtr = this.headPtr;
        return this.concat(str);
    }

    public Path of(Utf8Sequence str) {
        this.ascii = str.isAscii();
        this.checkClosed();
        if (str == this) {
            this.tailPtr = this.headPtr + (long)str.size();
            return this;
        }
        this.tailPtr = this.headPtr;
        return this.concat(str);
    }

    public Path of(Path other) {
        this.ascii = other.isAscii();
        return this.of((Utf8Sequence)other);
    }

    public Path of(LPSZ other, boolean isAscii) {
        this.ascii = isAscii;
        int len = other.size();
        if (this.headPtr == 0L) {
            this.headPtr = Unsafe.malloc(len + 1, 18);
            this.capacity = len;
        } else if (this.capacity < len) {
            this.extend(len);
        }
        if (len > 0) {
            Unsafe.getUnsafe().copyMemory(other.ptr(), this.headPtr, len);
        }
        this.tailPtr = this.headPtr + (long)len;
        return this;
    }

    public Path of(CharSequence str, int from, int to) {
        this.ascii = true;
        this.checkClosed();
        this.tailPtr = this.headPtr;
        return this.concat(str, from, to);
    }

    public Path parent() {
        if (this.tailPtr > this.headPtr) {
            long p = this.tailPtr - 1L;
            byte last = Unsafe.getUnsafe().getByte(p);
            if (last == Files.SEPARATOR || last == 0) {
                if (p < this.headPtr + 2L) {
                    return this;
                }
                --p;
            }
            while (p > this.headPtr && Unsafe.getUnsafe().getByte(p) != Files.SEPARATOR) {
                --p;
            }
            this.tailPtr = p;
        }
        return this;
    }

    public Path prefix(@Nullable Utf8Sequence prefix, int prefixLen) {
        if (prefix != null && prefixLen > 0) {
            this.ascii &= prefix.isAscii();
            int thisSize = this.size();
            this.checkExtend(thisSize + prefixLen);
            Vect.memmove(this.headPtr + (long)prefixLen, this.headPtr, thisSize);
            Vect.memcpy(this.headPtr, prefix.ptr(), prefixLen);
            this.tailPtr += (long)prefixLen;
        }
        return this;
    }

    @Override
    public long ptr() {
        return this.headPtr;
    }

    public void put(int index, byte b) {
        this.ascii = false;
        Unsafe.getUnsafe().putByte(this.headPtr + (long)index, b);
    }

    @Override
    public Path put(@Nullable Utf8Sequence us) {
        if (us != null) {
            this.ascii &= us.isAscii();
            int size = us.size();
            this.checkExtend(size + 1);
            Utf8s.strCpy(us, size, this.tailPtr);
            this.tailPtr += (long)size;
        }
        return this;
    }

    @Override
    public Path put(byte b) {
        this.ascii = false;
        return this.putByte0(b);
    }

    @Override
    public Path put(int value) {
        Utf8Sink.super.put(value);
        return this;
    }

    @Override
    public Path put(long value) {
        Utf8Sink.super.put(value);
        return this;
    }

    @Override
    public Path put(@NotNull CharSequence cs, int lo, int hi) {
        this.checkExtend(hi - lo + 1);
        Utf8Sink.super.put(cs, lo, hi);
        return this;
    }

    @Override
    public Path put(@Nullable CharSequence cs) {
        Utf8Sink.super.put(cs);
        return this;
    }

    @Override
    public Path put(char c) {
        Utf8Sink.super.put(c);
        return this;
    }

    @Override
    public Path putAscii(char @NotNull [] chars, int start, int len) {
        this.checkExtend(len + 1);
        Utf8Sink.super.putAscii(chars, start, len);
        return this;
    }

    @Override
    public Path putAscii(@NotNull CharSequence cs, int start, int len) {
        this.checkExtend(len + 1);
        Utf8Sink.super.putAscii(cs, start, len);
        return this;
    }

    @Override
    public Path putAscii(@Nullable CharSequence cs) {
        if (cs != null) {
            this.checkExtend(cs.length() + 1);
            Utf8Sink.super.putAscii(cs);
        }
        return this;
    }

    @Override
    public Path putAscii(char c) {
        if (c == '/' && Os.isWindows()) {
            return this.putByte0((byte)92);
        }
        return this.putByte0((byte)c);
    }

    @Override
    public Path putNonAscii(long lo, long hi) {
        this.ascii = false;
        int size = Bytes.checkedLoHiSize(lo, hi, this.size());
        this.checkExtend(size);
        Vect.memcpy(this.tailPtr, lo, size);
        this.tailPtr += (long)size;
        return this;
    }

    public void resetCapacity() {
        if (this.headPtr != 0L) {
            this.tailPtr = this.headPtr = Unsafe.realloc(this.headPtr, this.capacity + 1, this.initialCapacity + 1, 18);
            this.capacity = this.initialCapacity;
        }
    }

    public Path seekZ() {
        for (int count = 0; count < this.capacity; ++count) {
            if (Unsafe.getUnsafe().getByte(this.headPtr + (long)count) != 0) continue;
            this.tailPtr = this.headPtr + (long)count;
            break;
        }
        return this;
    }

    @Override
    public final int size() {
        return (int)(this.tailPtr - this.headPtr);
    }

    public Path slash() {
        this.ensureSeparator();
        return this;
    }

    public LPSZ slash$() {
        this.ensureSeparator();
        return this.$();
    }

    public void toSink(Utf16Sink sink) {
        Utf8s.utf8ToUtf16(this.headPtr, this.tailPtr, sink);
    }

    @NotNull
    public String toString() {
        if (this.headPtr != 0L) {
            StringSink b = tlSink.get();
            b.clear();
            this.toSink(b);
            return b.toString();
        }
        return "";
    }

    public Path trimTo(int len) {
        this.tailPtr = this.headPtr + (long)len;
        return this;
    }

    public void zeroPad(int len) {
        this.checkExtend(len);
        Vect.memset(this.tailPtr, len, 0);
    }

    private void checkClosed() {
        if (this.headPtr == 0L) {
            this.headPtr = this.tailPtr = Unsafe.malloc(this.capacity + 1, 18);
        }
    }

    private void checkExtend(int extra) {
        int requiredCapacity = this.size() + extra;
        if (requiredCapacity > this.capacity) {
            this.extend(requiredCapacity);
        }
    }

    @NotNull
    private Path putByte0(byte b) {
        int requiredCapacity = this.size() + 1;
        if (requiredCapacity >= this.capacity) {
            this.extend(requiredCapacity + 15);
        }
        Unsafe.getUnsafe().putByte(this.tailPtr++, b);
        return this;
    }

    private void randomSeed() {
        long hi = this.headPtr + (long)this.capacity + 1L;
        for (long p = this.headPtr; p < hi; ++p) {
            Unsafe.getUnsafe().putByte(p, (byte)(p % 127L));
        }
    }

    protected final void ensureSeparator() {
        if (this.tailPtr > this.headPtr && Unsafe.getUnsafe().getByte(this.tailPtr - 1L) != Files.SEPARATOR) {
            this.putByte0((byte)Files.SEPARATOR);
        }
    }

    private class PathLPSZ
    implements LPSZ {
        private PathLPSZ() {
        }

        @Override
        @NotNull
        public CharSequence asAsciiCharSequence() {
            return Path.this.asAsciiCharSequence();
        }

        @Override
        public long ptr() {
            return Path.this.headPtr;
        }

        @Override
        public int size() {
            return (int)(Path.this.tailPtr - Path.this.headPtr);
        }
    }
}

