/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.cache.AbstractConnection;
import org.apache.hertzbeat.collector.collect.common.cache.CacheIdentifier;
import org.apache.hertzbeat.collector.collect.common.cache.GlobalConnectionCache;
import org.apache.hertzbeat.collector.collect.kafka.KafkaConnect;
import org.apache.hertzbeat.collector.collect.kafka.constants.InternalTopic;
import org.apache.hertzbeat.collector.collect.kafka.constants.SupportedCommand;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.KafkaProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class KafkaCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(KafkaCollectImpl.class);
    private static final String LAG_NUM = "lag_num";
    private static final String PARTITION_OFFSET = "Partition_offset";
    private final GlobalConnectionCache connectionCommonCache = GlobalConnectionCache.getInstance();

    private static void collectTopicList(CollectRep.MetricsData.Builder builder, AdminClient adminClient, Boolean monitorInternalTopic) throws InterruptedException, ExecutionException {
        ListTopicsOptions options = new ListTopicsOptions().listInternal(true);
        Set topicNames = (Set)adminClient.listTopics(options).names().get();
        topicNames.forEach(topicName -> {
            if (KafkaCollectImpl.filterInternalTopics(topicName, monitorInternalTopic)) {
                CollectRep.ValueRow valueRow = CollectRep.ValueRow.newBuilder().addColumn(topicName).build();
                builder.addValueRow(valueRow);
            }
        });
    }

    private static void collectTopicDescribe(CollectRep.MetricsData.Builder builder, AdminClient adminClient, Boolean monitorInternalTopic) throws InterruptedException, ExecutionException {
        ListTopicsOptions options = new ListTopicsOptions();
        options.listInternal(true);
        ListTopicsResult listTopicsResult = adminClient.listTopics(options);
        Set names = (Set)listTopicsResult.names().get();
        DescribeTopicsResult describeTopicsResult = adminClient.describeTopics((Collection)names);
        Map<String, TopicDescription> topicDescriptionMap = ((Map)describeTopicsResult.all().get()).entrySet().stream().filter(entry -> KafkaCollectImpl.filterInternalTopics((String)entry.getKey(), monitorInternalTopic)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        topicDescriptionMap.forEach((key, value) -> {
            List listp = value.partitions();
            listp.forEach(info -> {
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                valueRowBuilder.addColumn(value.name());
                valueRowBuilder.addColumn(String.valueOf(value.partitions().size()));
                valueRowBuilder.addColumn(String.valueOf(info.partition()));
                valueRowBuilder.addColumn(info.leader().host());
                valueRowBuilder.addColumn(String.valueOf(info.leader().port()));
                valueRowBuilder.addColumn(String.valueOf(info.replicas().size()));
                valueRowBuilder.addColumn(String.valueOf(info.replicas()));
                builder.addValueRow(valueRowBuilder.build());
            });
        });
    }

    private static void collectTopicConsumerGroups(CollectRep.MetricsData.Builder builder, AdminClient adminClient, Boolean monitorInternalTopic) throws InterruptedException, ExecutionException {
        ListTopicsOptions options = new ListTopicsOptions();
        options.listInternal(true);
        ListConsumerGroupsResult consumerGroupsResult = adminClient.listConsumerGroups();
        Collection consumerGroups = (Collection)consumerGroupsResult.all().get();
        Map<String, Set<String>> topicConsumerGroupsMap = KafkaCollectImpl.getTopicConsumerGroupsMap(consumerGroups, adminClient);
        topicConsumerGroupsMap.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(groupId -> {
            try {
                String topicName = (String)entry.getKey();
                if (KafkaCollectImpl.filterInternalTopics(topicName, monitorInternalTopic)) {
                    DescribeConsumerGroupsResult describeResult = adminClient.describeConsumerGroups(Collections.singletonList(groupId));
                    Map consumerGroupDescriptions = (Map)describeResult.all().get();
                    ConsumerGroupDescription description = (ConsumerGroupDescription)consumerGroupDescriptions.get(groupId);
                    Map<String, String> offsetAndLagNum = KafkaCollectImpl.getConsumerGroupMetrics(topicName, groupId, adminClient);
                    return CollectRep.ValueRow.newBuilder().addColumn(groupId).addColumn(String.valueOf(description.members().size())).addColumn(topicName).addColumn(offsetAndLagNum.get(PARTITION_OFFSET)).addColumn(offsetAndLagNum.get(LAG_NUM)).build();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn("group {} get message fail", groupId);
            }
            return null;
        })).filter(Objects::nonNull).forEach(arg_0 -> ((CollectRep.MetricsData.Builder)builder).addValueRow(arg_0));
    }

    private static Map<String, Set<String>> getTopicConsumerGroupsMap(Collection<ConsumerGroupListing> consumerGroups, AdminClient adminClient) throws ExecutionException, InterruptedException {
        HashMap<String, Set<String>> topicConsumerGroupsMap = new HashMap<String, Set<String>>();
        for (ConsumerGroupListing consumerGroup : consumerGroups) {
            String groupId = consumerGroup.groupId();
            ListConsumerGroupOffsetsResult consumerGroupOffsetsResult = adminClient.listConsumerGroupOffsets(groupId);
            Map topicOffsets = (Map)consumerGroupOffsetsResult.partitionsToOffsetAndMetadata().get();
            for (Map.Entry entry : topicOffsets.entrySet()) {
                String topic = ((TopicPartition)entry.getKey()).topic();
                topicConsumerGroupsMap.computeIfAbsent(topic, k -> new HashSet()).add(groupId);
            }
        }
        return topicConsumerGroupsMap;
    }

    private static Map<String, String> getConsumerGroupMetrics(String topic, String groupId, AdminClient adminClient) throws ExecutionException, InterruptedException {
        ListConsumerGroupOffsetsResult consumerGroupOffsetsResult = adminClient.listConsumerGroupOffsets(groupId);
        Map topicOffsets = (Map)consumerGroupOffsetsResult.partitionsToOffsetAndMetadata().get();
        long totalLag = 0L;
        for (Map.Entry topicPartitionOffsetAndMetadataEntry : topicOffsets.entrySet()) {
            if (!((TopicPartition)topicPartitionOffsetAndMetadataEntry.getKey()).topic().equals(topic)) continue;
            OffsetAndMetadata offsetMetadata = (OffsetAndMetadata)topicPartitionOffsetAndMetadataEntry.getValue();
            TopicPartition partition = (TopicPartition)topicPartitionOffsetAndMetadataEntry.getKey();
            ListOffsetsResult.ListOffsetsResultInfo resultInfo = (ListOffsetsResult.ListOffsetsResultInfo)((Map)adminClient.listOffsets(Collections.singletonMap(partition, OffsetSpec.latest())).all().get()).get(partition);
            long latestOffset = resultInfo.offset();
            long l = latestOffset - offsetMetadata.offset();
            totalLag += l;
        }
        String partitionOffsets = topicOffsets.entrySet().stream().filter(entry -> ((TopicPartition)entry.getKey()).topic().equals(topic)).map(entry -> String.valueOf(((OffsetAndMetadata)entry.getValue()).offset())).collect(Collectors.collectingAndThen(Collectors.joining(","), result -> "[" + result + "]"));
        HashMap<String, String> res = new HashMap<String, String>();
        res.put(LAG_NUM, String.valueOf(totalLag));
        res.put(PARTITION_OFFSET, partitionOffsets);
        return res;
    }

    private static boolean filterInternalTopics(String topic, Boolean monitorInternalTopic) {
        if (monitorInternalTopic.booleanValue()) {
            return true;
        }
        return !InternalTopic.isInternalTopic(topic);
    }

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        Assert.isTrue((metrics != null ? 1 : 0) != 0, (String)"Metrics cannot be null");
        KafkaProtocol kafkaProtocol = metrics.getKclient();
        Assert.isTrue((metrics != null && kafkaProtocol != null ? 1 : 0) != 0, (String)"Kafka collect must have kafkaProtocol params");
        Assert.hasText((String)kafkaProtocol.getHost(), (String)"Kafka Protocol host is required.");
        Assert.hasText((String)kafkaProtocol.getPort(), (String)"Kafka Protocol port is required.");
    }

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        try {
            KafkaProtocol kafkaProtocol = metrics.getKclient();
            String command = kafkaProtocol.getCommand();
            Boolean monitorInternalTopic = Boolean.valueOf(kafkaProtocol.getMonitorInternalTopic());
            boolean isKafkaCommand = SupportedCommand.isKafkaCommand(command);
            if (!isKafkaCommand) {
                log.error("Unsupported command: {}", (Object)command);
                builder.setCode(CollectRep.Code.FAIL);
                return;
            }
            AdminClient adminClient = this.getAdminClient(kafkaProtocol);
            switch (SupportedCommand.fromCommand(command)) {
                case TOPIC_DESCRIBE: {
                    KafkaCollectImpl.collectTopicDescribe(builder, adminClient, monitorInternalTopic);
                    break;
                }
                case TOPIC_LIST: {
                    KafkaCollectImpl.collectTopicList(builder, adminClient, monitorInternalTopic);
                    break;
                }
                case TOPIC_OFFSET: {
                    this.collectTopicOffset(builder, adminClient, monitorInternalTopic);
                    break;
                }
                case CONSUMER_DETAIL: {
                    KafkaCollectImpl.collectTopicConsumerGroups(builder, adminClient, monitorInternalTopic);
                    break;
                }
                default: {
                    log.error("Unsupported command: {}", (Object)command);
                    break;
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg("Kafka collect error: " + e.getMessage());
            log.error("Kafka collect error", (Throwable)e);
        }
    }

    protected AdminClient getAdminClient(KafkaProtocol kafkaProtocol) {
        AdminClient adminClient;
        CacheIdentifier kafkaAdminClientIdentifier = CacheIdentifier.builder().ip(kafkaProtocol.getHost()).port(kafkaProtocol.getPort()).build();
        Optional kafkaClientCache = this.connectionCommonCache.getCache((Object)kafkaAdminClientIdentifier, true);
        if (kafkaClientCache.isPresent()) {
            KafkaConnect kafkaConnect = (KafkaConnect)((Object)kafkaClientCache.get());
            adminClient = kafkaConnect.getConnection();
            if (adminClient != null) {
                return adminClient;
            }
            this.connectionCommonCache.removeCache((Object)kafkaAdminClientIdentifier);
        }
        Properties properties = new Properties();
        properties.put("bootstrap.servers", kafkaProtocol.getHost() + ":" + kafkaProtocol.getPort());
        adminClient = KafkaAdminClient.create((Properties)properties);
        if (adminClient == null) {
            return null;
        }
        this.connectionCommonCache.addCache((Object)kafkaAdminClientIdentifier, (AbstractConnection)new KafkaConnect(adminClient));
        return adminClient;
    }

    private void collectTopicOffset(CollectRep.MetricsData.Builder builder, AdminClient adminClient, Boolean monitorInternalTopic) throws InterruptedException, ExecutionException {
        ListTopicsResult listTopicsResult = adminClient.listTopics(new ListTopicsOptions().listInternal(true));
        Set topicNames = (Set)listTopicsResult.names().get();
        topicNames.forEach(topicName -> {
            if (KafkaCollectImpl.filterInternalTopics(topicName, monitorInternalTopic)) {
                try {
                    Map map = (Map)adminClient.describeTopics(Collections.singleton(topicName)).all().get(3L, TimeUnit.SECONDS);
                    map.forEach((key, value) -> value.partitions().forEach(info -> this.extractedOffset(builder, adminClient, (String)topicName, (TopicDescription)value, (TopicPartitionInfo)info)));
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    log.warn("Topic {} get offset fail", topicName);
                }
            }
        });
    }

    private void extractedOffset(CollectRep.MetricsData.Builder builder, AdminClient adminClient, String name, TopicDescription value, TopicPartitionInfo info) {
        try {
            TopicPartition topicPartition = new TopicPartition(value.name(), info.partition());
            long earliestOffset = this.getEarliestOffset(adminClient, topicPartition);
            long latestOffset = this.getLatestOffset(adminClient, topicPartition);
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            valueRowBuilder.addColumn(value.name());
            valueRowBuilder.addColumn(String.valueOf(info.partition()));
            valueRowBuilder.addColumn(String.valueOf(earliestOffset));
            valueRowBuilder.addColumn(String.valueOf(latestOffset));
            builder.addValueRow(valueRowBuilder.build());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.warn("Topic {} get offset fail", (Object)name);
        }
    }

    private long getEarliestOffset(AdminClient adminClient, TopicPartition topicPartition) throws InterruptedException, ExecutionException, TimeoutException {
        return ((ListOffsetsResult.ListOffsetsResultInfo)((Map)adminClient.listOffsets(Collections.singletonMap(topicPartition, OffsetSpec.earliest())).all().get(3L, TimeUnit.SECONDS)).get(topicPartition)).offset();
    }

    private long getLatestOffset(AdminClient adminClient, TopicPartition topicPartition) throws InterruptedException, ExecutionException, TimeoutException {
        return ((ListOffsetsResult.ListOffsetsResultInfo)((Map)adminClient.listOffsets(Collections.singletonMap(topicPartition, OffsetSpec.latest())).all().get(3L, TimeUnit.SECONDS)).get(topicPartition)).offset();
    }

    public String supportProtocol() {
        return "kclient";
    }
}

