/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import org.springframework.data.annotation.CreatedDate;

@Entity
@Table(name="hzb_metrics_favorite", uniqueConstraints={@UniqueConstraint(columnNames={"creator", "monitor_id", "metrics_name"})})
public class MetricsFavorite {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank(message="Creator cannot be null or blank")
    @Size(max=255, message="Creator length cannot exceed 255 characters")
    @Column(name="creator", nullable=false)
    private @NotBlank(message="Creator cannot be null or blank") @Size(max=255, message="Creator length cannot exceed 255 characters") String creator;
    @NotNull(message="Monitor ID cannot be null")
    @Column(name="monitor_id", nullable=false)
    private @NotNull(message="Monitor ID cannot be null") Long monitorId;
    @NotBlank(message="Metrics name cannot be null or blank")
    @Size(max=255, message="Metrics name length cannot exceed 255 characters")
    @Column(name="metrics_name", nullable=false)
    private @NotBlank(message="Metrics name cannot be null or blank") @Size(max=255, message="Metrics name length cannot exceed 255 characters") String metricsName;
    @CreatedDate
    @Column(name="create_time", updatable=false)
    private LocalDateTime createTime;

    public static MetricsFavoriteBuilder builder() {
        return new MetricsFavoriteBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getCreator() {
        return this.creator;
    }

    public Long getMonitorId() {
        return this.monitorId;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setMonitorId(Long monitorId) {
        this.monitorId = monitorId;
    }

    public void setMetricsName(String metricsName) {
        this.metricsName = metricsName;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsFavorite)) {
            return false;
        }
        MetricsFavorite other = (MetricsFavorite)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$monitorId = this.getMonitorId();
        Long other$monitorId = other.getMonitorId();
        if (this$monitorId == null ? other$monitorId != null : !((Object)this$monitorId).equals(other$monitorId)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$metricsName = this.getMetricsName();
        String other$metricsName = other.getMetricsName();
        if (this$metricsName == null ? other$metricsName != null : !this$metricsName.equals(other$metricsName)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetricsFavorite;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $monitorId = this.getMonitorId();
        result = result * 59 + ($monitorId == null ? 43 : ((Object)$monitorId).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $metricsName = this.getMetricsName();
        result = result * 59 + ($metricsName == null ? 43 : $metricsName.hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "MetricsFavorite(id=" + this.getId() + ", creator=" + this.getCreator() + ", monitorId=" + this.getMonitorId() + ", metricsName=" + this.getMetricsName() + ", createTime=" + this.getCreateTime() + ")";
    }

    public MetricsFavorite(Long id, String creator, Long monitorId, String metricsName, LocalDateTime createTime) {
        this.id = id;
        this.creator = creator;
        this.monitorId = monitorId;
        this.metricsName = metricsName;
        this.createTime = createTime;
    }

    public MetricsFavorite() {
    }

    public static class MetricsFavoriteBuilder {
        private Long id;
        private String creator;
        private Long monitorId;
        private String metricsName;
        private LocalDateTime createTime;

        MetricsFavoriteBuilder() {
        }

        public MetricsFavoriteBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public MetricsFavoriteBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public MetricsFavoriteBuilder monitorId(Long monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public MetricsFavoriteBuilder metricsName(String metricsName) {
            this.metricsName = metricsName;
            return this;
        }

        public MetricsFavoriteBuilder createTime(LocalDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        public MetricsFavorite build() {
            return new MetricsFavorite(this.id, this.creator, this.monitorId, this.metricsName, this.createTime);
        }

        public String toString() {
            return "MetricsFavorite.MetricsFavoriteBuilder(id=" + this.id + ", creator=" + this.creator + ", monitorId=" + this.monitorId + ", metricsName=" + this.metricsName + ", createTime=" + this.createTime + ")";
        }
    }
}

