/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.support.valid;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.hertzbeat.common.support.valid.SqlSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SqlSecurityValidator {
    private static final Logger log = LoggerFactory.getLogger(SqlSecurityValidator.class);
    private final Set<String> allowedTables;

    public SqlSecurityValidator(Collection<String> allowedTables) {
        this.allowedTables = CollectionUtils.isEmpty(allowedTables) ? new HashSet<String>() : allowedTables.stream().map(this::normalizeIdentifier).collect(Collectors.toSet());
    }

    public void validate(String sql) throws SqlSecurityException {
        List tables;
        Statement statement;
        if (sql == null || sql.trim().isEmpty()) {
            throw new SqlSecurityException("SQL statement cannot be empty");
        }
        try {
            statement = CCJSqlParserUtil.parse((String)sql);
        }
        catch (JSQLParserException e) {
            log.warn("Failed to parse SQL: {}", (Object)sql, (Object)e);
            throw new SqlSecurityException("Invalid SQL syntax: " + e.getMessage(), e);
        }
        if (!(statement instanceof Select)) {
            throw new SqlSecurityException("Only SELECT statements are allowed.");
        }
        Select select = (Select)statement;
        if (select.getWithItemsList() != null && !select.getWithItemsList().isEmpty()) {
            throw new SqlSecurityException("CTE (WITH clause) is not allowed");
        }
        SecurityTablesNamesFinder finder = new SecurityTablesNamesFinder();
        try {
            tables = finder.getTableList(statement);
        }
        catch (SecurityViolationException e) {
            throw new SqlSecurityException(e.getMessage());
        }
        this.validateTables(tables);
    }

    private void validateTables(List<String> tables) throws SqlSecurityException {
        if (CollectionUtils.isEmpty(tables)) {
            return;
        }
        if (this.allowedTables.isEmpty()) {
            throw new SqlSecurityException("No access allowed: whitelist is empty.");
        }
        for (String table : tables) {
            String normalizedTable = this.normalizeIdentifier(table);
            if (this.allowedTables.contains(normalizedTable)) continue;
            throw new SqlSecurityException("Access to table '" + table + "' is not allowed. Allowed tables: " + this.allowedTables);
        }
    }

    private String normalizeIdentifier(String identifier) {
        if (identifier == null) {
            return "";
        }
        return identifier.replace("\"", "").replace("`", "").replace("'", "").toLowerCase();
    }

    private static class SecurityTablesNamesFinder
    extends TablesNamesFinder<Void> {
        private SecurityTablesNamesFinder() {
        }

        public Void visit(ParenthesedSelect parenthesedSelect, Object context) {
            throw new SecurityViolationException("Subqueries are not allowed");
        }

        public Void visit(SetOperationList setOpList, Object context) {
            throw new SecurityViolationException("UNION and set operations are not allowed");
        }

        public Void visit(LateralSubSelect lateralSubSelect, Object context) {
            throw new SecurityViolationException("LATERAL subqueries are not allowed");
        }

        public Void visit(WithItem withItem, Object context) {
            throw new SecurityViolationException("CTE (WITH clause) is not allowed");
        }
    }

    private static class SecurityViolationException
    extends RuntimeException {
        SecurityViolationException(String message) {
            super(message);
        }
    }
}

