/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.CallableStatement;
import com.xugu.cloudjdbc.ClientInfo;
import com.xugu.cloudjdbc.Command;
import com.xugu.cloudjdbc.ConnectionIO;
import com.xugu.cloudjdbc.DatabaseMetaData;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.IsoLevel;
import com.xugu.cloudjdbc.NClob;
import com.xugu.cloudjdbc.OracleMethod;
import com.xugu.cloudjdbc.PreparedStatement;
import com.xugu.cloudjdbc.SQLXml;
import com.xugu.cloudjdbc.Savepoint;
import com.xugu.cloudjdbc.SlowSQLBean;
import com.xugu.cloudjdbc.Statement;
import com.xugu.cloudjdbc.StringUtils;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import com.xugu.geometric.DBbox;
import com.xugu.geometric.DBcircle;
import com.xugu.geometric.DBline;
import com.xugu.geometric.DBlseg;
import com.xugu.geometric.DBpath;
import com.xugu.geometric.DBpoint;
import com.xugu.geometric.DBpolygon;
import com.xugu.util.DBBinaryObject;
import com.xugu.util.DBobject;
import com.xugu.util.Parser;
import com.xugu.util.internal.Nullness;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Struct;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Connection
implements java.sql.Connection {
    public static AtomicInteger checkConnectionIsValidTimes = new AtomicInteger(0);
    private static final int CONN_TYPE_SINGLE = 0;
    private static final int CONN_TYPE_RANDOM = 1;
    private static final int CONN_TYPE_ROUND = 2;
    protected boolean useSSL = false;
    protected static boolean isSSLLoad = false;
    protected int RsHoldablity = 1;
    private static final SQLPermission SET_NETWORK_TIMEOUT_PERM = new SQLPermission("setNetworkTimeout");
    private boolean logVersionDate;
    static int printVersionTimes = 0;
    static HashMap<Integer, byte[]> wMap = null;
    private String url = null;
    private int connectTimeOut = 3600;
    private Properties props = null;
    private Properties clientProps = null;
    private ClientInfo info = new ClientInfo();
    protected SQLException sqlE = null;
    private String database = null;
    private String user = null;
    private String password = null;
    private String encryptor = null;
    private String charset = "GBK";
    private String timeZone = null;
    private String isoLevel = IsoLevel.IOSLEVEL_READCOMMIT.getLevelName();
    private int isoLevelNum = -1;
    private String lockTimeout = null;
    protected boolean autoCommit = true;
    protected String lob_ret = null;
    protected boolean closeCurrResult = false;
    boolean return_rowid = false;
    boolean is_debug = false;
    String return_schema = "on";
    boolean discadeRow = false;
    boolean isora = false;
    boolean ismysql = false;
    boolean isdbkernel = false;
    boolean compatibleQX = false;
    String compatibleMode;
    int batchOrMoreResultMode = 1;
    boolean emptyStringAsNull = false;
    boolean useBatch = false;
    boolean useBatchByPreson = false;
    boolean benchmarkMode = false;
    boolean benchmarkModeWid = false;
    boolean isSto = false;
    boolean isLoadSto = false;
    boolean useLike = false;
    boolean rebuildConnection = false;
    int slowSQLRecordTime;
    int cursorFetchSize = 1000;
    int cursorFirstSize = 10;
    int resultkeepsize;
    boolean ddlPrepare = false;
    String schemaName;
    String current_schema = null;
    protected static HashMap<String, Vector<ArrayList<String>>> ipsPool = new HashMap();
    protected static LinkedList<String[]> unConList = new LinkedList();
    protected static boolean isNewConnection;
    protected static ScheduledThreadPoolExecutor validTaskExecutor;
    static boolean validateFlag;
    int validateFrequency = 1;
    boolean validateConAlive = true;
    int validatePerTimes = 500;
    protected static Object ipPoolLock;
    protected static int roundIdx;
    private String version = "301";
    String identity_mode = null;
    String keyword_filter = null;
    String disable_binlog = null;
    ConnectionIO io = null;
    Connection lobConn = null;
    Statement lobStatement = null;
    boolean readOnly = false;
    private boolean conIsClosed;
    protected boolean redirect;
    private Map<String, Class<?>> typeMap = null;
    protected Map openStatements = null;
    private int cata_caps = 20;
    private int databaseMajorVersion = 0;
    private int databaseMinorVersion = 0;
    int recv_mode = 0;
    int resultSetHoldability = 1;
    boolean return_cursorName = true;
    Vector<Object> lobVector = new Vector();
    boolean replaceProcessingEnabled = true;
    protected static HashMap<Integer, IsoLevel> iosLevelMap;
    static int[][] day2md;
    static int[][] day2md_rn;
    static final int[][] MTOD;
    private MessageFormat messageFormat = null;
    int closeTime = 0;
    protected SlowSQLBean slowSQLBean;
    private ExecutorService closeExecutor;
    private static Map<String, Class<? extends DBobject>> nameToObject;

    public int getCloseTime() {
        return this.closeTime;
    }

    public Connection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection(String host, int port, String url, Properties props) throws SQLException {
        this.url = url;
        this.props = props;
        this._xugu();
        this.checkSSL(props.getProperty("ssl"));
        String hashKey = host + port + this.user + this.database;
        String hashKeyBak = host + port + this.user + this.database + "ipsbak";
        String connectStr = this.formConnectString();
        this.connectTimeOut = this.getRealTimeout(this.getLoginTimeout());
        int conType = 0;
        if (this.checkRecordSlowSQL()) {
            this.slowSQLBean = new SlowSQLBean();
            this.slowSQLBean.setUser(this.user);
        }
        if (this.sqlE != null) {
            throw this.sqlE;
        }
        if (printVersionTimes == 1) {
            System.out.println("XuguDB JDBC packageTime: " + ReplaceEnum.jdbcVersionDateString.getReplaceStr());
            ++printVersionTimes;
        }
        Vector<ArrayList<String>> ipsVector = null;
        if (StringUtils.startsWithIgnoreCase(url, "jdbc:" + ReplaceEnum.excStr.getReplaceStr() + ":file:")) {
            Object object = ipPoolLock;
            synchronized (object) {
                ipsVector = ipsPool.get(hashKey);
                if (ipsVector == null) {
                    ipsVector = new Vector(10, 10);
                }
                if (ipsVector.size() == 0) {
                    List<ArrayList<String>> fileIPlist = this.parserXml(host, port);
                    ipsVector.addAll(fileIPlist);
                }
                ipsPool.put(hashKey, ipsVector);
                ipsPool.put(hashKeyBak, ipsVector);
            }
            if (ipsVector.size() > 1) {
                conType = 2;
            } else {
                conType = 0;
                host = ipsPool.get(hashKey).get(0).get(1);
            }
            try {
                this.io = new ConnectionIO(host, port, connectStr, this.charset, hashKey, conType, this.password, this.useSSL, this.logVersionDate, this.autoCommit, this.rebuildConnection, this.validateFrequency, this.validatePerTimes, this.validateConAlive, this.slowSQLBean, this.connectTimeOut);
            }
            catch (RuntimeException e) {
                if (ipsVector.size() == 0) {
                    throw e;
                }
                this.io = new ConnectionIO(host, port, connectStr, this.charset, hashKey, conType, this.password, this.useSSL, this.logVersionDate, this.autoCommit, this.rebuildConnection, this.validateFrequency, this.validatePerTimes, this.validateConAlive, this.slowSQLBean, this.connectTimeOut);
            }
        } else if (props.get("ips") != null) {
            Object e = ipPoolLock;
            synchronized (e) {
                ipsVector = ipsPool.get(hashKey);
                if (ipsVector == null) {
                    ipsVector = new Vector(10, 10);
                }
                if (ipsVector.size() == 0) {
                    Object[] ips = new Object[]{};
                    if (props.get("ips") instanceof Vector) {
                        ips = ((Vector)props.get("ips")).toArray();
                    } else if (props.get("ips") instanceof Object[]) {
                        ips = (Object[])props.get("ips");
                    } else if (props.get("ips") instanceof String) {
                        ips = props.get("ips").toString().trim().split(",");
                    }
                    ArrayList<String> firstIp = this.CreateAndInitArrayList(host, port, false);
                    ipsVector.add(firstIp);
                    ArrayList<String> perList = null;
                    String perIp = null;
                    for (int i = 0; i < ips.length; ++i) {
                        String cellStr = ips[i].toString();
                        int pIndex = cellStr.indexOf(":");
                        if (pIndex == -1) {
                            perIp = cellStr;
                            if (host.equals(perIp)) continue;
                            perList = this.CreateAndInitArrayList(perIp, port, false);
                            ipsVector.add(perList);
                            continue;
                        }
                        perIp = cellStr.substring(0, pIndex);
                        int perPort = Integer.parseInt(cellStr.substring(pIndex + 1));
                        if (host.equals(perIp) && port == perPort) continue;
                        perList = this.CreateAndInitArrayList(perIp, perPort, false);
                        ipsVector.add(perList);
                    }
                    ipsPool.put(hashKey, ipsVector);
                    ipsPool.put(hashKeyBak, ipsVector);
                }
            }
            try {
                this.io = new ConnectionIO(host, port, connectStr, this.charset, hashKey, 2, this.password, this.useSSL, this.logVersionDate, this.autoCommit, this.rebuildConnection, this.validateFrequency, this.validatePerTimes, this.validateConAlive, this.slowSQLBean, this.connectTimeOut);
            }
            catch (RuntimeException e2) {
                if (ipsVector.size() == 0) {
                    throw e2;
                }
                this.io = new ConnectionIO(host, port, connectStr, this.charset, hashKey, 2, this.password, this.useSSL, this.logVersionDate, this.autoCommit, this.rebuildConnection, this.validateFrequency, this.validatePerTimes, this.validateConAlive, this.slowSQLBean, this.connectTimeOut);
            }
        } else {
            this.io = new ConnectionIO(host, port, connectStr, this.charset, "", 0, this.password, this.useSSL, this.logVersionDate, this.autoCommit, this.rebuildConnection, this.validateFrequency, this.validatePerTimes, this.validateConAlive, this.slowSQLBean, this.connectTimeOut);
        }
        if (!this.useBatchByPreson && !this.is301Protocol()) {
            this.useBatch = false;
        }
        this.info.setIp(this.io.getServerIp());
        this.info.setPort(String.valueOf(this.io.getServerPort()));
        this.clientProps = this.info.getClientInfoPros();
        if (this.io != null) {
            this.conIsClosed = this.io.getIsClosed();
        }
        this.openStatements = new HashMap();
        if (wMap == null) {
            wMap = new HashMap();
            wMap.put(99, "create".getBytes());
            wMap.put(100, "drop".getBytes());
            wMap.put(116, "truncate".getBytes());
            wMap.put(97, "alter".getBytes());
        }
        if (this.logVersionDate) {
            this.io.lw.write("version date: " + ReplaceEnum.jdbcVersionDateString.getReplaceStr());
        }
        if (Command.debug) {
            Command.logLoginUrlStr(this.io, connectStr);
        }
        this.initObjectTypes();
    }

    Connection(String host, int port, Properties pro) throws SQLException {
        this.props = pro;
        this._xugu();
        this.io = new ConnectionIO(host, port, this.formConnectString(), this.charset, "", 0, this.password, this.useSSL, this.logVersionDate, this.autoCommit, this.rebuildConnection, this.validateFrequency, this.validatePerTimes, this.validateConAlive, this.slowSQLBean, this.connectTimeOut);
        if (this.io != null) {
            this.conIsClosed = this.io.getIsClosed();
        }
        this.openStatements = new HashMap();
    }

    private void _xugu() {
        this.database = this.props.getProperty("database");
        this.info.setDatabase(this.database);
        this.user = this.props.getProperty("user");
        this.info.setUser(this.user);
        this.password = this.props.getProperty("password");
        this.info.setPassword(this.password);
        this.schemaName = this.user;
        this.info.setSchemaName(this.schemaName);
        if (this.database == null) {
            this.sqlE = Error.createSQLException("[E50015]URL \u8fde\u63a5\u5b57\u7b26\u4e32\u4e2d\u6ca1\u6709\u6570\u636e\u5e93", ReplaceEnum.excStr.getReplaceStr() + 50015, 50015);
        }
        if (this.user == null) {
            this.sqlE = Error.createSQLException("[E50016]URL \u8fde\u63a5\u5b57\u7b26\u4e32\u4e2d\u6ca1\u6709\u7528\u6237", ReplaceEnum.excStr.getReplaceStr() + 50016, 50016);
        }
        if (this.password == null) {
            this.sqlE = Error.createSQLException("[E50017]URL \u8fde\u63a5\u5b57\u7b26\u4e32\u4e2d\u6ca1\u6709\u5bc6\u7801", ReplaceEnum.excStr.getReplaceStr() + 50017, 50017);
        }
        if (this.version == null) {
            this.sqlE = Error.createSQLException("[E50018]URL \u8fde\u63a5\u5b57\u7b26\u4e32\u4e2d\u6ca1\u6709\u670d\u52a1\u5668\u7248\u672c\u4fe1\u606f", ReplaceEnum.excStr.getReplaceStr() + 50018, 50018);
        }
        if (this.props.getProperty("encryptor") != null) {
            this.encryptor = this.props.getProperty("encryptor");
            this.info.setEncryptor(this.encryptor);
        }
        if (this.props.getProperty("char_set") != null) {
            this.charset = this.props.getProperty("char_set").toLowerCase();
            if (this.charset.equals("utf-8")) {
                this.charset = "utf8";
            } else if ("gb18030_2022".equalsIgnoreCase(this.charset) || "gb18030".equalsIgnoreCase(this.charset)) {
                this.charset = "gb18030";
            }
            this.info.setCharSet(this.charset);
        }
        if (this.props.getProperty("lob_ret") != null) {
            this.lob_ret = this.props.getProperty("lob_ret");
            this.info.setLobRet(this.lob_ret);
        }
        if (this.props.getProperty("time_zone") != null) {
            this.timeZone = this.props.getProperty("time_zone");
            this.info.setTimeZone(this.timeZone);
        }
        if (this.props.getProperty("iso_level") != null) {
            this.isoLevel = this.props.getProperty("iso_level");
            this.info.setIsoLevel(this.isoLevel);
        }
        if (this.props.getProperty("lock_timeout") != null) {
            this.lockTimeout = this.props.getProperty("lock_timeout");
            this.info.setLockTimeout(this.lockTimeout);
        }
        if (this.props.getProperty("recv_mode") != null) {
            this.recv_mode = Integer.parseInt(this.props.getProperty("recv_mode"));
            this.info.setRecvMode(String.valueOf(this.recv_mode));
        }
        if (this.props.getProperty("auto_commit") != null) {
            if (this.props.getProperty("auto_commit").equalsIgnoreCase("off")) {
                this.autoCommit = false;
            }
            this.info.setAutoCommit(this.props.getProperty("auto_commit"));
        }
        if (this.props.getProperty("return_rowid") != null) {
            this.return_rowid = Boolean.valueOf(this.props.getProperty("return_rowid"));
            this.info.setReturnRowid(this.props.getProperty("return_rowid"));
        }
        if (this.props.getProperty("is_debug") != null) {
            Command.debug = Boolean.valueOf(this.props.getProperty("is_debug"));
        }
        if (this.props.getProperty("recv_type") != null) {
            this.discadeRow = Boolean.valueOf(this.props.getProperty("recv_type"));
        }
        if (this.props.getProperty("batch_mode") != null) {
            this.useBatch = Boolean.parseBoolean(this.props.getProperty("batch_mode"));
            this.info.setUseBatch(String.valueOf(this.useBatch));
            this.useBatchByPreson = true;
        }
        if (this.props.getProperty("uselike") != null) {
            this.useLike = Boolean.valueOf(this.props.getProperty("uselike"));
            this.info.setUseLike(String.valueOf(this.useLike));
        }
        if (this.props.getProperty("iscompatibleqx") != null) {
            this.compatibleQX = Boolean.valueOf(this.props.getProperty("iscompatibleqx"));
        }
        if (this.props.getProperty("compatiblemode") != null) {
            this.compatibleMode = this.props.getProperty("compatiblemode");
        }
        if (this.props.getProperty("islogversion") != null) {
            this.logVersionDate = Boolean.valueOf(this.props.getProperty("islogversion"));
        }
        if (this.props.getProperty("isprintversion") != null && Boolean.valueOf(this.props.getProperty("isprintversion")).booleanValue() && ++printVersionTimes % 100000 == 0) {
            printVersionTimes = 0;
        }
        if (this.props.getProperty("compatibleoracle") != null) {
            this.isora = Boolean.valueOf(this.props.getProperty("compatibleoracle"));
            this.info.setCompatibleOracle(this.props.getProperty("compatibleoracle"));
        }
        if (this.props.getProperty("compatiblemysql") != null) {
            this.ismysql = Boolean.valueOf(this.props.getProperty("compatiblemysql"));
            this.info.setCompatibleMysql(this.props.getProperty("compatiblemysql"));
        }
        if (this.props.getProperty("emptystringasnull") != null) {
            this.emptyStringAsNull = Boolean.valueOf(this.props.getProperty("emptystringasnull"));
            this.info.setEmptyStringAsNull(this.props.getProperty("emptystringasnull"));
        }
        if (this.props.getProperty("rebuilconnection") != null) {
            this.rebuildConnection = Boolean.valueOf(this.props.getProperty("rebuilconnection"));
            this.info.setRebuildConnection(this.props.getProperty("rebuilconnection"));
        }
        if (this.props.getProperty("curfetchsize") != null) {
            this.cursorFetchSize = Integer.parseInt(this.props.getProperty("curfetchsize"));
            this.info.setCurFetchSize(this.props.getProperty("curfetchsize"));
        }
        if (this.props.getProperty("xgversion") != null) {
            this.version = this.props.getProperty("xgversion");
            this.info.setVersion(this.version);
        }
        if (this.props.getProperty("ddlprepare") != null) {
            this.ddlPrepare = Boolean.valueOf(this.props.getProperty("ddlprepare"));
            this.info.setDdlPrepare(this.props.getProperty("ddlprepare"));
        }
        if (this.props.getProperty("validatefrequency") != null) {
            this.validateFrequency = Integer.parseInt(this.props.getProperty("validatefrequency"));
            this.info.setValidateFrequency(this.props.getProperty("validatefrequency"));
        }
        if (this.props.getProperty("validateconalive") != null) {
            this.validateConAlive = Boolean.valueOf(this.props.getProperty("validateconalive"));
            this.info.setValidateConAlive(this.props.getProperty("validateconalive"));
        }
        if (this.props.getProperty("validatetimes") != null) {
            this.validatePerTimes = Integer.parseInt(this.props.getProperty("validatetimes"));
            this.info.setValidatePerTimes(this.props.getProperty("validatetimes"));
        }
        if (this.props.getProperty("slowsqltime") != null) {
            this.slowSQLRecordTime = Integer.valueOf(this.props.getProperty("slowsqltime"));
            this.info.setSlowSQLRecord(this.props.getProperty("slowsqltime"));
        }
        if (this.props.getProperty("schemaon") != null) {
            boolean schemaOn = Boolean.valueOf(this.props.getProperty("schemaon"));
            this.return_schema = schemaOn ? "on" : "off";
            this.info.setSlowSQLRecord(this.props.getProperty("slowsqltime"));
        }
        if (this.props.getProperty("closecurrresult") != null) {
            this.closeCurrResult = Boolean.valueOf(this.props.getProperty("closecurrresult"));
            this.info.setCloseCurrResult(this.props.getProperty("closecurrresult"));
        }
        if (this.props.getProperty("resultkeepsize") != null) {
            this.resultkeepsize = Integer.parseInt(this.props.getProperty("resultkeepsize"));
            this.info.setResultKeepSize(this.props.getProperty("resultkeepsize"));
        }
        if (this.props.getProperty("benchmarkmode") != null) {
            this.benchmarkMode = Boolean.valueOf(this.props.getProperty("benchmarkmode"));
            this.info.setBenchmarkMode(this.props.getProperty("benchmarkmode"));
        }
        if (this.props.getProperty("benchmarkmodewid") != null) {
            this.benchmarkModeWid = Boolean.valueOf(this.props.getProperty("benchmarkmodewid"));
        }
        if (this.props.getProperty("issto") != null) {
            this.isSto = Boolean.valueOf(this.props.getProperty("issto"));
        }
        if (this.props.getProperty("cursorfirstsize") != null) {
            this.cursorFirstSize = Integer.parseInt(this.props.getProperty("cursorfirstsize"));
            this.info.setCurFirstSize(this.props.getProperty("cursorfirstsize"));
        }
        if (this.props.getProperty("insertbatchmode") != null) {
            boolean insertMode = Boolean.parseBoolean(this.props.getProperty("insertbatchmode"));
            this.batchOrMoreResultMode = insertMode ? 1 : 0;
        }
        if (this.props.getProperty("identity_mode") != null) {
            this.identity_mode = this.props.getProperty("identity_mode");
            this.info.setIdentityMode(this.identity_mode);
        }
        if (this.props.getProperty("keyword_filter") != null) {
            this.keyword_filter = this.props.getProperty("keyword_filter").toUpperCase();
            this.info.setKeywordFilter(this.keyword_filter);
        }
        if (this.props.getProperty("disable_binlog") != null) {
            this.disable_binlog = this.props.getProperty("disable_binlog");
            this.info.setDisableBinlog(this.disable_binlog);
        }
        if (this.props.getProperty("current_schema") != null) {
            this.current_schema = this.props.getProperty("current_schema");
            this.info.setCurrentSchema(this.current_schema);
            this.schemaName = this.current_schema;
            this.info.setSchemaName(this.current_schema);
        }
        if (this.props.getProperty("connect_timeout") != null) {
            this.connectTimeOut = Integer.parseInt(this.props.getProperty("connect_timeout"));
        }
        if (this.props.getProperty("iskernel") != null) {
            this.isdbkernel = Boolean.valueOf(this.props.getProperty("iskernel"));
        }
        if (this.props.getProperty("replaceProcessingEnabled") != null) {
            this.replaceProcessingEnabled = Boolean.valueOf(this.props.getProperty("replaceProcessingEnabled"));
        }
    }

    private String formConnectString() {
        String connectString = "login database='" + this.database + "' user=" + this.user + " password='" + this.password + "' version=" + this.version + " return_schema=" + this.return_schema + " return_cursor_id=on";
        if (this.return_rowid) {
            connectString = connectString + " return_rowid=true";
        }
        if (this.encryptor != null) {
            connectString = connectString + " encryptor=" + this.encryptor;
        }
        if (this.charset != null) {
            connectString = "gb18030".contains(this.charset) ? ("gb18030_2022".equalsIgnoreCase(this.props.getProperty("char_set").toLowerCase()) ? connectString + " char_set=gb18030_2022" : connectString + " char_set=gb18030") : connectString + " char_set=" + this.charset;
        }
        if (this.timeZone != null) {
            connectString = connectString + " time_zone=" + this.timeZone;
        }
        if (this.isoLevel != null) {
            connectString = connectString + " iso_level='" + this.isoLevel + "'";
        }
        if (this.lockTimeout != null) {
            connectString = connectString + " lock_timeout=" + this.lockTimeout;
        }
        if (this.lob_ret != null) {
            connectString = connectString + " lob_ret='" + this.lob_ret + "'";
        }
        if (this.identity_mode != null) {
            connectString = connectString + " identity_mode='" + this.identity_mode + "'";
        }
        if (this.keyword_filter != null) {
            connectString = connectString + " keyword_filter='" + this.keyword_filter + "'";
        }
        if (this.disable_binlog != null) {
            connectString = connectString + " disable_binlog='" + this.disable_binlog + "'";
        }
        connectString = !this.autoCommit ? connectString + " auto_commit=off" : connectString + " auto_commit=on";
        if (this.current_schema != null) {
            connectString = connectString + " current_schema='" + this.current_schema + "'";
        }
        if (this.compatibleMode != null) {
            connectString = connectString + " compatible_mode='" + this.compatibleMode + "'";
        }
        return connectString;
    }

    public String getServerIp() {
        return this.io.getServerIp();
    }

    public int getServerPort() {
        return this.io.getServerPort();
    }

    public String getDataBase() {
        return this.database;
    }

    void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw Error.createSQLException("[E50020]\u8fde\u63a5\u5df2\u5173\u95ed  checkOpen : repeat time " + this.closeTime, ReplaceEnum.excStr.getReplaceStr() + 50020, 50020);
        }
    }

    void checkCommitMode() throws SQLException {
        if (this.getAutoCommit()) {
            throw Error.createSQLException("[E50050]Connection: \u81ea\u52a8\u63d0\u4ea4\u6a21\u5f0f\u4e0b\uff0c\u4e0d\u5141\u8bb8\u8be5\u64cd\u4f5c\u3002", ReplaceEnum.excStr.getReplaceStr() + 50050, 50050);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getActiveStatementCount() {
        if (this.openStatements != null) {
            Map map = this.openStatements;
            synchronized (map) {
                return this.openStatements.size();
            }
        }
        return 0;
    }

    public void closeAllOpenStatements() throws SQLException {
        SQLException postponedException = null;
        if (this.openStatements != null) {
            Vector currentlyOpenStatements = new Vector();
            Iterator iter = this.openStatements.keySet().iterator();
            while (iter.hasNext()) {
                currentlyOpenStatements.add(iter.next());
            }
            int numStmts = currentlyOpenStatements.size();
            for (int i = 0; i < numStmts; ++i) {
                Statement stmt = (Statement)currentlyOpenStatements.get(i);
                try {
                    stmt.close();
                    continue;
                }
                catch (SQLException sqlEx) {
                    postponedException = sqlEx;
                }
            }
            if (postponedException != null) {
                throw postponedException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerStatement(Statement stmt) {
        Map map = this.openStatements;
        synchronized (map) {
            this.openStatements.put(stmt, stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterStatement(Statement stmt) {
        if (this.openStatements != null) {
            Map map = this.openStatements;
            synchronized (map) {
                this.openStatements.remove(stmt);
                stmt = null;
            }
        }
    }

    @Override
    public java.sql.Statement createStatement() throws SQLException {
        return this.createStatement(1004, 1007);
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1004, 1007);
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql) throws SQLException {
        String preSql = sql;
        return this.prepareCall(preSql, 1004, 1007);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        this.checkSQLNull(sql);
        try {
            String string = new String(sql.getBytes(this.getCharSet()));
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommitFlag) throws SQLException {
        this.checkOpen();
        if (this.autoCommit != autoCommitFlag) {
            int i;
            block7: {
                String autoCommitCmd = null;
                MessageFormat messageFormat = null;
                messageFormat = autoCommitFlag ? new MessageFormat(SQLCommon.getProperties().getProperty("Connection.setAutoCommitOn")) : new MessageFormat(SQLCommon.getProperties().getProperty("Connection.setAutoCommitOff"));
                autoCommitCmd = messageFormat.format(null);
                i = 0;
                try {
                    i = this.io.executeOther(autoCommitCmd, 0);
                }
                catch (SQLException e) {
                    if (autoCommitFlag) break block7;
                    throw e;
                }
            }
            if (i != 0) {
                if (this.getConnState() == 1) {
                    throw Error.createSQLException("[E50021]\u4e0e\u670d\u52a1\u5668\u91cd\u65b0\u5efa\u7acb\u8fde\u63a5\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u7f51\u7edc\u53d1\u751f\u95ea\u65ad\n2.\u670d\u52a1\u5668\u91cd\u542f\n3.\u8fde\u63a5\u8d85\u65f6", ReplaceEnum.excStr.getReplaceStr() + 50021, 50021);
                }
                if (this.getConnState() == -1 && !autoCommitFlag) {
                    throw Error.createSQLException("[E50022]\u4e0e\u670d\u52a1\u5668\u95f4\u7684\u8fde\u63a5\u5df2\u7ecf\u65ad\u5f00,\u53ef\u80fd\u539f\u56e0:\n1.\u957f\u65f6\u95f4\u65e0\u52a8\u4f5c\u54cd\u5e94\n2.\u7f51\u7edc\u65ad\u5f00\n3.\u670d\u52a1\u5668\u5173\u95ed", ReplaceEnum.excStr.getReplaceStr() + 50022, 50022);
                }
            } else {
                this.autoCommit = autoCommitFlag;
            }
            this.io.setIOAutoCommit(autoCommitFlag);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        int i;
        block5: {
            this.checkOpen();
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("Connection.commit"));
            String commitCmd = this.messageFormat.format(null);
            i = 0;
            try {
                i = this.io.executeOther(commitCmd, 0);
            }
            catch (SQLException e) {
                if (e.getCause() == null || !e.getCause().getMessage().equalsIgnoreCase("Send")) break block5;
                throw e;
            }
        }
        if (i == -2) {
            if (this.io.getConnState() == 1) {
                throw Error.createSQLException("[E50021]\u4e0e\u670d\u52a1\u5668\u91cd\u65b0\u5efa\u7acb\u8fde\u63a5\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u7f51\u7edc\u53d1\u751f\u95ea\u65ad\n2.\u670d\u52a1\u5668\u91cd\u542f\n3.\u8fde\u63a5\u8d85\u65f6", ReplaceEnum.excStr.getReplaceStr() + 50021, 50021);
            }
            if (this.io.getConnState() == -1) {
                throw Error.createSQLException("[E50022]\u4e0e\u670d\u52a1\u5668\u95f4\u7684\u8fde\u63a5\u5df2\u7ecf\u65ad\u5f00,\u53ef\u80fd\u539f\u56e0:\n1.\u957f\u65f6\u95f4\u65e0\u52a8\u4f5c\u54cd\u5e94\n2.\u7f51\u7edc\u65ad\u5f00\n3.\u670d\u52a1\u5668\u5173\u95ed", ReplaceEnum.excStr.getReplaceStr() + 50022, 50022);
            }
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        this.checkCommitMode();
        this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("Connection.rollback"));
        String commitCmd = this.messageFormat.format(null);
        int i = this.io.executeOther(commitCmd, 0);
        if (i == -2) {
            if (this.io.getConnState() == 1) {
                throw Error.createSQLException("[E50021]\u4e0e\u670d\u52a1\u5668\u91cd\u65b0\u5efa\u7acb\u8fde\u63a5\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u7f51\u7edc\u53d1\u751f\u95ea\u65ad\n2.\u670d\u52a1\u5668\u91cd\u542f\n3.\u8fde\u63a5\u8d85\u65f6", ReplaceEnum.excStr.getReplaceStr() + 50021, 50021);
            }
            if (this.io.getConnState() == -1) {
                throw Error.createSQLException("[E50022]\u4e0e\u670d\u52a1\u5668\u95f4\u7684\u8fde\u63a5\u5df2\u7ecf\u65ad\u5f00,\u53ef\u80fd\u539f\u56e0:\n1.\u957f\u65f6\u95f4\u65e0\u52a8\u4f5c\u54cd\u5e94\n2.\u7f51\u7edc\u65ad\u5f00\n3.\u670d\u52a1\u5668\u5173\u95ed", ReplaceEnum.excStr.getReplaceStr() + 50022, 50022);
            }
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (Command.debug) {
            Command.logCloseMethods(this.io, "Connection ");
        }
        try {
            if (this.lobStatement != null) {
                this.lobStatement.close();
                this.lobStatement = null;
            }
            if (this.lobConn != null) {
                this.lobConn.close();
                this.lobConn = null;
            }
            if (this.lobVector.size() != 0) {
                for (int i = 0; i < this.lobVector.size(); ++i) {
                    Clob clob = (Clob)this.lobVector.remove(i);
                    clob.free();
                    Object var2_3 = null;
                }
                this.lobVector = null;
            }
            if (this.clientProps != null) {
                this.clientProps = null;
            }
            if (!this.getAutoCommit()) {
                this.rollback();
            }
            this.closeAllOpenStatements();
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            if (this.io != null) {
                this.io.close();
                this.io = null;
            }
            this.conIsClosed = true;
            ++this.closeTime;
            this.openStatements = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.conIsClosed || this.io.getIsClosed();
    }

    @Override
    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return new DatabaseMetaData(this, this.database);
    }

    @Override
    public void setReadOnly(boolean readOnlyFlag) throws SQLException {
        this.checkOpen();
        this.readOnly = readOnlyFlag;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        if (catalog == null || catalog.trim().length() == 0) {
            throw Error.createSQLException("[E50023]Connection: \u6570\u636e\u5e93\u540d\u4e0d\u80fd\u4e3aNULL.", ReplaceEnum.excStr.getReplaceStr() + 50023, 50023);
        }
        if (this.database.equals(catalog)) {
            return;
        }
        Object object = this.io.getMutex();
        synchronized (object) {
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("Connection.setCatalog"));
            String changeCatalogCmd = this.messageFormat.format(new String[]{catalog});
            this.io.executeOther(changeCatalogCmd, 0);
            this.database = catalog;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this.database;
    }

    public String getUser() throws SQLException {
        this.checkOpen();
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int isoLevel) throws SQLException {
        IsoLevel level;
        this.checkOpen();
        if (isoLevel == 8) {
            isoLevel = 2;
        }
        if ((level = iosLevelMap.get(isoLevel)) == null) {
            throw Error.createSQLException("[E51021]" + ReplaceEnum.excCHNStr.getReplaceStr() + "\u6570\u636e\u5e93\u6682\u4e0d\u652f\u6301\u8be5\u9694\u79bb\u7ea7\u522b", ReplaceEnum.excStr.getReplaceStr() + 51022, 51022);
        }
        Object object = this.io.getMutex();
        synchronized (object) {
            this.messageFormat = new MessageFormat(SQLCommon.properties.getProperty("Connection.setTransactionIsolation"));
            String isoLevelCmd = this.messageFormat.format(new String[]{String.valueOf(level.levelNum)});
            this.io.executeOther(isoLevelCmd, 0);
            this.isoLevelNum = isoLevel;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        int dbIsoLevel = 0;
        if (this.isoLevelNum != -1) {
            dbIsoLevel = this.isoLevelNum;
        } else {
            IsoLevel level = null;
            IsoLevel[] list = IsoLevel.values();
            for (IsoLevel iosLevel : list) {
                if (!iosLevel.getLevelName().equals(this.isoLevel)) continue;
                level = iosLevel;
                break;
            }
            for (Integer key : iosLevelMap.keySet()) {
                if (!iosLevelMap.get(key).equals((Object)level)) continue;
                dbIsoLevel = key;
                break;
            }
        }
        return dbIsoLevel == 9 ? 2 : dbIsoLevel;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkOpen();
        if (this.typeMap == null) {
            this.typeMap = new HashMap(10);
        }
        return this.typeMap;
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.RsHoldablity;
    }

    @Override
    public java.sql.Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        this.checkCommitMode();
        Savepoint saveP = new Savepoint();
        this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("Connection.setSavepoint"));
        String sql = this.messageFormat.format(new String[]{saveP.getSavepointName()});
        this.io.executeOther(sql, 0);
        return saveP;
    }

    @Override
    public synchronized java.sql.Savepoint setSavepoint(String name) throws SQLException {
        this.checkOpen();
        this.checkCommitMode();
        Savepoint saveP = new Savepoint("\"" + name + "\"");
        this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("Connection.setSavepoint"));
        String sql = this.messageFormat.format(new String[]{saveP.getSavepointName()});
        this.io.executeOther(sql, 0);
        return saveP;
    }

    @Override
    public void rollback(java.sql.Savepoint savepoint) throws SQLException {
        this.checkOpen();
        this.checkCommitMode();
        if (savepoint != null) {
            Savepoint svpt = (Savepoint)savepoint;
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("Connection.rollbackSavepoint"));
            String sql = this.messageFormat.format(new String[]{svpt.getSavepointName()});
            this.io.executeOther(sql, 0);
        }
    }

    @Override
    public void releaseSavepoint(java.sql.Savepoint savepoint) throws SQLException {
        this.checkOpen();
        if (savepoint != null) {
            Savepoint svpt = (Savepoint)savepoint;
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("Connection.releasesavepoint"));
            String sql = this.messageFormat.format(new String[]{svpt.getSavepointName()});
            this.io.executeOther(sql, 0);
        }
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        switch (resultSetType) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw Error.createSQLException("[E51022]Connection: \u7ed9\u5b9a\u53c2\u6570\u4e0d\u662f\u6307\u793a\u7c7b\u578b\u3001\u5e76\u53d1\u6027\u548c\u53ef\u4fdd\u5b58\u6027\u7684 ResultSet \u5e38\u91cf", ReplaceEnum.excStr.getReplaceStr() + 51022, 51022);
            }
        }
        switch (resultSetConcurrency) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                throw Error.createSQLException("[E51022]Connection: \u7ed9\u5b9a\u53c2\u6570\u4e0d\u662f\u6307\u793a\u7c7b\u578b\u3001\u5e76\u53d1\u6027\u548c\u53ef\u4fdd\u5b58\u6027\u7684 ResultSet \u5e38\u91cf", ReplaceEnum.excStr.getReplaceStr() + 51022, 51022);
            }
        }
        switch (resultSetHoldability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw Error.createSQLException("[E51022]Connection: \u7ed9\u5b9a\u53c2\u6570\u4e0d\u662f\u6307\u793a\u7c7b\u578b\u3001\u5e76\u53d1\u6027\u548c\u53ef\u4fdd\u5b58\u6027\u7684 ResultSet \u5e38\u91cf", ReplaceEnum.excStr.getReplaceStr() + 51022, 51022);
            }
        }
        Statement statement = new Statement(this, this.database, true);
        statement.setResultSetType(resultSetType);
        statement.setResultSetConcurrency(resultSetConcurrency);
        statement.setResultSetHoldability(resultSetHoldability);
        statement.setRecv_mode(this.recv_mode);
        statement.setRecv_type(this.discadeRow);
        return statement;
    }

    java.sql.Statement createStatement(boolean closeRS) throws SQLException {
        this.checkOpen();
        Statement statement = new Statement(this, this.database, closeRS);
        statement.setStmIsOver(false);
        return statement;
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        PreparedStatement pStatement = null;
        switch (resultSetType) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw Error.createSQLException("[E51022]Connection: \u7ed9\u5b9a\u53c2\u6570\u4e0d\u662f\u6307\u793a\u7c7b\u578b\u3001\u5e76\u53d1\u6027\u548c\u53ef\u4fdd\u5b58\u6027\u7684 ResultSet \u5e38\u91cf", ReplaceEnum.excStr.getReplaceStr() + 51022, 51022);
            }
        }
        switch (resultSetConcurrency) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                throw Error.createSQLException("[E51022]Connection: \u7ed9\u5b9a\u53c2\u6570\u4e0d\u662f\u6307\u793a\u7c7b\u578b\u3001\u5e76\u53d1\u6027\u548c\u53ef\u4fdd\u5b58\u6027\u7684 ResultSet \u5e38\u91cf", ReplaceEnum.excStr.getReplaceStr() + 51022, 51022);
            }
        }
        switch (resultSetHoldability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw Error.createSQLException("[E51022]Connection: \u7ed9\u5b9a\u53c2\u6570\u4e0d\u662f\u6307\u793a\u7c7b\u578b\u3001\u5e76\u53d1\u6027\u548c\u53ef\u4fdd\u5b58\u6027\u7684 ResultSet \u5e38\u91cf", ReplaceEnum.excStr.getReplaceStr() + 51022, 51022);
            }
        }
        if (sql != null && this.replaceProcessingEnabled && this.io.getServerProtocolVersion() >= 401) {
            sql = Parser.replaceProcessing(sql);
        }
        pStatement = new PreparedStatement(this, this.database, sql, false);
        pStatement.setResultSetType(resultSetType);
        pStatement.setResultSetConcurrency(resultSetConcurrency);
        pStatement.setResultSetHoldability(resultSetHoldability);
        pStatement.setRecv_mode(this.recv_mode);
        pStatement.setPoolable(true);
        if (this.recv_mode != 0) {
            pStatement.setResultSetType(1003);
        }
        return pStatement;
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        switch (resultSetType) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw Error.createSQLException("[E51022]Connection: \u7ed9\u5b9a\u53c2\u6570\u4e0d\u662f\u6307\u793a\u7c7b\u578b\u3001\u5e76\u53d1\u6027\u548c\u53ef\u4fdd\u5b58\u6027\u7684 ResultSet \u5e38\u91cf", ReplaceEnum.excStr.getReplaceStr() + 51022, 51022);
            }
        }
        switch (resultSetConcurrency) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                throw Error.createSQLException("[E51022]Connection: \u7ed9\u5b9a\u53c2\u6570\u4e0d\u662f\u6307\u793a\u7c7b\u578b\u3001\u5e76\u53d1\u6027\u548c\u53ef\u4fdd\u5b58\u6027\u7684 ResultSet \u5e38\u91cf", ReplaceEnum.excStr.getReplaceStr() + 51022, 51022);
            }
        }
        switch (resultSetHoldability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw Error.createSQLException("[E51022]Connection: \u7ed9\u5b9a\u53c2\u6570\u4e0d\u662f\u6307\u793a\u7c7b\u578b\u3001\u5e76\u53d1\u6027\u548c\u53ef\u4fdd\u5b58\u6027\u7684 ResultSet \u5e38\u91cf", ReplaceEnum.excStr.getReplaceStr() + 51022, 51022);
            }
        }
        CallableStatement cStatement = new CallableStatement(this, this.database, sql);
        cStatement.setResultSetType(resultSetType);
        cStatement.setResultSetConcurrency(resultSetConcurrency);
        cStatement.setResultSetHoldability(resultSetHoldability);
        cStatement.setRecv_mode(this.recv_mode);
        cStatement.setPoolable(true);
        return cStatement;
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        PreparedStatement pstm = (PreparedStatement)this.prepareStatement(sql, 1003, 1008);
        pstm.checkGeneratedKey(sql, autoGenKeyIndex);
        if (autoGenKeyIndex == 1) {
            pstm.retrieveGeneratedKeys = true;
        }
        return pstm;
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        PreparedStatement pstm = (PreparedStatement)this.prepareStatement(sql);
        pstm.checkGeneratedKey(sql, 1);
        return pstm;
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        PreparedStatement pstm = (PreparedStatement)this.prepareStatement(sql);
        pstm.checkGeneratedKey(sql, 1);
        return pstm;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkOpen();
        return this.io.getNetworkTimeout();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SET_NETWORK_TIMEOUT_PERM);
        }
        this.checkOpen();
        if (milliseconds < 0) {
            throw Error.createSQLException("[E50070]\u8fde\u63a5\u8d85\u65f6\u65f6\u95f4\u8bbe\u7f6e\u4e0d\u80fd\u5c0f\u4e8e0.", ReplaceEnum.excStr.getReplaceStr() + 50070, 50070);
        }
        if (milliseconds > 0 && executor == null) {
            throw Error.createSQLException("[E50070]\u8fde\u63a5\u8d85\u65f6\u7ebf\u7a0b\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a.", ReplaceEnum.excStr.getReplaceStr() + 50070, 50070);
        }
        this.io.setNetworkTimeout(milliseconds);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        java.sql.Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery(SQLCommon.properties.getProperty("Connection.getSchema"));
        if (!rs.next()) {
            return null;
        }
        String schema = rs.getString(1);
        rs.close();
        stmt.close();
        this.schemaName = schema;
        this.info.setSchemaName(this.schemaName);
        return this.schemaName;
    }

    @Override
    public void abort(Executor executor) {
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw SQLCommon.unSupportException("Connection.createArrayOf", "String,Object[]");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkOpen();
        return OracleMethod.getEmptyBLOB();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkOpen();
        return OracleMethod.getEmptyCLOB();
    }

    @Override
    public java.sql.NClob createNClob() throws SQLException {
        return new NClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return new SQLXml(this);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw SQLCommon.unSupportException("Connection.createStruct", "String,Object[]");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
        this.messageFormat = new MessageFormat(SQLCommon.properties.getProperty("Connection.setSchema"));
        String schemaCmd = this.messageFormat.format(new String[]{schema});
        this.io.executeOther(schemaCmd, 0);
        this.schemaName = schema;
        this.info.setSchemaName(this.schemaName);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkOpen();
        return this.clientProps;
    }

    public ClientInfo getClientInformation() throws SQLException {
        return this.info;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkOpen();
        if (null == name || "".equals(name.trim())) {
            return null;
        }
        return this.clientProps.getProperty(name);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean isAlive = false;
        if (timeout < 0) {
            throw Error.createSQLException("[E50070]\u8fde\u63a5\u68c0\u6d4b\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0.", ReplaceEnum.excStr.getReplaceStr() + 50070, 50070);
        }
        checkConnectionIsValidTimes.incrementAndGet();
        if (!this.conIsClosed) {
            this.messageFormat = new MessageFormat(SQLCommon.properties.getProperty("Connection.setTransactionIsolation"));
            String isoLevelCmd = this.messageFormat.format(new String[]{String.valueOf(1)});
            int oldNetworkTimeout = this.getNetworkTimeout();
            this.setNetworkTimeout(Executors.newSingleThreadExecutor(), timeout * 1000);
            this.io.executeOther(isoLevelCmd, checkConnectionIsValidTimes.get());
            this.setNetworkTimeout(Executors.newSingleThreadExecutor(), oldNetworkTimeout);
            isAlive = true;
        }
        return isAlive;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkOpen();
        }
        catch (SQLException e) {
            throw Error.createClientInfoException(e.getMessage(), e.getErrorCode());
        }
        this.clientProps = properties;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkOpen();
        }
        catch (SQLException e) {
            throw Error.createClientInfoException(e.getMessage(), e.getErrorCode());
        }
        if (null == name || "".equals(name.trim())) {
            throw Error.createClientInfoException(name, value, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        }
        if (null == value) {
            throw Error.createClientInfoException(name, value, ClientInfoStatus.REASON_VALUE_INVALID);
        }
        this.clientProps.setProperty(name, value);
    }

    public void setClose(boolean b) {
        this.conIsClosed = b;
    }

    public int getConnState() {
        return this.io.getConnState();
    }

    public void clearBuffer() {
        if (this.io != null) {
            this.io.clearBuffer();
        }
    }

    public String getCharSet() {
        if (this.charset != null) {
            return this.charset;
        }
        return "GBK";
    }

    boolean getBnechmarkMode() {
        return this.benchmarkMode;
    }

    boolean getBnechmarkModeWid() {
        return this.benchmarkModeWid;
    }

    boolean getIsSto() {
        return this.isSto;
    }

    int getCata_Caps() {
        return this.cata_caps;
    }

    void setCata_caps(int caps) {
        this.cata_caps = caps;
    }

    String getLob_Ret() {
        return this.lob_ret;
    }

    public void sendHalt() throws SQLException {
        this.checkOpen();
        this.io.sendByte((byte)46);
        this.io.setHalt(true);
    }

    String getConnectionUrl() {
        return this.url;
    }

    boolean getReturnRowid() {
        return this.return_rowid;
    }

    public List<ArrayList<String>> parserXml(String fileName, int port) throws SQLException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        ArrayList<ArrayList<String>> ipFileList = new ArrayList<ArrayList<String>>();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(fileName);
            NodeList listenersList = document.getChildNodes();
            for (int m = 0; m < listenersList.getLength(); ++m) {
                Node listeners = listenersList.item(m);
                if (!listeners.getNodeName().equals("listeners")) continue;
                NodeList listenerList = listeners.getChildNodes();
                int childNodesLength = listenerList.getLength();
                for (int i = 0; i < childNodesLength; ++i) {
                    ArrayList<String> perNode = null;
                    Node listener = listenerList.item(i);
                    if (listener.getNodeName().equals("listener")) {
                        NodeList listenerInfo = listener.getChildNodes();
                        int nodePort = 0;
                        String nodeIp = null;
                        for (int j = 0; j < listenerInfo.getLength(); ++j) {
                            Node itemNode = listenerInfo.item(j);
                            if (itemNode.getNodeName().equals("ip")) {
                                nodeIp = itemNode.getTextContent().trim();
                            } else if (itemNode.getNodeName().equals("port")) {
                                nodePort = Integer.parseInt(itemNode.getTextContent().trim());
                            }
                            perNode = nodePort == 0 ? this.CreateAndInitArrayList(nodeIp, port, false) : this.CreateAndInitArrayList(nodeIp, nodePort, false);
                        }
                    }
                    if (perNode == null) continue;
                    ipFileList.add(perNode);
                }
            }
        }
        catch (IOException | NumberFormatException | ParserConfigurationException | DOMException | SAXException e) {
            e.printStackTrace();
        }
        if (ipFileList.size() == 0) {
            throw new SQLException(fileName + "\u4e2d\u65e0\u53ef\u4ee5\u7528IP\u8fde\u63a5");
        }
        return ipFileList;
    }

    public Connection cloneCurConnection() throws SQLException {
        if (this.lobConn == null) {
            this.lobConn = new Connection(this.getServerIp(), this.getServerPort(), this.props);
        }
        return this.lobConn;
    }

    public Statement lobStatement() throws SQLException {
        if (this.lobStatement == null) {
            this.lobStatement = (Statement)this.cloneCurConnection().createStatement();
        }
        return this.lobStatement;
    }

    public Vector<String> getStreamErrorVector() {
        return this.io.getStreamErrVector();
    }

    public boolean getIsStreamEnd() {
        return this.io.getIsRecived();
    }

    private boolean checkSSL(String sslFlag) {
        boolean flag = false;
        if (sslFlag != null && "ssl".equalsIgnoreCase(sslFlag)) {
            this.useSSL = true;
            flag = true;
        } else if (sslFlag != null && "nssl".equalsIgnoreCase(sslFlag)) {
            this.useSSL = false;
            flag = false;
        } else {
            flag = this.useSSL;
        }
        if (!isSSLLoad && this.useSSL) {
            System.loadLibrary("xgssl");
            isSSLLoad = true;
        }
        return flag;
    }

    void addLob(Object lob) {
        this.lobVector.add(lob);
    }

    void removeLob(Object lob) {
        this.lobVector.remove(lob);
    }

    boolean isIsora() {
        return this.isora;
    }

    public void setIsora(boolean isora) {
        this.isora = isora;
    }

    boolean isEmptyStringAsNull() {
        return this.emptyStringAsNull;
    }

    void setEmptyStringAsNull(boolean emptyStringAsNull) {
        this.emptyStringAsNull = emptyStringAsNull;
    }

    public ConnectionIO getIO() {
        return this.io;
    }

    protected int getDatabseMajorVersion() throws SQLException {
        if (this.databaseMajorVersion == 0) {
            this.databaseMajorVersion = this.getMetaData().getDatabaseMajorVersion();
        }
        return this.databaseMajorVersion;
    }

    protected int getDatabseMinorVersion() throws SQLException {
        if (this.databaseMinorVersion == 0) {
            this.databaseMinorVersion = this.getMetaData().getDatabaseMinorVersion();
        }
        return this.databaseMinorVersion;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
        this.checkOpen();
        this.typeMap = arg0;
    }

    protected static synchronized int getRoundIdx(boolean next) {
        if (!next) {
            return roundIdx;
        }
        return roundIdx++;
    }

    protected static synchronized void setRoundIdx(int indexVal) {
        roundIdx = indexVal;
    }

    protected static ScheduledThreadPoolExecutor getValidTaskExecutor() {
        return validTaskExecutor;
    }

    protected static void setValidTaskExecutor(ScheduledThreadPoolExecutor validTask) {
        validTaskExecutor = validTask;
    }

    protected static boolean isValidateFlag() {
        return validateFlag;
    }

    protected static void setValidateFlag(boolean validateFlag) {
        Connection.validateFlag = validateFlag;
    }

    protected ArrayList<String> CreateAndInitArrayList(String ipStr, int port, boolean isNewConn) {
        ArrayList<String> list = null;
        if (ipStr != null) {
            list = new ArrayList<String>();
            list.add(ipStr);
            list.add(String.valueOf(0));
            list.add(String.valueOf(0));
            list.add(String.valueOf(port));
            list.add(String.valueOf(isNewConn));
        }
        return list;
    }

    protected static synchronized boolean isNewConnection() {
        return isNewConnection;
    }

    protected static synchronized void setNewConnection(boolean isNewConnection) {
        Connection.isNewConnection = isNewConnection;
    }

    protected boolean is301Protocol() {
        boolean newProtocol = false;
        if (this.io.getServerProtocolVersion() > 201) {
            newProtocol = true;
        }
        return newProtocol;
    }

    protected boolean checkRecordSlowSQL() {
        boolean slowBoolean = false;
        if (this.slowSQLRecordTime > 0) {
            slowBoolean = true;
        }
        return slowBoolean;
    }

    protected void checkSQLNull(String sql) throws SQLException {
        if (sql == null || sql.trim().length() == 0) {
            throw Error.createSQLException("[E50066]\u6267\u884c\u8bed\u53e5\u4e3aNULL\u6216\u7a7a\u4e32", ReplaceEnum.excStr.getReplaceStr() + 50066, 50066);
        }
    }

    protected int getBatchOrMoreResultMode() {
        return this.batchOrMoreResultMode;
    }

    protected boolean useLobDescribMode() {
        return this.getLob_Ret() != null && this.getLob_Ret().equalsIgnoreCase("descriptor");
    }

    public boolean isUseBatch() {
        return this.useBatch;
    }

    public DBobject getObject(String type, @Nullable String value, byte @Nullable [] byteValue) throws SQLException {
        try {
            DBobject obj = null;
            Class<? extends DBobject> klass = nameToObject.get(type);
            if (klass != null) {
                obj = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                obj.setType(type);
                if (byteValue != null && obj instanceof DBBinaryObject) {
                    DBBinaryObject binObj = (DBBinaryObject)((Object)obj);
                    binObj.setByteValue(byteValue, 0);
                } else {
                    obj.setValue(value);
                }
            } else {
                obj = new DBobject();
                obj.setType(type);
                obj.setValue(value);
            }
            return obj;
        }
        catch (SQLException sx) {
            throw sx;
        }
        catch (Exception ex) {
            throw new SQLException(new IllegalArgumentException("Failed to create object for: " + type + ".", ex));
        }
    }

    private void initObjectTypes() {
        try {
            this.addDataType("POINT", DBpoint.class);
            this.addDataType("LINE", DBline.class);
            this.addDataType("LSEG", DBlseg.class);
            this.addDataType("BOX", DBbox.class);
            this.addDataType("PATH", DBpath.class);
            this.addDataType("POLYGON", DBpolygon.class);
            this.addDataType("CIRCLE", DBcircle.class);
            ClassLoader cl = this.getClass().getClassLoader();
            ArrayList<URL> urls = new ArrayList<URL>();
            Enumeration<URL> urlEnum = cl.getResources("com/xugu/driverconfig.properties");
            while (urlEnum.hasMoreElements()) {
                urls.add(urlEnum.nextElement());
            }
            Properties properties = new Properties();
            for (int i = urls.size() - 1; i >= 0; --i) {
                URL url = (URL)urls.get(i);
                InputStream is = url.openStream();
                properties.load(is);
                is.close();
            }
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                Class<?> klass;
                String propertyName = (String)e.nextElement();
                if (propertyName == null || !propertyName.startsWith("datatype.")) continue;
                String typeName = propertyName.substring(9);
                String className = Nullness.castNonNull(properties.getProperty(propertyName));
                try {
                    klass = Class.forName(className);
                }
                catch (ClassNotFoundException cnfe) {
                    throw Error.createSQLException("sdfsf", "asdfs");
                }
                this.addDataType(typeName.toUpperCase(), klass.asSubclass(DBobject.class));
            }
            properties.clear();
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void initSto() {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Enumeration<URL> urlEnum = cl.getResources("com/xugu/sto/driverconfig.properties");
            if (!urlEnum.hasMoreElements()) {
                throw new SQLException("\u5206\u57df\u4e2d\u95f4\u4ef6\u672a\u52a0\u8f7d\u5f02\u5e38");
            }
            this.isSto = true;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void addDataType(String type, Class<? extends DBobject> klass) throws SQLException {
        this.checkOpen();
        nameToObject.put(type, klass);
    }

    private int getLoginTimeout() {
        int loginTimeoutSecs = DriverManager.getLoginTimeout();
        return Math.max(loginTimeoutSecs, 0);
    }

    protected int getRealTimeout(int expectedTimeout) {
        if (this.connectTimeOut > 0 && (expectedTimeout == 0 || expectedTimeout > this.connectTimeOut)) {
            return this.connectTimeOut;
        }
        return expectedTimeout;
    }

    static {
        validTaskExecutor = null;
        ipPoolLock = new Object();
        roundIdx = 0;
        iosLevelMap = new HashMap();
        iosLevelMap.put(2, IsoLevel.IOSLEVEL_READCOMMIT);
        iosLevelMap.put(4, IsoLevel.IOSLEVEL_REPEATABLEREAD);
        iosLevelMap.put(8, IsoLevel.IOSLEVEL_SERIALIZABLE);
        iosLevelMap.put(9, IsoLevel.IOSLEVEL_CONSISTENCYREAD);
        day2md = new int[][]{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 9}, {1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 15}, {1, 16}, {1, 17}, {1, 18}, {1, 19}, {1, 20}, {1, 21}, {1, 22}, {1, 23}, {1, 24}, {1, 25}, {1, 26}, {1, 27}, {1, 28}, {1, 29}, {1, 30}, {1, 31}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {2, 9}, {2, 10}, {2, 11}, {2, 12}, {2, 13}, {2, 14}, {2, 15}, {2, 16}, {2, 17}, {2, 18}, {2, 19}, {2, 20}, {2, 21}, {2, 22}, {2, 23}, {2, 24}, {2, 25}, {2, 26}, {2, 27}, {2, 28}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 10}, {3, 11}, {3, 12}, {3, 13}, {3, 14}, {3, 15}, {3, 16}, {3, 17}, {3, 18}, {3, 19}, {3, 20}, {3, 21}, {3, 22}, {3, 23}, {3, 24}, {3, 25}, {3, 26}, {3, 27}, {3, 28}, {3, 29}, {3, 30}, {3, 31}, {4, 1}, {4, 2}, {4, 3}, {4, 4}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {4, 11}, {4, 12}, {4, 13}, {4, 14}, {4, 15}, {4, 16}, {4, 17}, {4, 18}, {4, 19}, {4, 20}, {4, 21}, {4, 22}, {4, 23}, {4, 24}, {4, 25}, {4, 26}, {4, 27}, {4, 28}, {4, 29}, {4, 30}, {5, 1}, {5, 2}, {5, 3}, {5, 4}, {5, 5}, {5, 6}, {5, 7}, {5, 8}, {5, 9}, {5, 10}, {5, 11}, {5, 12}, {5, 13}, {5, 14}, {5, 15}, {5, 16}, {5, 17}, {5, 18}, {5, 19}, {5, 20}, {5, 21}, {5, 22}, {5, 23}, {5, 24}, {5, 25}, {5, 26}, {5, 27}, {5, 28}, {5, 29}, {5, 30}, {5, 31}, {6, 1}, {6, 2}, {6, 3}, {6, 4}, {6, 5}, {6, 6}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {6, 11}, {6, 12}, {6, 13}, {6, 14}, {6, 15}, {6, 16}, {6, 17}, {6, 18}, {6, 19}, {6, 20}, {6, 21}, {6, 22}, {6, 23}, {6, 24}, {6, 25}, {6, 26}, {6, 27}, {6, 28}, {6, 29}, {6, 30}, {7, 1}, {7, 2}, {7, 3}, {7, 4}, {7, 5}, {7, 6}, {7, 7}, {7, 8}, {7, 9}, {7, 10}, {7, 11}, {7, 12}, {7, 13}, {7, 14}, {7, 15}, {7, 16}, {7, 17}, {7, 18}, {7, 19}, {7, 20}, {7, 21}, {7, 22}, {7, 23}, {7, 24}, {7, 25}, {7, 26}, {7, 27}, {7, 28}, {7, 29}, {7, 30}, {7, 31}, {8, 1}, {8, 2}, {8, 3}, {8, 4}, {8, 5}, {8, 6}, {8, 7}, {8, 8}, {8, 9}, {8, 10}, {8, 11}, {8, 12}, {8, 13}, {8, 14}, {8, 15}, {8, 16}, {8, 17}, {8, 18}, {8, 19}, {8, 20}, {8, 21}, {8, 22}, {8, 23}, {8, 24}, {8, 25}, {8, 26}, {8, 27}, {8, 28}, {8, 29}, {8, 30}, {8, 31}, {9, 1}, {9, 2}, {9, 3}, {9, 4}, {9, 5}, {9, 6}, {9, 7}, {9, 8}, {9, 9}, {9, 10}, {9, 11}, {9, 12}, {9, 13}, {9, 14}, {9, 15}, {9, 16}, {9, 17}, {9, 18}, {9, 19}, {9, 20}, {9, 21}, {9, 22}, {9, 23}, {9, 24}, {9, 25}, {9, 26}, {9, 27}, {9, 28}, {9, 29}, {9, 30}, {10, 1}, {10, 2}, {10, 3}, {10, 4}, {10, 5}, {10, 6}, {10, 7}, {10, 8}, {10, 9}, {10, 10}, {10, 11}, {10, 12}, {10, 13}, {10, 14}, {10, 15}, {10, 16}, {10, 17}, {10, 18}, {10, 19}, {10, 20}, {10, 21}, {10, 22}, {10, 23}, {10, 24}, {10, 25}, {10, 26}, {10, 27}, {10, 28}, {10, 29}, {10, 30}, {10, 31}, {11, 1}, {11, 2}, {11, 3}, {11, 4}, {11, 5}, {11, 6}, {11, 7}, {11, 8}, {11, 9}, {11, 10}, {11, 11}, {11, 12}, {11, 13}, {11, 14}, {11, 15}, {11, 16}, {11, 17}, {11, 18}, {11, 19}, {11, 20}, {11, 21}, {11, 22}, {11, 23}, {11, 24}, {11, 25}, {11, 26}, {11, 27}, {11, 28}, {11, 29}, {11, 30}, {12, 1}, {12, 2}, {12, 3}, {12, 4}, {12, 5}, {12, 6}, {12, 7}, {12, 8}, {12, 9}, {12, 10}, {12, 11}, {12, 12}, {12, 13}, {12, 14}, {12, 15}, {12, 16}, {12, 17}, {12, 18}, {12, 19}, {12, 20}, {12, 21}, {12, 22}, {12, 23}, {12, 24}, {12, 25}, {12, 26}, {12, 27}, {12, 28}, {12, 29}, {12, 30}, {12, 31}};
        day2md_rn = new int[][]{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 9}, {1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 15}, {1, 16}, {1, 17}, {1, 18}, {1, 19}, {1, 20}, {1, 21}, {1, 22}, {1, 23}, {1, 24}, {1, 25}, {1, 26}, {1, 27}, {1, 28}, {1, 29}, {1, 30}, {1, 31}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {2, 9}, {2, 10}, {2, 11}, {2, 12}, {2, 13}, {2, 14}, {2, 15}, {2, 16}, {2, 17}, {2, 18}, {2, 19}, {2, 20}, {2, 21}, {2, 22}, {2, 23}, {2, 24}, {2, 25}, {2, 26}, {2, 27}, {2, 28}, {2, 29}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 10}, {3, 11}, {3, 12}, {3, 13}, {3, 14}, {3, 15}, {3, 16}, {3, 17}, {3, 18}, {3, 19}, {3, 20}, {3, 21}, {3, 22}, {3, 23}, {3, 24}, {3, 25}, {3, 26}, {3, 27}, {3, 28}, {3, 29}, {3, 30}, {3, 31}, {4, 1}, {4, 2}, {4, 3}, {4, 4}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {4, 11}, {4, 12}, {4, 13}, {4, 14}, {4, 15}, {4, 16}, {4, 17}, {4, 18}, {4, 19}, {4, 20}, {4, 21}, {4, 22}, {4, 23}, {4, 24}, {4, 25}, {4, 26}, {4, 27}, {4, 28}, {4, 29}, {4, 30}, {5, 1}, {5, 2}, {5, 3}, {5, 4}, {5, 5}, {5, 6}, {5, 7}, {5, 8}, {5, 9}, {5, 10}, {5, 11}, {5, 12}, {5, 13}, {5, 14}, {5, 15}, {5, 16}, {5, 17}, {5, 18}, {5, 19}, {5, 20}, {5, 21}, {5, 22}, {5, 23}, {5, 24}, {5, 25}, {5, 26}, {5, 27}, {5, 28}, {5, 29}, {5, 30}, {5, 31}, {6, 1}, {6, 2}, {6, 3}, {6, 4}, {6, 5}, {6, 6}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {6, 11}, {6, 12}, {6, 13}, {6, 14}, {6, 15}, {6, 16}, {6, 17}, {6, 18}, {6, 19}, {6, 20}, {6, 21}, {6, 22}, {6, 23}, {6, 24}, {6, 25}, {6, 26}, {6, 27}, {6, 28}, {6, 29}, {6, 30}, {7, 1}, {7, 2}, {7, 3}, {7, 4}, {7, 5}, {7, 6}, {7, 7}, {7, 8}, {7, 9}, {7, 10}, {7, 11}, {7, 12}, {7, 13}, {7, 14}, {7, 15}, {7, 16}, {7, 17}, {7, 18}, {7, 19}, {7, 20}, {7, 21}, {7, 22}, {7, 23}, {7, 24}, {7, 25}, {7, 26}, {7, 27}, {7, 28}, {7, 29}, {7, 30}, {7, 31}, {8, 1}, {8, 2}, {8, 3}, {8, 4}, {8, 5}, {8, 6}, {8, 7}, {8, 8}, {8, 9}, {8, 10}, {8, 11}, {8, 12}, {8, 13}, {8, 14}, {8, 15}, {8, 16}, {8, 17}, {8, 18}, {8, 19}, {8, 20}, {8, 21}, {8, 22}, {8, 23}, {8, 24}, {8, 25}, {8, 26}, {8, 27}, {8, 28}, {8, 29}, {8, 30}, {8, 31}, {9, 1}, {9, 2}, {9, 3}, {9, 4}, {9, 5}, {9, 6}, {9, 7}, {9, 8}, {9, 9}, {9, 10}, {9, 11}, {9, 12}, {9, 13}, {9, 14}, {9, 15}, {9, 16}, {9, 17}, {9, 18}, {9, 19}, {9, 20}, {9, 21}, {9, 22}, {9, 23}, {9, 24}, {9, 25}, {9, 26}, {9, 27}, {9, 28}, {9, 29}, {9, 30}, {10, 1}, {10, 2}, {10, 3}, {10, 4}, {10, 5}, {10, 6}, {10, 7}, {10, 8}, {10, 9}, {10, 10}, {10, 11}, {10, 12}, {10, 13}, {10, 14}, {10, 15}, {10, 16}, {10, 17}, {10, 18}, {10, 19}, {10, 20}, {10, 21}, {10, 22}, {10, 23}, {10, 24}, {10, 25}, {10, 26}, {10, 27}, {10, 28}, {10, 29}, {10, 30}, {10, 31}, {11, 1}, {11, 2}, {11, 3}, {11, 4}, {11, 5}, {11, 6}, {11, 7}, {11, 8}, {11, 9}, {11, 10}, {11, 11}, {11, 12}, {11, 13}, {11, 14}, {11, 15}, {11, 16}, {11, 17}, {11, 18}, {11, 19}, {11, 20}, {11, 21}, {11, 22}, {11, 23}, {11, 24}, {11, 25}, {11, 26}, {11, 27}, {11, 28}, {11, 29}, {11, 30}, {12, 1}, {12, 2}, {12, 3}, {12, 4}, {12, 5}, {12, 6}, {12, 7}, {12, 8}, {12, 9}, {12, 10}, {12, 11}, {12, 12}, {12, 13}, {12, 14}, {12, 15}, {12, 16}, {12, 17}, {12, 18}, {12, 19}, {12, 20}, {12, 21}, {12, 22}, {12, 23}, {12, 24}, {12, 25}, {12, 26}, {12, 27}, {12, 28}, {12, 29}, {12, 30}, {12, 31}};
        MTOD = new int[][]{{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365}, {0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366}};
        nameToObject = new HashMap<String, Class<? extends DBobject>>();
    }
}

