/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.RowOperations;
import org.apache.kudu.Schema;
import org.apache.kudu.WireProtocol;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.RangePartition;
import org.apache.kudu.client.RangePartitionBound;
import org.apache.kudu.client.Statistics;
import org.apache.kudu.security.Token;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.shaded.com.google.protobuf.ByteString;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.kudu.tserver.Tserver;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class Operation
extends KuduRpc<OperationResponse> {
    private long rowOperationSizeBytes = 0L;
    static final String METHOD = "Write";
    private PartialRow row;
    private Token.SignedTokenPB authzToken;
    boolean ignoreAllDuplicateRows = false;
    boolean ignoreAllNotFoundRows = false;
    long txnId = -1L;

    Operation(KuduTable table) {
        super(table, null, 0L);
        this.row = table.getSchema().newPartialRow();
    }

    void resetTimeoutMillis(Timer timer, long timeoutMillis) {
        this.timeoutTracker.reset();
        this.timeoutTracker.setTimeout(timeoutMillis);
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.timeoutTask = AsyncKuduClient.newTimeout(timer, new KuduRpc.RpcTimeoutTask(), timeoutMillis);
    }

    void setIgnoreAllDuplicateRows(boolean ignoreAllDuplicateRows) {
        this.ignoreAllDuplicateRows = ignoreAllDuplicateRows;
    }

    void setIgnoreAllNotFoundRows(boolean ignoreAllNotFoundRows) {
        this.ignoreAllNotFoundRows = ignoreAllNotFoundRows;
    }

    void setTxnId(long txnId) {
        this.txnId = txnId;
    }

    abstract ChangeType getChangeType();

    long getRowOperationSizeBytes() {
        if (this.rowOperationSizeBytes == 0L) {
            throw new IllegalStateException("This row hasn't been serialized yet");
        }
        return this.rowOperationSizeBytes;
    }

    @Override
    String serviceName() {
        return "kudu.tserver.TabletServerService";
    }

    @Override
    String method() {
        return METHOD;
    }

    @Override
    boolean needsAuthzToken() {
        return true;
    }

    @Override
    void bindAuthzToken(Token.SignedTokenPB token) {
        this.authzToken = token;
    }

    @Override
    Message createRequestPB() {
        Tserver.WriteRequestPB.Builder builder = Operation.createAndFillWriteRequestPB(ImmutableList.of(this));
        this.rowOperationSizeBytes = (long)builder.getRowOperations().getRows().size() + (long)builder.getRowOperations().getIndirectData().size();
        builder.setTabletId(UnsafeByteOperations.unsafeWrap(this.getTablet().getTabletIdAsBytes()));
        builder.setExternalConsistencyMode(this.externalConsistencyMode.pbVersion());
        if (this.propagatedTimestamp != -1L) {
            builder.setPropagatedTimestamp(this.propagatedTimestamp);
        }
        if (this.authzToken != null) {
            builder.setAuthzToken(this.authzToken);
        }
        if (this.txnId != -1L) {
            builder.setTxnId(this.txnId);
        }
        return builder.build();
    }

    @Override
    Pair<OperationResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Tserver.WriteResponsePB.Builder builder = Tserver.WriteResponsePB.newBuilder();
        Operation.readProtobuf(callResponse.getPBMessage(), builder);
        Tserver.WriteResponsePB.PerRowErrorPB error = null;
        if (builder.getPerRowErrorsCount() != 0) {
            error = builder.getPerRowErrors(0);
            WireProtocol.AppStatusPB.ErrorCode errorCode = error.getError().getCode();
            if (this.ignoreAllDuplicateRows && errorCode == WireProtocol.AppStatusPB.ErrorCode.ALREADY_PRESENT || this.ignoreAllNotFoundRows && errorCode == WireProtocol.AppStatusPB.ErrorCode.NOT_FOUND) {
                error = null;
            }
        }
        Tserver.ResourceMetricsPB metricsPB = builder.hasResourceMetrics() ? builder.getResourceMetrics() : null;
        OperationResponse response = new OperationResponse(this.timeoutTracker.getElapsedMillis(), tsUUID, builder.getTimestamp(), this, error, metricsPB);
        return new Pair<OperationResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }

    @Override
    public byte[] partitionKey() {
        return this.getTable().getPartitionSchema().encodePartitionKey(this.row);
    }

    @Override
    boolean isRequestTracked() {
        return true;
    }

    public PartialRow getRow() {
        return this.row;
    }

    public void setRow(PartialRow row) {
        Preconditions.checkArgument(row.getSchema() == this.table.getSchema(), "The row's schema must be equal by reference to the table schema");
        this.row = row;
    }

    @Override
    void updateStatistics(Statistics statistics, OperationResponse response) {
        String tabletId = this.getTablet().getTabletId();
        String tableName = this.getTable().getName();
        Statistics.TabletStatistics tabletStatistics = statistics.getTabletStatistics(tableName, tabletId);
        if (response == null) {
            tabletStatistics.incrementStatistic(Statistics.Statistic.OPS_ERRORS, 1L);
            tabletStatistics.incrementStatistic(Statistics.Statistic.RPC_ERRORS, 1L);
            return;
        }
        tabletStatistics.incrementStatistic(Statistics.Statistic.WRITE_RPCS, 1L);
        if (response.hasRowError()) {
            tabletStatistics.incrementStatistic(Statistics.Statistic.OPS_ERRORS, 1L);
        } else {
            tabletStatistics.incrementStatistic(Statistics.Statistic.WRITE_OPS, 1L);
        }
        tabletStatistics.incrementStatistic(Statistics.Statistic.BYTES_WRITTEN, this.getRowOperationSizeBytes());
    }

    static Tserver.WriteRequestPB.Builder createAndFillWriteRequestPB(List<Operation> operations) {
        if (operations == null || operations.isEmpty()) {
            return null;
        }
        Schema schema = operations.get((int)0).table.getSchema();
        RowOperations.RowOperationsPB rowOps = new OperationsEncoder().encodeOperations(operations);
        if (rowOps == null) {
            return null;
        }
        Tserver.WriteRequestPB.Builder requestBuilder = Tserver.WriteRequestPB.newBuilder();
        requestBuilder.setSchema(ProtobufHelper.schemaToPb(schema, EnumSet.of(ProtobufHelper.SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_COMMENT, ProtobufHelper.SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_ID)));
        requestBuilder.setRowOperations(rowOps);
        return requestBuilder;
    }

    static class OperationsDecoder {
        private Schema schema;
        private int columnBitmapSize;
        private int columnCount;

        OperationsDecoder() {
        }

        private void init(Schema schema) {
            this.schema = schema;
            this.columnCount = schema.getColumnCount();
            this.columnBitmapSize = Bytes.getBitSetSize(this.columnCount);
        }

        public List<RangePartition> decodeRangePartitions(RowOperations.RowOperationsPB pb, Schema schema) {
            if (pb == null) {
                return null;
            }
            if (!pb.hasRows()) {
                throw new IllegalArgumentException("row operation PB lacks 'rows' field");
            }
            this.init(schema);
            ByteBuffer rowsBuf = ByteBuffer.wrap(pb.getRows().toByteArray());
            rowsBuf.order(ByteOrder.LITTLE_ENDIAN);
            byte[] indirectData = pb.getIndirectData().toByteArray();
            ArrayList<Pair<PartialRow, RowOperations.RowOperationsPB.Type>> decodedBounds = new ArrayList<Pair<PartialRow, RowOperations.RowOperationsPB.Type>>();
            while (rowsBuf.hasRemaining()) {
                decodedBounds.add(this.decodeBound(rowsBuf, indirectData));
            }
            if (decodedBounds.size() % 2 != 0) {
                throw new IllegalArgumentException("unexpected odd number of range partition bounds");
            }
            ArrayList<RangePartition> result = new ArrayList<RangePartition>();
            for (int i = 0; i < decodedBounds.size(); i += 2) {
                RangePartitionBound upperType;
                RangePartitionBound lowerType;
                Pair lower = (Pair)decodedBounds.get(i);
                Pair upper = (Pair)decodedBounds.get(i + 1);
                if (lower.getSecond() == RowOperations.RowOperationsPB.Type.EXCLUSIVE_RANGE_LOWER_BOUND) {
                    lowerType = RangePartitionBound.EXCLUSIVE_BOUND;
                } else if (lower.getSecond() == RowOperations.RowOperationsPB.Type.RANGE_LOWER_BOUND) {
                    lowerType = RangePartitionBound.INCLUSIVE_BOUND;
                } else {
                    throw new IllegalArgumentException(String.format("%s: unexpected bound type for the lower bound", ((RowOperations.RowOperationsPB.Type)lower.getSecond()).toString()));
                }
                if (upper.getSecond() == RowOperations.RowOperationsPB.Type.INCLUSIVE_RANGE_UPPER_BOUND) {
                    upperType = RangePartitionBound.INCLUSIVE_BOUND;
                } else if (upper.getSecond() == RowOperations.RowOperationsPB.Type.RANGE_UPPER_BOUND) {
                    upperType = RangePartitionBound.EXCLUSIVE_BOUND;
                } else {
                    throw new IllegalArgumentException(String.format("%s: unexpected bound type for the upper bound", ((RowOperations.RowOperationsPB.Type)upper.getSecond()).toString()));
                }
                result.add(new RangePartition((PartialRow)lower.getFirst(), (PartialRow)upper.getFirst(), lowerType, upperType));
            }
            return result;
        }

        public Pair<PartialRow, RowOperations.RowOperationsPB.Type> decodeBound(ByteBuffer rowsBuf, byte[] indirectData) {
            RowOperations.RowOperationsPB.Type opType;
            byte opTypeEncoded = rowsBuf.get();
            switch (opTypeEncoded) {
                case 8: {
                    opType = RowOperations.RowOperationsPB.Type.EXCLUSIVE_RANGE_LOWER_BOUND;
                    break;
                }
                case 6: {
                    opType = RowOperations.RowOperationsPB.Type.RANGE_LOWER_BOUND;
                    break;
                }
                case 9: {
                    opType = RowOperations.RowOperationsPB.Type.INCLUSIVE_RANGE_UPPER_BOUND;
                    break;
                }
                case 7: {
                    opType = RowOperations.RowOperationsPB.Type.RANGE_UPPER_BOUND;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%d: unexpected operation type", opTypeEncoded));
                }
            }
            byte[] columnsBitArray = new byte[this.columnBitmapSize];
            rowsBuf.get(columnsBitArray);
            BitSet columnsBitSet = Bytes.toBitSet(columnsBitArray, 0, 8 * this.columnBitmapSize);
            BitSet nullsBitSet = null;
            if (this.schema.hasNullableColumns()) {
                byte[] columnsNullArray = new byte[this.columnBitmapSize];
                rowsBuf.get(columnsNullArray);
                nullsBitSet = Bytes.toBitSet(columnsNullArray, 0, 8 * this.columnBitmapSize);
            }
            PartialRow resultRow = this.schema.newPartialRow();
            for (int i = 0; i < columnsBitSet.size(); ++i) {
                if (!columnsBitSet.get(i) || nullsBitSet != null && nullsBitSet.get(i)) continue;
                ColumnSchema columnSchema = this.schema.getColumnByIndex(i);
                if (columnSchema.getType().isFixedSize()) {
                    byte[] columnData = new byte[columnSchema.getTypeSize()];
                    rowsBuf.get(columnData);
                    resultRow.setRaw(i, columnData);
                    continue;
                }
                int indirectOffset = (int)rowsBuf.getLong();
                int indirectSize = (int)rowsBuf.getLong();
                ByteBuffer auxBuf = ByteBuffer.wrap(indirectData, indirectOffset, indirectSize);
                auxBuf.order(ByteOrder.LITTLE_ENDIAN);
                byte[] columnData = new byte[indirectSize];
                auxBuf.get(columnData);
                resultRow.setRaw(i, columnData);
            }
            return new Pair<PartialRow, RowOperations.RowOperationsPB.Type>(resultRow, opType);
        }
    }

    static class OperationsEncoder {
        private Schema schema;
        private ByteBuffer rows;
        private List<ByteBuffer> indirect;
        private long indirectWrittenBytes;

        OperationsEncoder() {
        }

        private void init(Schema schema, int numOperations) {
            this.schema = schema;
            int columnBitSetSize = Bytes.getBitSetSize(schema.getColumnCount());
            int sizePerRow = 1 + schema.getRowSize() + columnBitSetSize;
            if (schema.hasNullableColumns()) {
                sizePerRow += columnBitSetSize;
            }
            this.rows = ByteBuffer.allocate(sizePerRow * numOperations).order(ByteOrder.LITTLE_ENDIAN);
            this.indirect = new ArrayList<ByteBuffer>(schema.getVarLengthColumnCount() * numOperations);
        }

        private RowOperations.RowOperationsPB toPB() {
            RowOperations.RowOperationsPB.Builder rowOpsBuilder = RowOperations.RowOperationsPB.newBuilder();
            this.rows.limit(this.rows.position());
            this.rows.flip();
            rowOpsBuilder.setRows(ByteString.copyFrom(this.rows));
            if (this.indirect.size() > 0) {
                byte[] indirectData = new byte[(int)this.indirectWrittenBytes];
                int offset = 0;
                for (ByteBuffer bb : this.indirect) {
                    int bbSize = bb.remaining();
                    bb.get(indirectData, offset, bbSize);
                    offset += bbSize;
                }
                rowOpsBuilder.setIndirectData(UnsafeByteOperations.unsafeWrap(indirectData));
            }
            return rowOpsBuilder.build();
        }

        private void encodeRow(PartialRow row, ChangeType type) {
            int columnCount = row.getSchema().getColumnCount();
            BitSet columnsBitSet = row.getColumnsBitSet();
            BitSet nullsBitSet = row.getNullsBitSet();
            if (type == ChangeType.DELETE || type == ChangeType.DELETE_IGNORE) {
                columnCount = row.getSchema().getPrimaryKeyColumnCount();
                columnsBitSet.clear(this.schema.getPrimaryKeyColumnCount(), columnsBitSet.size());
                if (this.schema.hasNullableColumns()) {
                    nullsBitSet.clear(this.schema.getPrimaryKeyColumnCount(), nullsBitSet.size());
                }
            }
            this.rows.put(type.toEncodedByte());
            this.rows.put(Bytes.fromBitSet(columnsBitSet, this.schema.getColumnCount()));
            if (this.schema.hasNullableColumns()) {
                this.rows.put(Bytes.fromBitSet(nullsBitSet, this.schema.getColumnCount()));
            }
            byte[] rowData = row.getRowAlloc();
            int currentRowOffset = 0;
            for (int colIdx = 0; colIdx < columnCount; ++colIdx) {
                ColumnSchema col = this.schema.getColumnByIndex(colIdx);
                if (row.isSet(colIdx) && !row.isSetToNull(colIdx)) {
                    if (col.getType().isFixedSize()) {
                        this.rows.put(rowData, currentRowOffset, col.getTypeSize());
                    } else {
                        ByteBuffer varLengthData = row.getVarLengthData().get(colIdx);
                        varLengthData.reset();
                        this.rows.putLong(this.indirectWrittenBytes);
                        int bbSize = varLengthData.remaining();
                        this.rows.putLong(bbSize);
                        this.indirect.add(varLengthData);
                        this.indirectWrittenBytes += (long)bbSize;
                    }
                }
                currentRowOffset += col.getTypeSize();
            }
        }

        public RowOperations.RowOperationsPB encodeOperations(List<Operation> operations) {
            if (operations == null || operations.isEmpty()) {
                return null;
            }
            this.init(operations.get((int)0).table.getSchema(), operations.size());
            for (Operation operation : operations) {
                this.encodeRow(operation.row, operation.getChangeType());
            }
            return this.toPB();
        }

        public RowOperations.RowOperationsPB encodeRangePartitions(List<RangePartition> rangePartitions, List<PartialRow> splitRows) {
            if (splitRows.isEmpty() && rangePartitions.isEmpty()) {
                return null;
            }
            Schema schema = splitRows.isEmpty() ? rangePartitions.get(0).getLowerBound().getSchema() : splitRows.get(0).getSchema();
            this.init(schema, splitRows.size() + 2 * rangePartitions.size());
            for (PartialRow row : splitRows) {
                this.encodeRow(row, ChangeType.SPLIT_ROWS);
            }
            for (RangePartition partition : rangePartitions) {
                this.encodeRow(partition.getLowerBound(), partition.getLowerBoundType() == RangePartitionBound.INCLUSIVE_BOUND ? ChangeType.RANGE_LOWER_BOUND : ChangeType.EXCLUSIVE_RANGE_LOWER_BOUND);
                this.encodeRow(partition.getUpperBound(), partition.getUpperBoundType() == RangePartitionBound.EXCLUSIVE_BOUND ? ChangeType.RANGE_UPPER_BOUND : ChangeType.INCLUSIVE_RANGE_UPPER_BOUND);
            }
            return this.toPB();
        }

        public RowOperations.RowOperationsPB encodeLowerAndUpperBounds(PartialRow lowerBound, PartialRow upperBound, RangePartitionBound lowerBoundType, RangePartitionBound upperBoundType) {
            this.init(lowerBound.getSchema(), 2);
            this.encodeRow(lowerBound, lowerBoundType == RangePartitionBound.INCLUSIVE_BOUND ? ChangeType.RANGE_LOWER_BOUND : ChangeType.EXCLUSIVE_RANGE_LOWER_BOUND);
            this.encodeRow(upperBound, upperBoundType == RangePartitionBound.EXCLUSIVE_BOUND ? ChangeType.RANGE_UPPER_BOUND : ChangeType.INCLUSIVE_RANGE_UPPER_BOUND);
            return this.toPB();
        }
    }

    static enum ChangeType {
        INSERT((byte)RowOperations.RowOperationsPB.Type.INSERT.getNumber()),
        UPDATE((byte)RowOperations.RowOperationsPB.Type.UPDATE.getNumber()),
        DELETE((byte)RowOperations.RowOperationsPB.Type.DELETE.getNumber()),
        SPLIT_ROWS((byte)RowOperations.RowOperationsPB.Type.SPLIT_ROW.getNumber()),
        UPSERT((byte)RowOperations.RowOperationsPB.Type.UPSERT.getNumber()),
        RANGE_LOWER_BOUND((byte)RowOperations.RowOperationsPB.Type.RANGE_LOWER_BOUND.getNumber()),
        RANGE_UPPER_BOUND((byte)RowOperations.RowOperationsPB.Type.RANGE_UPPER_BOUND.getNumber()),
        EXCLUSIVE_RANGE_LOWER_BOUND((byte)RowOperations.RowOperationsPB.Type.EXCLUSIVE_RANGE_LOWER_BOUND.getNumber()),
        INCLUSIVE_RANGE_UPPER_BOUND((byte)RowOperations.RowOperationsPB.Type.INCLUSIVE_RANGE_UPPER_BOUND.getNumber()),
        INSERT_IGNORE((byte)RowOperations.RowOperationsPB.Type.INSERT_IGNORE.getNumber()),
        UPDATE_IGNORE((byte)RowOperations.RowOperationsPB.Type.UPDATE_IGNORE.getNumber()),
        DELETE_IGNORE((byte)RowOperations.RowOperationsPB.Type.DELETE_IGNORE.getNumber()),
        UPSERT_IGNORE((byte)RowOperations.RowOperationsPB.Type.UPSERT_IGNORE.getNumber());

        private final byte encodedByte;

        private ChangeType(byte encodedByte) {
            this.encodedByte = encodedByte;
        }

        byte toEncodedByte() {
            return this.encodedByte;
        }
    }
}

