/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics.metrics2;

import com.codahale.metrics.MetricRegistry;
import com.github.joshelser.dropwizard.metrics.hadoop.HadoopMetrics2Reporter;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleReporter;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;

public class Metrics2Reporter
implements CodahaleReporter {
    private final Configuration conf;
    private final HadoopMetrics2Reporter reporter;

    public Metrics2Reporter(MetricRegistry registry, Configuration conf) {
        this.conf = conf;
        String applicationName = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METRICS_HADOOP2_COMPONENT_NAME);
        this.reporter = HadoopMetrics2Reporter.forRegistry((MetricRegistry)registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(DefaultMetricsSystem.initialize(applicationName), applicationName, applicationName, "General");
    }

    @Override
    public void start() {
        long reportingInterval = MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.METRICS_HADOOP2_INTERVAL, TimeUnit.SECONDS);
        this.reporter.start(reportingInterval, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        this.reporter.close();
    }
}

