/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.conf;

import org.apache.hadoop.hive.metastore.conf.Validator;

public class SizeValidator
implements Validator {
    private final Long min;
    private final boolean minInclusive;
    private final Long max;
    private final boolean maxInclusive;

    public SizeValidator() {
        this(null, false, null, false);
    }

    public SizeValidator(Long min2, boolean minInclusive, Long max, boolean maxInclusive) {
        this.min = min2;
        this.minInclusive = minInclusive;
        this.max = max;
        this.maxInclusive = maxInclusive;
    }

    @Override
    public void validate(String value) {
        long size = SizeValidator.toSizeBytes(value);
        if (this.min != null && (this.minInclusive ? size < this.min : size <= this.min)) {
            throw new IllegalArgumentException(value + " is smaller than minimum " + this.min + this.sizeString(this.min));
        }
        if (this.max != null && (this.maxInclusive ? size > this.max : size >= this.max)) {
            throw new IllegalArgumentException(value + " is larger than maximum " + this.max + this.sizeString(this.max));
        }
    }

    public String toDescription() {
        Object description = "Expects a byte size value with unit (blank for bytes, kb, mb, gb, tb, pb)";
        if (this.min != null && this.max != null) {
            description = (String)description + ".\nThe size should be in between " + this.sizeString(this.min) + (this.minInclusive ? " (inclusive)" : " (exclusive)") + " and " + this.sizeString(this.max) + (this.maxInclusive ? " (inclusive)" : " (exclusive)");
        } else if (this.min != null) {
            description = (String)description + ".\nThe time should be bigger than " + (this.minInclusive ? "or equal to " : "") + this.sizeString(this.min);
        } else if (this.max != null) {
            description = (String)description + ".\nThe size should be smaller than " + (this.maxInclusive ? "or equal to " : "") + this.sizeString(this.max);
        }
        return description;
    }

    private String sizeString(long size) {
        String[] units = new String[]{" bytes", "Kb", "Mb", "Gb", "Tb"};
        long current = 1L;
        for (int i = 0; i < units.length && current > 0L; ++i) {
            long next = current << 10;
            if ((size & next - 1L) != 0L) {
                return size / current + units[i];
            }
            current = next;
        }
        return current > 0L ? size / current + "Pb" : size + units[0];
    }

    public static long toSizeBytes(String value) {
        String[] parsed = SizeValidator.parseNumberFollowedByUnit(value.trim());
        return Long.parseLong(parsed[0].trim()) * SizeValidator.multiplierFor(parsed[1].trim());
    }

    private static String[] parseNumberFollowedByUnit(String value) {
        int i;
        char[] chars = value.toCharArray();
        for (i = 0; i < chars.length && (chars[i] == '-' || Character.isDigit(chars[i])); ++i) {
        }
        return new String[]{value.substring(0, i), value.substring(i)};
    }

    private static long multiplierFor(String unit) {
        if ((unit = unit.trim().toLowerCase()).isEmpty() || unit.equals("b") || unit.equals("bytes")) {
            return 1L;
        }
        if (unit.equals("kb")) {
            return 1024L;
        }
        if (unit.equals("mb")) {
            return 0x100000L;
        }
        if (unit.equals("gb")) {
            return 0x40000000L;
        }
        if (unit.equals("tb")) {
            return 0x10000000000L;
        }
        if (unit.equals("pb")) {
            return 0x4000000000000L;
        }
        throw new IllegalArgumentException("Invalid size unit " + unit);
    }
}

