/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.atlas.model.PList;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.TimeBoundary;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasStruct;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasClassification
extends AtlasStruct
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String entityGuid = null;
    private AtlasEntity.Status entityStatus = AtlasEntity.Status.ACTIVE;
    private Boolean propagate = null;
    private List<TimeBoundary> validityPeriods = null;
    private Boolean removePropagationsOnEntityDelete = null;

    public AtlasClassification() {
        this(null, null);
    }

    public AtlasClassification(String typeName) {
        this(typeName, null);
    }

    public AtlasClassification(String typeName, Map<String, Object> attributes) {
        super(typeName, attributes);
    }

    public AtlasClassification(String typeName, String attrName, Object attrValue) {
        super(typeName, attrName, attrValue);
    }

    public AtlasClassification(Map map) {
        super(map);
    }

    public AtlasClassification(AtlasClassification other) {
        if (other != null) {
            this.setTypeName(other.getTypeName());
            this.setAttributes(other.getAttributes());
            this.setEntityGuid(other.getEntityGuid());
            this.setEntityStatus(other.getEntityStatus());
            this.setPropagate(other.isPropagate());
            this.setValidityPeriods(other.getValidityPeriods());
            this.setRemovePropagationsOnEntityDelete(other.getRemovePropagationsOnEntityDelete());
        }
    }

    public String getEntityGuid() {
        return this.entityGuid;
    }

    public void setEntityGuid(String entityGuid) {
        this.entityGuid = entityGuid;
    }

    public Boolean isPropagate() {
        return this.propagate;
    }

    public Boolean getPropagate() {
        return this.propagate;
    }

    public void setPropagate(Boolean propagate) {
        this.propagate = propagate;
    }

    public List<TimeBoundary> getValidityPeriods() {
        return this.validityPeriods;
    }

    public void setValidityPeriods(List<TimeBoundary> validityPeriods) {
        this.validityPeriods = validityPeriods;
    }

    public AtlasEntity.Status getEntityStatus() {
        return this.entityStatus;
    }

    public void setEntityStatus(AtlasEntity.Status entityStatus) {
        this.entityStatus = entityStatus;
    }

    public Boolean getRemovePropagationsOnEntityDelete() {
        return this.removePropagationsOnEntityDelete;
    }

    public void setRemovePropagationsOnEntityDelete(Boolean removePropagationsOnEntityDelete) {
        this.removePropagationsOnEntityDelete = removePropagationsOnEntityDelete;
    }

    @JsonIgnore
    public void addValityPeriod(TimeBoundary validityPeriod) {
        List<TimeBoundary> vpList = this.validityPeriods;
        if (vpList == null) {
            this.validityPeriods = vpList = new ArrayList<TimeBoundary>();
        }
        vpList.add(validityPeriod);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasClassification that = (AtlasClassification)o;
        return Objects.equals(this.propagate, that.propagate) && Objects.equals(this.removePropagationsOnEntityDelete, that.removePropagationsOnEntityDelete) && Objects.equals(this.entityGuid, that.entityGuid) && this.entityStatus == that.entityStatus && Objects.equals(this.validityPeriods, that.validityPeriods);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.entityGuid, this.entityStatus, this.propagate, this.removePropagationsOnEntityDelete});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("AtlasClassification{");
        super.toString(sb);
        sb.append("entityGuid='").append(this.entityGuid).append('\'');
        sb.append(", entityStatus=").append((Object)this.entityStatus);
        sb.append(", propagate=").append(this.propagate);
        sb.append(", removePropagationsOnEntityDelete=").append(this.removePropagationsOnEntityDelete);
        sb.append(", validityPeriods=").append(this.validityPeriods);
        sb.append(", validityPeriods=").append(this.validityPeriods);
        sb.append('}');
        return sb.toString();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlSeeAlso(value={AtlasClassification.class})
    public static class AtlasClassifications
    extends PList<AtlasClassification> {
        private static final long serialVersionUID = 1L;

        public AtlasClassifications() {
        }

        public AtlasClassifications(List<AtlasClassification> list) {
            super(list);
        }

        public AtlasClassifications(List list, long startIndex, int pageSize, long totalCount, SearchFilter.SortType sortType, String sortBy) {
            super(list, startIndex, pageSize, totalCount, sortType, sortBy);
        }
    }
}

