/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file;

import com.google.common.cache.Cache;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.file.DispatchingFileFactory;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.blockfile.cache.BlockCache;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;

public abstract class FileOperations {
    private static final HashSet<String> validExtensions = new HashSet<String>(Arrays.asList("map", "rf"));

    public static Set<String> getValidExtensions() {
        return validExtensions;
    }

    public static String getNewFileExtension(AccumuloConfiguration acuconf) {
        return acuconf.get(Property.TABLE_FILE_TYPE);
    }

    public static FileOperations getInstance() {
        return new DispatchingFileFactory();
    }

    protected abstract long getFileSize(GetFileSizeOperation var1) throws IOException;

    protected abstract FileSKVWriter openWriter(OpenWriterOperation var1) throws IOException;

    protected abstract FileSKVIterator openIndex(OpenIndexOperation var1) throws IOException;

    protected abstract FileSKVIterator openScanReader(OpenScanReaderOperation var1) throws IOException;

    protected abstract FileSKVIterator openReader(OpenReaderOperation var1) throws IOException;

    public NeedsFile<GetFileSizeOperationBuilder> getFileSize() {
        return new GetFileSizeOperation();
    }

    public NeedsFileOrOuputStream<OpenWriterOperationBuilder> newWriterBuilder() {
        return new OpenWriterOperation();
    }

    public NeedsFile<OpenIndexOperationBuilder> newIndexReaderBuilder() {
        return new OpenIndexOperation();
    }

    public NeedsFile<NeedsRange<OpenScanReaderOperationBuilder>> newScanReaderBuilder() {
        return new OpenScanReaderOperation();
    }

    public NeedsFile<OpenReaderOperationBuilder> newReaderBuilder() {
        return new OpenReaderOperation();
    }

    public static interface NeedsRange<ReturnType> {
        public ReturnType overRange(Range var1, Set<ByteSequence> var2, boolean var3);
    }

    public static interface NeedsTableConfiguration<ReturnType> {
        public ReturnType withTableConfiguration(AccumuloConfiguration var1);
    }

    public static interface NeedsFileSystem<ReturnType> {
        public NeedsTableConfiguration<ReturnType> inFileSystem(FileSystem var1, Configuration var2);
    }

    public static interface NeedsFileOrOuputStream<ReturnType>
    extends NeedsFile<ReturnType> {
        public NeedsTableConfiguration<ReturnType> forOutputStream(String var1, FSDataOutputStream var2, Configuration var3);
    }

    public static interface NeedsFile<ReturnType> {
        public NeedsTableConfiguration<ReturnType> forFile(String var1, FileSystem var2, Configuration var3);

        public NeedsFileSystem<ReturnType> forFile(String var1);
    }

    public static interface OpenReaderOperationBuilder
    extends FileReaderOperationBuilder<OpenReaderOperationBuilder> {
        public OpenReaderOperationBuilder seekToBeginning();

        public OpenReaderOperationBuilder seekToBeginning(boolean var1);

        public FileSKVIterator build() throws IOException;
    }

    protected class OpenReaderOperation
    extends FileReaderOperation<OpenReaderOperation>
    implements OpenReaderOperationBuilder {
        private boolean seekToBeginning = false;

        protected OpenReaderOperation() {
        }

        @Override
        public OpenReaderOperation seekToBeginning() {
            return this.seekToBeginning(true);
        }

        @Override
        public OpenReaderOperation seekToBeginning(boolean seekToBeginning) {
            this.seekToBeginning = seekToBeginning;
            return this;
        }

        public boolean isSeekToBeginning() {
            return this.seekToBeginning;
        }

        @Override
        public FileSKVIterator build() throws IOException {
            this.validate();
            return FileOperations.this.openReader(this);
        }
    }

    public static interface OpenScanReaderOperationBuilder
    extends FileReaderOperationBuilder<OpenScanReaderOperationBuilder>,
    NeedsRange<OpenScanReaderOperationBuilder> {
        public FileSKVIterator build() throws IOException;
    }

    protected class OpenScanReaderOperation
    extends FileReaderOperation<OpenScanReaderOperation>
    implements OpenScanReaderOperationBuilder {
        private Range range;
        private Set<ByteSequence> columnFamilies;
        private boolean inclusive;

        protected OpenScanReaderOperation() {
        }

        @Override
        public OpenScanReaderOperation overRange(Range range, Set<ByteSequence> columnFamilies, boolean inclusive) {
            this.range = range;
            this.columnFamilies = columnFamilies;
            this.inclusive = inclusive;
            return this;
        }

        public Range getRange() {
            return this.range;
        }

        public Set<ByteSequence> getColumnFamilies() {
            return this.columnFamilies;
        }

        public boolean isRangeInclusive() {
            return this.inclusive;
        }

        @Override
        protected void validate() {
            super.validate();
            Objects.requireNonNull(this.range);
            Objects.requireNonNull(this.columnFamilies);
        }

        @Override
        public FileSKVIterator build() throws IOException {
            this.validate();
            return FileOperations.this.openScanReader(this);
        }
    }

    public static interface OpenIndexOperationBuilder
    extends FileReaderOperationBuilder<OpenIndexOperationBuilder> {
        public FileSKVIterator build() throws IOException;
    }

    protected class OpenIndexOperation
    extends FileReaderOperation<OpenIndexOperation>
    implements OpenIndexOperationBuilder {
        protected OpenIndexOperation() {
        }

        @Override
        public FileSKVIterator build() throws IOException {
            this.validate();
            return FileOperations.this.openIndex(this);
        }
    }

    protected static interface FileReaderOperationBuilder<SubbuilderType>
    extends FileIOOperationBuilder<SubbuilderType> {
        public SubbuilderType withBlockCache(BlockCache var1, BlockCache var2);

        public SubbuilderType withDataCache(BlockCache var1);

        public SubbuilderType withIndexCache(BlockCache var1);

        public SubbuilderType withFileLenCache(Cache<String, Long> var1);
    }

    protected static class FileReaderOperation<SubclassType extends FileReaderOperation<SubclassType>>
    extends FileIOOperation<SubclassType> {
        private BlockCache dataCache;
        private BlockCache indexCache;
        private Cache<String, Long> fileLenCache;

        protected FileReaderOperation() {
        }

        public SubclassType withBlockCache(BlockCache dataCache, BlockCache indexCache) {
            this.dataCache = dataCache;
            this.indexCache = indexCache;
            return (SubclassType)this;
        }

        public SubclassType withDataCache(BlockCache dataCache) {
            this.dataCache = dataCache;
            return (SubclassType)this;
        }

        public SubclassType withIndexCache(BlockCache indexCache) {
            this.indexCache = indexCache;
            return (SubclassType)this;
        }

        public SubclassType withFileLenCache(Cache<String, Long> fileLenCache) {
            this.fileLenCache = fileLenCache;
            return (SubclassType)this;
        }

        public BlockCache getDataCache() {
            return this.dataCache;
        }

        public BlockCache getIndexCache() {
            return this.indexCache;
        }

        public Cache<String, Long> getFileLenCache() {
            return this.fileLenCache;
        }
    }

    public static interface OpenWriterOperationBuilder
    extends FileIOOperationBuilder<OpenWriterOperationBuilder> {
        public OpenWriterOperationBuilder withCompression(String var1);

        public FileSKVWriter build() throws IOException;
    }

    protected class OpenWriterOperation
    extends FileIOOperation<OpenWriterOperation>
    implements OpenWriterOperationBuilder,
    NeedsFileOrOuputStream<OpenWriterOperationBuilder> {
        private String compression;
        private FSDataOutputStream outputStream;

        protected OpenWriterOperation() {
        }

        @Override
        public NeedsTableConfiguration<OpenWriterOperationBuilder> forOutputStream(String extenstion, FSDataOutputStream outputStream, Configuration fsConf) {
            this.outputStream = outputStream;
            this.setConfiguration(fsConf);
            this.setFilename("foo" + extenstion);
            return this;
        }

        @Override
        public OpenWriterOperation withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public String getCompression() {
            return this.compression;
        }

        public FSDataOutputStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        protected void validate() {
            if (this.outputStream == null) {
                super.validate();
            } else {
                Objects.requireNonNull(this.getConfiguration());
                Objects.requireNonNull(this.getTableConfiguration());
            }
        }

        @Override
        public FileSKVWriter build() throws IOException {
            this.validate();
            return FileOperations.this.openWriter(this);
        }
    }

    protected static interface FileIOOperationBuilder<SubbuilderType>
    extends FileAccessOperationBuilder<SubbuilderType> {
        public SubbuilderType withRateLimiter(RateLimiter var1);
    }

    protected static class FileIOOperation<SubclassType extends FileIOOperation<SubclassType>>
    extends FileAccessOperation<SubclassType> {
        private RateLimiter rateLimiter;

        protected FileIOOperation() {
        }

        public SubclassType withRateLimiter(RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
            return (SubclassType)this;
        }

        public RateLimiter getRateLimiter() {
            return this.rateLimiter;
        }
    }

    public static interface GetFileSizeOperationBuilder
    extends FileAccessOperationBuilder<GetFileSizeOperationBuilder> {
        public long execute() throws IOException;
    }

    protected class GetFileSizeOperation
    extends FileAccessOperation<GetFileSizeOperation>
    implements GetFileSizeOperationBuilder {
        protected GetFileSizeOperation() {
        }

        @Override
        public long execute() throws IOException {
            this.validate();
            return FileOperations.this.getFileSize(this);
        }
    }

    protected static interface FileAccessOperationBuilder<SubbuilderType>
    extends NeedsFile<SubbuilderType>,
    NeedsFileSystem<SubbuilderType>,
    NeedsTableConfiguration<SubbuilderType> {
    }

    protected static class FileAccessOperation<SubclassType extends FileAccessOperation<SubclassType>> {
        private AccumuloConfiguration tableConfiguration;
        private String filename;
        private FileSystem fs;
        private Configuration fsConf;

        protected FileAccessOperation() {
        }

        public SubclassType withTableConfiguration(AccumuloConfiguration tableConfiguration) {
            this.tableConfiguration = tableConfiguration;
            return (SubclassType)this;
        }

        public SubclassType forFile(String filename, FileSystem fs, Configuration fsConf) {
            this.filename = filename;
            this.fs = fs;
            this.fsConf = fsConf;
            return (SubclassType)this;
        }

        public SubclassType forFile(String filename) {
            this.filename = filename;
            return (SubclassType)this;
        }

        public SubclassType inFileSystem(FileSystem fs, Configuration fsConf) {
            this.fs = fs;
            this.fsConf = fsConf;
            return (SubclassType)this;
        }

        protected void setFilename(String filename) {
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }

        public FileSystem getFileSystem() {
            return this.fs;
        }

        protected void setConfiguration(Configuration fsConf) {
            this.fsConf = fsConf;
        }

        public Configuration getConfiguration() {
            return this.fsConf;
        }

        public AccumuloConfiguration getTableConfiguration() {
            return this.tableConfiguration;
        }

        protected void validate() {
            Objects.requireNonNull(this.getFilename());
            Objects.requireNonNull(this.getFileSystem());
            Objects.requireNonNull(this.getConfiguration());
            Objects.requireNonNull(this.getTableConfiguration());
        }
    }
}

