/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.util.Map;
import java.util.Properties;
import org.datanucleus.Configuration;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerationManager;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class NucleusSequenceImpl
extends org.datanucleus.store.NucleusSequenceImpl {
    public NucleusSequenceImpl(ExecutionContext objectMgr, RDBMSStoreManager storeMgr, SequenceMetaData seqmd) {
        super(objectMgr, (StoreManager)storeMgr, seqmd);
    }

    public void setGenerator() {
        String valueGeneratorName = null;
        valueGeneratorName = ((RDBMSStoreManager)this.storeManager).getDatastoreAdapter().supportsOption("Sequences") ? ValueGenerationStrategy.SEQUENCE.toString() : ValueGenerationStrategy.INCREMENT.toString();
        Properties props = new Properties();
        Map seqExtensions = this.seqMetaData.getExtensions();
        if (seqExtensions != null && seqExtensions.size() > 0) {
            props.putAll((Map<?, ?>)seqExtensions);
        }
        props.put("sequence-name", this.seqMetaData.getDatastoreSequence());
        if (this.seqMetaData.getAllocationSize() > 0) {
            props.put("key-cache-size", "" + this.seqMetaData.getAllocationSize());
        }
        if (this.seqMetaData.getInitialValue() > 0) {
            props.put("key-initial-value", "" + this.seqMetaData.getInitialValue());
        }
        ValueGenerationManager mgr = this.storeManager.getValueGenerationManager();
        ValueGenerationConnectionProvider connProvider = new ValueGenerationConnectionProvider(){
            ManagedConnection mconn;

            public ManagedConnection retrieveConnection() {
                Configuration conf = NucleusSequenceImpl.this.ec.getNucleusContext().getConfiguration();
                int isolationLevel = TransactionUtils.getTransactionIsolationLevelForName((String)conf.getStringProperty("datanucleus.valuegeneration.transactionisolation"));
                this.mconn = ((RDBMSStoreManager)NucleusSequenceImpl.this.storeManager).getConnectionManager().getConnection(isolationLevel);
                return this.mconn;
            }

            public void releaseConnection() {
                try {
                    this.mconn.release();
                }
                catch (NucleusException e) {
                    NucleusLogger.PERSISTENCE.error((Object)Localiser.msg((String)"017007", (Object[])new Object[]{e}));
                    throw e;
                }
            }
        };
        this.generator = mgr.createValueGenerator(valueGeneratorName, this.seqMetaData.getName(), props, connProvider);
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"017003", (Object[])new Object[]{this.seqMetaData.getName(), valueGeneratorName}));
        }
    }
}

