/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.hll;

import org.apache.datasketches.hive.hll.State;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

class UnionState
extends State {
    private Union union_;

    UnionState() {
    }

    @Override
    boolean isInitialized() {
        return this.union_ != null;
    }

    @Override
    void init(int lgK, TgtHllType type) {
        super.init(lgK, type);
        this.union_ = new Union(lgK);
    }

    @Override
    void update(Object data, PrimitiveObjectInspector objectInspector) {
        switch (objectInspector.getPrimitiveCategory()) {
            case BINARY: {
                this.union_.update(PrimitiveObjectInspectorUtils.getBinary((Object)data, (PrimitiveObjectInspector)objectInspector).copyBytes());
                return;
            }
            case BYTE: {
                this.union_.update((long)PrimitiveObjectInspectorUtils.getByte((Object)data, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case DOUBLE: {
                this.union_.update(PrimitiveObjectInspectorUtils.getDouble((Object)data, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case FLOAT: {
                this.union_.update((double)PrimitiveObjectInspectorUtils.getFloat((Object)data, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case INT: {
                this.union_.update((long)PrimitiveObjectInspectorUtils.getInt((Object)data, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case LONG: {
                this.union_.update(PrimitiveObjectInspectorUtils.getLong((Object)data, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case STRING: {
                this.union_.update(PrimitiveObjectInspectorUtils.getString((Object)data, (PrimitiveObjectInspector)objectInspector).toCharArray());
                return;
            }
            case CHAR: {
                this.union_.update(PrimitiveObjectInspectorUtils.getHiveChar((Object)data, (PrimitiveObjectInspector)objectInspector).getValue().toCharArray());
                return;
            }
            case VARCHAR: {
                this.union_.update(PrimitiveObjectInspectorUtils.getHiveVarchar((Object)data, (PrimitiveObjectInspector)objectInspector).getValue().toCharArray());
                return;
            }
        }
        throw new IllegalArgumentException("Unrecongnized input data type " + data.getClass().getSimpleName() + " category " + objectInspector.getPrimitiveCategory() + ", please use data of the following types: byte, double, float, int, long, char, varchar or string.");
    }

    void update(HllSketch sketch) {
        this.union_.update(sketch);
    }

    @Override
    HllSketch getResult() {
        if (this.union_ == null) {
            return null;
        }
        return this.union_.getResult(this.getType());
    }

    @Override
    void reset() {
        this.union_ = null;
    }
}

