/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.kafka.MetadataColumn;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.kafkaesque.clients.consumer.ConsumerRecord;

public class KafkaWritable
implements Writable {
    private int partition;
    private long offset;
    private long timestamp;
    private byte[] value;
    private byte[] recordKey;

    void set(ConsumerRecord<byte[], byte[]> consumerRecord) {
        this.partition = consumerRecord.partition();
        this.timestamp = consumerRecord.timestamp();
        this.offset = consumerRecord.offset();
        this.value = consumerRecord.value();
        this.recordKey = consumerRecord.key();
    }

    KafkaWritable(int partition, long offset, long timestamp, byte[] value, @Nullable byte[] recordKey) {
        this.partition = partition;
        this.offset = offset;
        this.timestamp = timestamp;
        this.value = value;
        this.recordKey = recordKey;
    }

    KafkaWritable(int partition, long timestamp, byte[] value, @Nullable byte[] recordKey) {
        this(partition, -1L, timestamp, value, recordKey);
    }

    public KafkaWritable() {
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.timestamp);
        dataOutput.writeInt(this.partition);
        dataOutput.writeLong(this.offset);
        dataOutput.writeInt(this.value.length);
        dataOutput.write(this.value);
        if (this.recordKey != null) {
            dataOutput.writeInt(this.recordKey.length);
            dataOutput.write(this.recordKey);
        } else {
            dataOutput.writeInt(-1);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.timestamp = dataInput.readLong();
        this.partition = dataInput.readInt();
        this.offset = dataInput.readLong();
        int dataSize = dataInput.readInt();
        if (dataSize > 0) {
            this.value = new byte[dataSize];
            dataInput.readFully(this.value);
        } else {
            this.value = new byte[0];
        }
        int keyArraySize = dataInput.readInt();
        if (keyArraySize > -1) {
            this.recordKey = new byte[keyArraySize];
            dataInput.readFully(this.recordKey);
        } else {
            this.recordKey = null;
        }
    }

    int getPartition() {
        return this.partition;
    }

    long getOffset() {
        return this.offset;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    byte[] getValue() {
        return this.value;
    }

    @Nullable
    byte[] getRecordKey() {
        return this.recordKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KafkaWritable)) {
            return false;
        }
        KafkaWritable writable = (KafkaWritable)o;
        return this.partition == writable.partition && this.offset == writable.offset && this.timestamp == writable.timestamp && Arrays.equals(this.value, writable.value) && Arrays.equals(this.recordKey, writable.recordKey);
    }

    public int hashCode() {
        int result = Objects.hash(this.partition, this.offset, this.timestamp);
        result = 31 * result + Arrays.hashCode(this.value);
        result = 31 * result + Arrays.hashCode(this.recordKey);
        return result;
    }

    public String toString() {
        return "KafkaWritable{partition=" + this.partition + ", offset=" + this.offset + ", timestamp=" + this.timestamp + ", value=" + Arrays.toString(this.value) + ", recordKey=" + Arrays.toString(this.recordKey) + "}";
    }

    Writable getHiveWritable(MetadataColumn metadataColumn) {
        switch (metadataColumn) {
            case OFFSET: {
                return new LongWritable(this.getOffset());
            }
            case PARTITION: {
                return new IntWritable(this.getPartition());
            }
            case TIMESTAMP: {
                return new LongWritable(this.getTimestamp());
            }
            case KEY: {
                return this.getRecordKey() == null ? null : new BytesWritable(this.getRecordKey());
            }
        }
        throw new IllegalArgumentException("Unknown metadata column [" + metadataColumn.getName() + "]");
    }
}

