/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.plugin;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.plugin.Bundle;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.ExtensionPoint;
import org.datanucleus.plugin.OSGiBundleParser;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class OSGiPluginRegistry
implements PluginRegistry {
    private static final String DATANUCLEUS_PKG = "org.datanucleus";
    Map<String, ExtensionPoint> extensionPointsByUniqueId = new HashMap<String, ExtensionPoint>();
    Map<String, Bundle> registeredPluginByPluginId = new HashMap<String, Bundle>();
    ExtensionPoint[] extensionPoints = new ExtensionPoint[0];

    public OSGiPluginRegistry(ClassLoaderResolver clr) {
    }

    @Override
    public ExtensionPoint getExtensionPoint(String id) {
        return this.extensionPointsByUniqueId.get(id);
    }

    @Override
    public ExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints;
    }

    @Override
    public void registerExtensionPoints() {
        this.registerExtensions();
    }

    @Override
    public void registerExtensions() {
        if (this.extensionPoints.length > 0) {
            return;
        }
        ArrayList registeringExtensions = new ArrayList();
        org.osgi.framework.Bundle bdl = FrameworkUtil.getBundle(this.getClass());
        BundleContext ctx = bdl.getBundleContext();
        if (ctx == null) {
            NucleusLogger.GENERAL.error("Bundle " + bdl.getSymbolicName() + " is in state " + bdl.getState() + " and has NULL context, so cannot register it properly!");
        } else {
            org.osgi.framework.Bundle[] osgiBundles;
            DocumentBuilder docBuilder = OSGiBundleParser.getDocumentBuilder();
            for (org.osgi.framework.Bundle osgiBundle : osgiBundles = ctx.getBundles()) {
                Bundle bundle;
                URL pluginURL = osgiBundle.getEntry("plugin.xml");
                if (pluginURL == null || (bundle = this.registerBundle(osgiBundle)) == null) continue;
                List[] elements = OSGiBundleParser.parsePluginElements(docBuilder, this, pluginURL, bundle, osgiBundle);
                this.registerExtensionPointsForPluginInternal(elements[0], false);
                registeringExtensions.addAll(elements[1]);
            }
        }
        this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
        for (Extension extension : registeringExtensions) {
            ExtensionPoint exPoint = this.getExtensionPoint(extension.getExtensionPointId());
            if (exPoint == null) {
                if (extension.getPlugin() == null || extension.getPlugin().getSymbolicName() == null || !extension.getPlugin().getSymbolicName().startsWith(DATANUCLEUS_PKG)) continue;
                NucleusLogger.GENERAL.warn(Localiser.msg("024002", extension.getExtensionPointId(), extension.getPlugin().getSymbolicName(), extension.getPlugin().getManifestLocation()));
                continue;
            }
            extension.setExtensionPoint(exPoint);
            exPoint.addExtension(extension);
        }
    }

    protected void registerExtensionPointsForPluginInternal(List<ExtensionPoint> extPoints, boolean updateExtensionPointsArray) {
        for (ExtensionPoint exPoint : extPoints) {
            this.extensionPointsByUniqueId.put(exPoint.getUniqueId(), exPoint);
        }
        if (updateExtensionPointsArray) {
            this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
        }
    }

    private Bundle registerBundle(org.osgi.framework.Bundle osgiBundle) {
        Bundle bundle = OSGiBundleParser.parseManifest(osgiBundle);
        if (bundle == null) {
            return null;
        }
        if (this.registeredPluginByPluginId.get(bundle.getSymbolicName()) == null) {
            if (NucleusLogger.GENERAL.isDebugEnabled()) {
                NucleusLogger.GENERAL.debug("Registering bundle " + bundle.getSymbolicName() + " version " + bundle.getVersion() + " at URL " + bundle.getManifestLocation() + ".");
            }
            this.registeredPluginByPluginId.put(bundle.getSymbolicName(), bundle);
        }
        return bundle;
    }

    @Override
    public Object createExecutableExtension(ConfigurationElement confElm, String name, Class[] argTypes, Object[] args) throws ClassNotFoundException, SecurityException {
        String symbolicName = confElm.getExtension().getPlugin().getSymbolicName();
        org.osgi.framework.Bundle osgiBundle = this.getOsgiBundle(symbolicName);
        String attribute = confElm.getAttribute(name);
        Class cls = osgiBundle.loadClass(attribute);
        return ClassUtils.newInstance(cls, argTypes, args);
    }

    @Override
    public Class loadClass(String pluginId, String className) throws ClassNotFoundException {
        return this.getOsgiBundle(pluginId).loadClass(className);
    }

    @Override
    public URL resolveURLAsFileURL(URL url) throws IOException {
        return null;
    }

    @Override
    public void resolveConstraints() {
    }

    @Override
    public Bundle[] getBundles() {
        return this.registeredPluginByPluginId.values().toArray(new Bundle[this.registeredPluginByPluginId.values().size()]);
    }

    private org.osgi.framework.Bundle getOsgiBundle(String symbolicName) {
        org.osgi.framework.Bundle[] osgiBundles;
        BundleContext ctx = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        for (org.osgi.framework.Bundle osgiBundle : osgiBundles = ctx.getBundles()) {
            if (!symbolicName.equals(osgiBundle.getSymbolicName())) continue;
            return osgiBundle;
        }
        return null;
    }

    protected static class ExtensionSorter
    implements Comparator<Extension>,
    Serializable {
        private static final long serialVersionUID = -264321551131696022L;

        protected ExtensionSorter() {
        }

        @Override
        public int compare(Extension o1, Extension o2) {
            String name1 = o1.getPlugin().getSymbolicName();
            String name2 = o2.getPlugin().getSymbolicName();
            if (name1.startsWith(OSGiPluginRegistry.DATANUCLEUS_PKG) && !name2.startsWith(OSGiPluginRegistry.DATANUCLEUS_PKG)) {
                return -1;
            }
            if (!name1.startsWith(OSGiPluginRegistry.DATANUCLEUS_PKG) && name2.startsWith(OSGiPluginRegistry.DATANUCLEUS_PKG)) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }
}

