/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.datanucleus.FetchPlanState;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.flush.ListAddAtOperation;
import org.datanucleus.flush.ListRemoveAtOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.types.SCOList;
import org.datanucleus.store.types.SCOListIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class Vector<E>
extends java.util.Vector<E>
implements SCOList<java.util.Vector<E>, E> {
    private static final long serialVersionUID = -7852159568338224341L;
    protected transient DNStateManager ownerSM;
    protected transient AbstractMemberMetaData ownerMmd;
    protected java.util.Vector<E> delegate;
    protected boolean sorting = false;

    public Vector(DNStateManager sm, AbstractMemberMetaData mmd) {
        this.ownerSM = sm;
        this.ownerMmd = mmd;
    }

    @Override
    public void initialise(java.util.Vector<E> newValue, Object oldValue) {
        this.initialise(newValue);
    }

    @Override
    public void initialise(java.util.Vector<E> c) {
        this.delegate = c != null ? c : new java.util.Vector();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("023003", this.getClass().getName(), this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName(), "" + this.size(), SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    @Override
    public void initialise() {
        this.initialise(null);
    }

    @Override
    public java.util.Vector<E> getValue() {
        return this.delegate;
    }

    @Override
    public void setValue(java.util.Vector<E> value) {
        this.delegate = value;
    }

    @Override
    public void load() {
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public void updateEmbeddedElement(E element, int fieldNumber, Object value, boolean makeDirty) {
        if (makeDirty) {
            this.makeDirty();
        }
    }

    @Override
    public String getFieldName() {
        return this.ownerMmd.getName();
    }

    @Override
    public Object getOwner() {
        return this.ownerSM != null ? this.ownerSM.getObject() : null;
    }

    @Override
    public void unsetOwner() {
        if (this.ownerSM != null) {
            this.ownerSM = null;
            this.ownerMmd = null;
        }
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.makeDirty(this.ownerMmd.getAbsoluteFieldNumber());
        }
    }

    @Override
    public java.util.Vector detachCopy(FetchPlanState state) {
        java.util.Vector detached = new java.util.Vector();
        SCOUtils.detachCopyForCollection(this.ownerSM.getExecutionContext(), this.toArray(), state, detached);
        return detached;
    }

    @Override
    public void attachCopy(java.util.Vector value) {
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(this.ownerMmd);
        ArrayList attachedElements = new ArrayList(value.size());
        SCOUtils.attachCopyForCollection(this.ownerSM, value.toArray(), attachedElements, elementsWithoutIdentity);
        SCOUtils.updateListWithListElements(this, attachedElements);
    }

    @Override
    public synchronized Object clone() {
        return this.delegate.clone();
    }

    @Override
    public boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    @Override
    public synchronized boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public synchronized E elementAt(int index) {
        return this.delegate.elementAt(index);
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public Enumeration elements() {
        return this.delegate.elements();
    }

    @Override
    public synchronized E firstElement() {
        return this.delegate.firstElement();
    }

    @Override
    public synchronized E get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public int indexOf(Object element) {
        return this.delegate.indexOf(element);
    }

    @Override
    public synchronized int indexOf(Object element, int startIndex) {
        return this.delegate.indexOf(element, startIndex);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public synchronized Iterator<E> iterator() {
        return new SCOListIterator<E>(this, this.ownerSM, this.delegate, null, true, -1);
    }

    @Override
    public synchronized E lastElement() {
        return this.delegate.lastElement();
    }

    @Override
    public synchronized int lastIndexOf(Object element) {
        return this.delegate.lastIndexOf(element);
    }

    @Override
    public synchronized int lastIndexOf(Object element, int startIndex) {
        return this.delegate.lastIndexOf(element, startIndex);
    }

    @Override
    public synchronized ListIterator<E> listIterator() {
        return new SCOListIterator<E>(this, this.ownerSM, this.delegate, null, true, -1);
    }

    @Override
    public synchronized ListIterator<E> listIterator(int index) {
        return new SCOListIterator<E>(this, this.ownerSM, this.delegate, null, true, index);
    }

    @Override
    public synchronized int size() {
        return this.delegate.size();
    }

    @Override
    public synchronized List<E> subList(int from, int to) {
        return this.delegate.subList(from, to);
    }

    @Override
    public synchronized Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public void add(int index, E element) {
        this.delegate.add(index, element);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
            this.ownerSM.getExecutionContext().addOperationToQueue(new ListAddAtOperation<E>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), index, element));
        }
        this.makeDirty();
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public synchronized boolean add(E element) {
        boolean success = this.delegate.add(element);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionAddOperation<E>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), element));
            }
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> elements) {
        boolean success = this.delegate.addAll(elements);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            for (E elem : elements) {
                relMgr.relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                for (E element : elements) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionAddOperation<E>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), element));
                }
            }
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> elements) {
        boolean success = this.delegate.addAll(index, elements);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            for (E elem : elements) {
                relMgr.relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                int pos = index;
                for (E element : elements) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new ListAddAtOperation<E>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), pos++, element));
                }
            }
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public synchronized void addElement(E element) {
        this.add(element);
    }

    @Override
    public synchronized void clear() {
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            for (E elem : this.delegate) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        if (this.ownerSM != null && !this.delegate.isEmpty()) {
            Iterator iter;
            ArrayList<E> copy;
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                copy = new ArrayList<E>(this.delegate);
                iter = copy.iterator();
                while (iter.hasNext()) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), iter.next(), true));
                }
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                copy = new ArrayList<E>(this.delegate);
                iter = copy.iterator();
                while (iter.hasNext()) {
                    this.ownerSM.getExecutionContext().deleteObjectInternal(iter.next());
                }
            }
        }
        this.delegate.clear();
        this.makeDirty();
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public boolean remove(Object element) {
        return this.remove(element, true);
    }

    @Override
    public synchronized boolean remove(Object element, boolean allowCascadeDelete) {
        boolean success = this.delegate.remove(element);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (this.ownerSM != null && allowCascadeDelete) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation<Object>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), element, allowCascadeDelete));
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                this.ownerSM.getExecutionContext().deleteObjectInternal(element);
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public synchronized E remove(int index) {
        E element = this.delegate.remove(index);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (this.ownerSM != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new ListRemoveAtOperation<E>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), index, element));
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                this.ownerSM.getExecutionContext().deleteObjectInternal(element);
            }
        }
        this.makeDirty();
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return element;
    }

    @Override
    public synchronized boolean removeAll(Collection elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        if (elements.isEmpty()) {
            return true;
        }
        boolean success = this.delegate.removeAll(elements);
        if (this.ownerSM != null) {
            if (this.ownerSM.getExecutionContext().getManageRelations()) {
                RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
                for (Object elem : elements) {
                    relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), elem);
                }
            }
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                for (Object elem : elements) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), elem, true));
                }
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                for (Object elem : elements) {
                    this.ownerSM.getExecutionContext().deleteObjectInternal(elem);
                }
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public synchronized boolean removeElement(Object element) {
        return this.remove(element);
    }

    @Override
    public synchronized void removeElementAt(int index) {
        this.remove(index);
    }

    @Override
    public synchronized void removeAllElements() {
        this.clear();
    }

    @Override
    public synchronized boolean retainAll(Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public E set(int index, E element, boolean allowDependentField) {
        E prevElement = this.delegate.set(index, element);
        if (this.ownerSM != null && allowDependentField && !this.delegate.contains(prevElement)) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new ListRemoveAtOperation<E>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), index, prevElement));
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                this.ownerSM.getExecutionContext().deleteObjectInternal(prevElement);
            }
        }
        this.makeDirty();
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return prevElement;
    }

    @Override
    public synchronized E set(int index, E element) {
        return this.set(index, element, !this.sorting);
    }

    @Override
    public synchronized void setElementAt(E element, int index) {
        this.set(index, element);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new java.util.Vector<E>(this.delegate);
    }

    @Override
    public Stream<E> stream() {
        return this.delegate.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.delegate.parallelStream();
    }

    @Override
    public synchronized void trimToSize() {
        this.delegate.trimToSize();
    }

    @Override
    public synchronized void ensureCapacity(int minCapacity) {
        this.delegate.ensureCapacity(minCapacity);
    }

    @Override
    public synchronized void forEach(Consumer<? super E> action) {
        this.delegate.forEach(action);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public synchronized void sort(Comparator<? super E> comp) {
        this.sorting = true;
        super.sort(comp);
        this.sorting = false;
    }
}

