/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.vector;

import org.apache.iceberg.StructLike;
import org.apache.iceberg.mr.hive.vector.HiveRow;
import org.apache.iceberg.mr.hive.vector.HiveValueConverter;
import org.apache.iceberg.types.Types;

public class HiveStructLike
implements StructLike {
    private final Types.StructType type;
    private HiveRow wrapped;

    public HiveStructLike(Types.StructType type) {
        this.type = type;
    }

    public HiveStructLike wrap(HiveRow row) {
        this.wrapped = row;
        return this;
    }

    @Override
    public int size() {
        return this.type.fields().size();
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        Types.NestedField field = this.type.fields().get(pos);
        return javaClass.cast(HiveValueConverter.convert(field.type(), this.wrapped.get(pos)));
    }

    @Override
    public <T> void set(int pos, T value) {
        throw new UnsupportedOperationException("Not implemented: set");
    }
}

