/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.esriJson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnclosedBaseJsonRecordReader
extends RecordReader<LongWritable, Text>
implements org.apache.hadoop.mapred.RecordReader<LongWritable, Text> {
    static final Logger LOG = LoggerFactory.getLogger((String)EnclosedBaseJsonRecordReader.class.getName());
    protected LongWritable mkey = null;
    protected Text mval = null;
    protected InputStream inputStream;
    protected long splitLen = 0L;
    protected JsonParser parser;

    protected EnclosedBaseJsonRecordReader() throws IOException {
        this.mkey = this.createKey();
        this.mval = this.createValue();
    }

    protected EnclosedBaseJsonRecordReader(org.apache.hadoop.mapred.InputSplit split, Configuration conf) throws IOException {
        org.apache.hadoop.mapred.FileSplit fileSplit = (org.apache.hadoop.mapred.FileSplit)split;
        this.splitLen = fileSplit.getLength();
        this.commonInit(fileSplit.getPath(), conf);
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    public LongWritable createKey() {
        return new LongWritable();
    }

    public Text createValue() {
        return new Text();
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.mkey;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.mval;
    }

    public long getPos() throws IOException {
        if (this.parser == null) {
            return 0L;
        }
        return this.parser.getCurrentLocation().getCharOffset();
    }

    public float getProgress() throws IOException {
        if (this.splitLen == 0L || this.parser == null) {
            return 0.0f;
        }
        return (float)this.parser.getCurrentLocation().getByteOffset() / (float)this.splitLen;
    }

    public void initialize(InputSplit split, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)split;
        this.splitLen = fileSplit.getLength();
        this.commonInit(fileSplit.getPath(), taskContext.getConfiguration());
    }

    public boolean next(LongWritable key, Text value) throws IOException {
        JsonToken token;
        if (this.parser == null) {
            this.parser = new JsonFactory().createJsonParser(this.inputStream);
            this.parser.setCodec((ObjectCodec)new ObjectMapper());
            token = this.parser.nextToken();
            while (!(token == null || token == JsonToken.START_ARRAY && this.parser.getCurrentName() != null && this.parser.getCurrentName().equals("features"))) {
                token = this.parser.nextToken();
            }
            if (token == null) {
                return false;
            }
        }
        key.set(this.parser.getCurrentLocation().getCharOffset());
        token = this.parser.nextToken();
        if (token == null || token != JsonToken.START_OBJECT || this.parser.getCurrentName() != null) {
            return false;
        }
        ObjectNode node = (ObjectNode)this.parser.readValueAsTree();
        value.set(node.toString());
        return true;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.next(this.mkey, this.mval);
    }

    private void commonInit(Path filePath, Configuration conf) throws IOException {
        FileSystem fs = filePath.getFileSystem(conf);
        this.inputStream = fs.open(filePath);
    }
}

