/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class DummyPartition
extends Partition {
    private String name;
    private LinkedHashMap<String, String> partSpec;

    public DummyPartition() {
    }

    public DummyPartition(Table tbl, String name) {
        this.setTable(tbl);
        this.name = name;
    }

    public DummyPartition(Table tbl) {
        this(tbl, null, Maps.newHashMap());
    }

    public DummyPartition(Table tbl, String name, Map<String, String> partSpec) {
        this(tbl, name);
        org.apache.hadoop.hive.metastore.api.Partition tPart = new org.apache.hadoop.hive.metastore.api.Partition();
        tPart.setSd(tbl.getSd().deepCopy());
        tPart.setParameters((Map)Maps.newHashMap());
        this.partSpec = Maps.newLinkedHashMap(partSpec);
        this.setTPartition(tPart);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCompleteName() {
        return this.getName();
    }

    @Override
    public LinkedHashMap<String, String> getSpec() {
        return this.partSpec;
    }

    @Override
    public List<String> getValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (FieldSchema fs : this.getTable().getPartCols()) {
            values.add(this.partSpec.get(fs.getName()));
        }
        return values;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DummyPartition) {
            DummyPartition o = (DummyPartition)obj;
            return Objects.equals(this.name, o.name) && Objects.equals(this.partSpec, o.partSpec);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.name) + Objects.hashCode(this.partSpec);
    }
}

