/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;

public class HiveRelMdCumulativeCost
implements MetadataHandler<BuiltInMetadata.CumulativeCost> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.CUMULATIVE_COST.method, (MetadataHandler)new HiveRelMdCumulativeCost());

    private HiveRelMdCumulativeCost() {
    }

    public MetadataDef<BuiltInMetadata.CumulativeCost> getDef() {
        return BuiltInMetadata.CumulativeCost.DEF;
    }

    public RelOptCost getCumulativeCost(HiveJoin rel, RelMetadataQuery mq) {
        RelOptCost cost = mq.getNonCumulativeCost((RelNode)rel);
        List inputs = rel.getInputs();
        HiveCost maxICost = HiveCost.ZERO;
        for (RelNode input : inputs) {
            RelOptCost iCost = mq.getCumulativeCost(input);
            if (!maxICost.isLt(iCost)) continue;
            maxICost = iCost;
        }
        return cost.plus((RelOptCost)maxICost);
    }
}

