/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.topnkey;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TopNKeyOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.optimizer.topnkey.CommonKeyPrefix;
import org.apache.hadoop.hive.ql.optimizer.topnkey.TopNKeyProcessor;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TopNKeyDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopNKeyPushdownProcessor
implements SemanticNodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TopNKeyPushdownProcessor.class);

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        this.pushdown((TopNKeyOperator)nd);
        return null;
    }

    private void pushdown(TopNKeyOperator topNKey) throws SemanticException {
        Operator<OperatorDesc> parent = topNKey.getParentOperators().get(0);
        switch (parent.getType()) {
            case SELECT: {
                this.pushdownThroughSelect(topNKey);
                break;
            }
            case FORWARD: {
                this.pushdownThroughParent(topNKey);
                break;
            }
            case GROUPBY: {
                this.pushdownThroughGroupBy(topNKey);
                break;
            }
            case REDUCESINK: {
                this.pushdownThroughReduceSink(topNKey);
                break;
            }
            case MERGEJOIN: 
            case JOIN: {
                this.pushDownThroughJoin(topNKey);
                break;
            }
            case TOPNKEY: {
                this.pushdownThroughTopNKey(topNKey);
                break;
            }
        }
    }

    private void pushdownThroughSelect(TopNKeyOperator topNKey) throws SemanticException {
        SelectOperator select = (SelectOperator)topNKey.getParentOperators().get(0);
        TopNKeyDesc topNKeyDesc = (TopNKeyDesc)topNKey.getConf();
        List<ExprNodeDesc> mappedColumns = TopNKeyPushdownProcessor.mapColumns(topNKeyDesc.getKeyColumns(), select.getColumnExprMap());
        if (mappedColumns.size() != topNKeyDesc.getKeyColumns().size()) {
            return;
        }
        LOG.debug("Pushing {} through {}", (Object)topNKey.getName(), (Object)select.getName());
        topNKeyDesc.setKeyColumns(mappedColumns);
        topNKeyDesc.setPartitionKeyColumns(mappedColumns.subList(0, topNKeyDesc.getPartitionKeyColumns().size()));
        TopNKeyPushdownProcessor.moveDown(topNKey);
        this.pushdown(topNKey);
    }

    private static List<ExprNodeDesc> mapColumns(List<ExprNodeDesc> columns, Map<String, ExprNodeDesc> colExprMap) {
        if (colExprMap == null) {
            return new ArrayList<ExprNodeDesc>(0);
        }
        ArrayList<ExprNodeDesc> mappedColumns = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc column : columns) {
            String columnName = column.getExprString();
            if (!colExprMap.containsKey(columnName)) continue;
            mappedColumns.add(colExprMap.get(columnName));
        }
        return mappedColumns;
    }

    private void pushdownThroughParent(TopNKeyOperator topNKey) throws SemanticException {
        Operator<OperatorDesc> parent = topNKey.getParentOperators().get(0);
        LOG.debug("Pushing {} through {}", (Object)topNKey.getName(), (Object)parent.getName());
        TopNKeyPushdownProcessor.moveDown(topNKey);
        this.pushdown(topNKey);
    }

    private void pushdownThroughGroupBy(TopNKeyOperator topNKey) throws SemanticException {
        GroupByOperator groupBy = (GroupByOperator)topNKey.getParentOperators().get(0);
        GroupByDesc groupByDesc = (GroupByDesc)groupBy.getConf();
        TopNKeyDesc topNKeyDesc = (TopNKeyDesc)topNKey.getConf();
        CommonKeyPrefix commonKeyPrefix = CommonKeyPrefix.map(topNKeyDesc, groupByDesc);
        if (commonKeyPrefix.isEmpty() || commonKeyPrefix.size() == topNKeyDesc.getPartitionKeyColumns().size()) {
            return;
        }
        LOG.debug("Pushing a copy of {} through {}", (Object)topNKey.getName(), (Object)groupBy.getName());
        TopNKeyDesc newTopNKeyDesc = topNKeyDesc.combine(commonKeyPrefix);
        this.pushdown((TopNKeyOperator)TopNKeyProcessor.copyDown(groupBy, newTopNKeyDesc));
        if (topNKeyDesc.getKeyColumns().size() == commonKeyPrefix.size()) {
            LOG.debug("Removing {} above {}", (Object)topNKey.getName(), (Object)groupBy.getName());
            groupBy.removeChildAndAdoptItsChildren(topNKey);
        }
    }

    private void pushdownThroughReduceSink(TopNKeyOperator topNKey) throws SemanticException {
        ReduceSinkOperator reduceSink = (ReduceSinkOperator)topNKey.getParentOperators().get(0);
        ReduceSinkDesc reduceSinkDesc = (ReduceSinkDesc)reduceSink.getConf();
        TopNKeyDesc topNKeyDesc = (TopNKeyDesc)topNKey.getConf();
        CommonKeyPrefix commonKeyPrefix = CommonKeyPrefix.map(topNKeyDesc, reduceSinkDesc);
        if (commonKeyPrefix.isEmpty() || commonKeyPrefix.size() == topNKeyDesc.getPartitionKeyColumns().size()) {
            return;
        }
        LOG.debug("Pushing a copy of {} through {}", (Object)topNKey.getName(), (Object)reduceSink.getName());
        TopNKeyDesc newTopNKeyDesc = topNKeyDesc.combine(commonKeyPrefix);
        this.pushdown((TopNKeyOperator)TopNKeyProcessor.copyDown(reduceSink, newTopNKeyDesc));
        if (topNKeyDesc.getKeyColumns().size() == commonKeyPrefix.size()) {
            LOG.debug("Removing {} above {}", (Object)topNKey.getName(), (Object)reduceSink.getName());
            reduceSink.removeChildAndAdoptItsChildren(topNKey);
        }
    }

    private void pushDownThroughJoin(TopNKeyOperator topNKey) throws SemanticException {
        CommonJoinOperator parent = (CommonJoinOperator)topNKey.getParentOperators().get(0);
        JoinDesc joinDesc = (JoinDesc)parent.getConf();
        JoinCondDesc[] joinConds = joinDesc.getConds();
        JoinCondDesc firstJoinCond = joinConds[0];
        for (JoinCondDesc joinCond : joinConds) {
            if (firstJoinCond.equals(joinCond)) continue;
            return;
        }
        if (firstJoinCond.getType() == 1) {
            this.pushdownThroughLeftOuterJoin(topNKey);
        } else if (firstJoinCond.getType() == 0 && joinDesc.isPkFkJoin()) {
            this.pushdownInnerJoin(topNKey, joinDesc.getFkJoinTableIndex(), joinDesc.isNonFkSideIsFiltered());
        }
    }

    private void pushdownThroughLeftOuterJoin(TopNKeyOperator topNKey) throws SemanticException {
        TopNKeyDesc topNKeyDesc = (TopNKeyDesc)topNKey.getConf();
        CommonJoinOperator join = (CommonJoinOperator)topNKey.getParentOperators().get(0);
        List<Operator<OperatorDesc>> joinInputs = join.getParentOperators();
        ReduceSinkOperator reduceSinkOperator = (ReduceSinkOperator)joinInputs.get(0);
        ReduceSinkDesc reduceSinkDesc = (ReduceSinkDesc)reduceSinkOperator.getConf();
        CommonKeyPrefix commonKeyPrefix = CommonKeyPrefix.map(this.mapUntilColumnEquals(topNKeyDesc.getKeyColumns(), join.getColumnExprMap()), topNKeyDesc.getColumnSortOrder(), topNKeyDesc.getNullOrder(), reduceSinkDesc.getKeyCols(), reduceSinkDesc.getColumnExprMap(), reduceSinkDesc.getOrder(), reduceSinkDesc.getNullOrder());
        if (commonKeyPrefix.isEmpty() || commonKeyPrefix.size() == topNKeyDesc.getPartitionKeyColumns().size()) {
            return;
        }
        LOG.debug("Pushing a copy of {} through {} and {}", new Object[]{topNKey.getName(), join.getName(), reduceSinkOperator.getName()});
        TopNKeyDesc newTopNKeyDesc = topNKeyDesc.combine(commonKeyPrefix);
        this.pushdown((TopNKeyOperator)TopNKeyProcessor.copyDown(reduceSinkOperator, newTopNKeyDesc));
        if (topNKeyDesc.getKeyColumns().size() == commonKeyPrefix.size()) {
            LOG.debug("Removing {} above {}", (Object)topNKey.getName(), (Object)join.getName());
            join.removeChildAndAdoptItsChildren(topNKey);
        }
    }

    private void pushdownInnerJoin(TopNKeyOperator topNKey, int fkJoinInputIndex, boolean nonFkSideIsFiltered) throws SemanticException {
        TopNKeyDesc topNKeyDesc = (TopNKeyDesc)topNKey.getConf();
        CommonJoinOperator join = (CommonJoinOperator)topNKey.getParentOperators().get(0);
        List<Operator<OperatorDesc>> joinInputs = join.getParentOperators();
        ReduceSinkOperator fkJoinInput = (ReduceSinkOperator)joinInputs.get(fkJoinInputIndex);
        if (nonFkSideIsFiltered) {
            LOG.debug("Not pushing {} through {} as non FK side of the join is filtered", (Object)topNKey.getName(), (Object)join.getName());
            return;
        }
        CommonKeyPrefix commonKeyPrefix = CommonKeyPrefix.map(this.mapUntilColumnEquals(topNKeyDesc.getKeyColumns(), join.getColumnExprMap()), topNKeyDesc.getColumnSortOrder(), topNKeyDesc.getNullOrder(), ((ReduceSinkDesc)fkJoinInput.getConf()).getKeyCols(), ((ReduceSinkDesc)fkJoinInput.getConf()).getColumnExprMap(), ((ReduceSinkDesc)fkJoinInput.getConf()).getOrder(), ((ReduceSinkDesc)fkJoinInput.getConf()).getNullOrder());
        if (commonKeyPrefix.isEmpty() || commonKeyPrefix.size() == topNKeyDesc.getPartitionKeyColumns().size()) {
            return;
        }
        LOG.debug("Pushing a copy of {} through {} and {}", new Object[]{topNKey.getName(), join.getName(), fkJoinInput.getName()});
        TopNKeyDesc newTopNKeyDesc = topNKeyDesc.combine(commonKeyPrefix);
        this.pushdown((TopNKeyOperator)TopNKeyProcessor.copyDown(fkJoinInput, newTopNKeyDesc));
        if (topNKeyDesc.getKeyColumns().size() == commonKeyPrefix.size()) {
            LOG.debug("Removing {} above {}", (Object)topNKey.getName(), (Object)join.getName());
            join.removeChildAndAdoptItsChildren(topNKey);
        }
    }

    private List<ExprNodeDesc> mapUntilColumnEquals(List<ExprNodeDesc> columns, Map<String, ExprNodeDesc> colExprMap) {
        if (colExprMap == null) {
            return new ArrayList<ExprNodeDesc>(0);
        }
        ArrayList<ExprNodeDesc> mappedColumns = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc column : columns) {
            String columnName = column.getExprString();
            if (colExprMap.containsKey(columnName)) {
                mappedColumns.add(colExprMap.get(columnName));
                continue;
            }
            return mappedColumns;
        }
        return mappedColumns;
    }

    private void pushdownThroughTopNKey(TopNKeyOperator topNKey) throws SemanticException {
        TopNKeyOperator parent = (TopNKeyOperator)topNKey.getParentOperators().get(0);
        if (TopNKeyPushdownProcessor.hasSameTopNKeyDesc(parent, (TopNKeyDesc)topNKey.getConf())) {
            LOG.debug("Removing {} above same operator: {}", (Object)topNKey.getName(), (Object)parent.getName());
            parent.removeChildAndAdoptItsChildren(topNKey);
            return;
        }
        TopNKeyDesc topNKeyDesc = (TopNKeyDesc)topNKey.getConf();
        TopNKeyDesc parentTopNKeyDesc = (TopNKeyDesc)parent.getConf();
        CommonKeyPrefix commonKeyPrefix = CommonKeyPrefix.map(topNKeyDesc.getKeyColumns(), topNKeyDesc.getColumnSortOrder(), topNKeyDesc.getNullOrder(), parentTopNKeyDesc.getKeyColumns(), parentTopNKeyDesc.getColumnSortOrder(), parentTopNKeyDesc.getNullOrder());
        if (topNKeyDesc.getTopN() == parentTopNKeyDesc.getTopN()) {
            if (topNKeyDesc.getKeyColumns().size() == commonKeyPrefix.size()) {
                this.pushdownThroughParent(topNKey);
                if (topNKey.getChildOperators().get(0).getType() == OperatorType.TOPNKEY) {
                    LOG.debug("Removing {} since child {} supersedes it", (Object)parent.getName(), (Object)topNKey.getName());
                    topNKey.getParentOperators().get(0).removeChildAndAdoptItsChildren(topNKey);
                }
            } else if (parentTopNKeyDesc.getKeyColumns().size() == commonKeyPrefix.size()) {
                LOG.debug("Removing parent of {} since it supersedes", (Object)topNKey.getName());
                parent.getParentOperators().get(0).removeChildAndAdoptItsChildren(parent);
            }
        } else if (topNKeyDesc.getKeyColumns().size() == commonKeyPrefix.size() && parentTopNKeyDesc.getKeyColumns().size() == commonKeyPrefix.size()) {
            if (topNKeyDesc.getTopN() > parentTopNKeyDesc.getTopN()) {
                LOG.debug("Removing {}. Parent {} has same keys but lower topN {} > {}", new Object[]{topNKey.getName(), parent.getName(), topNKeyDesc.getTopN(), parentTopNKeyDesc.getTopN()});
                topNKey.getParentOperators().get(0).removeChildAndAdoptItsChildren(topNKey);
            } else {
                LOG.debug("Removing parent {}. {} has same keys but lower topN {} < {}", new Object[]{parent.getName(), topNKey.getName(), topNKeyDesc.getTopN(), parentTopNKeyDesc.getTopN()});
                parent.getParentOperators().get(0).removeChildAndAdoptItsChildren(parent);
            }
        }
    }

    private static boolean hasSameTopNKeyDesc(Operator<? extends OperatorDesc> operator, TopNKeyDesc desc) {
        if (!(operator instanceof TopNKeyOperator)) {
            return false;
        }
        TopNKeyOperator topNKey = (TopNKeyOperator)operator;
        TopNKeyDesc opDesc = (TopNKeyDesc)topNKey.getConf();
        return opDesc.isSame(desc);
    }

    public static void moveDown(Operator<? extends OperatorDesc> operator) throws SemanticException {
        assert (operator.getNumParent() == 1);
        Operator<OperatorDesc> parent = operator.getParentOperators().get(0);
        List<Operator<OperatorDesc>> grandParents = parent.getParentOperators();
        parent.removeChildAndAdoptItsChildren(operator);
        for (Operator<OperatorDesc> grandParent : grandParents) {
            grandParent.replaceChild(parent, operator);
        }
        operator.getParentOperators().clear();
        operator.getParentOperators().addAll(grandParents);
        operator.getChildOperators().clear();
        operator.getChildOperators().add(parent);
        parent.getParentOperators().clear();
        parent.getParentOperators().add(operator);
    }
}

