/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.quantiles.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetQuantiles", value="_FUNC_(sketch, [inclusive,] fractions...) or _FUNC_(sketch, [inclusive,] number)", extended="Returns quantile values from a given ItemsSketch<String> based on a given list of fractions or a number of evenly spaced fractions. The optional boolean parameter 'inclusive' (default: true) determines if the result includes values less than or equal to each target fraction or, if false, only values strictly less than each target fraction. The fractions represent normalized ranks, and must be from 0 to 1 inclusive. For example, a fraction of 0.5 corresponds to 50th percentile, which is the median value of the distribution (the number separating the higher half of the probability distribution from the lower half). The number of evenly spaced fractions must be a positive integer greater than 0. A value of 1 will return the min value (normalized rank of 0.0). A value of 2 will return the min and the max value (ranks 0.0 amd 1.0). A value of 3 will return the min, the median and the max value (ranks 0.0, 0.5, and 1.0), etc.")
public class GetQuantilesFromStringsSketchUDF
extends UDF {
    public List<String> evaluate(BytesWritable serializedSketch, Double ... fractions) {
        return this.evaluate(serializedSketch, (Boolean)true, fractions);
    }

    public List<String> evaluate(BytesWritable serializedSketch, Boolean inclusive, Double ... fractions) {
        if (serializedSketch == null) {
            return null;
        }
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, (Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        return Arrays.asList((String[])sketch.getQuantiles(Util.objectsToPrimitives(fractions), inclusive != false ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE));
    }

    public List<String> evaluate(BytesWritable serializedSketch, int number) {
        return this.evaluate(serializedSketch, (Boolean)true, number);
    }

    public List<String> evaluate(BytesWritable serializedSketch, Boolean inclusive, int number) {
        if (serializedSketch == null) {
            return null;
        }
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, (Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        if (sketch.isEmpty()) {
            return null;
        }
        String[] quantiles = null;
        if (number == 1) {
            quantiles = new String[]{(String)sketch.getMinItem()};
        } else if (number == 2) {
            quantiles = new String[]{(String)sketch.getMinItem(), (String)sketch.getMaxItem()};
        } else if (number > 2) {
            double[] ranks = new double[number];
            double delta = 1.0 / (double)(number - 1);
            for (int i = 0; i < number; ++i) {
                ranks[i] = (double)i * delta;
            }
            quantiles = (String[])sketch.getQuantiles(ranks, inclusive != false ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE);
            quantiles[number - 1] = (String)sketch.getMaxItem();
        }
        if (quantiles == null) {
            return null;
        }
        return Arrays.asList(quantiles);
    }
}

