/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2;

import com.trilead.ssh2.packets.PacketExtInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ExtensionInfo {
    private final Set<String> signatureAlgorithmsAccepted;

    public Set<String> getSignatureAlgorithmsAccepted() {
        return this.signatureAlgorithmsAccepted;
    }

    public static ExtensionInfo fromPacketExtInfo(PacketExtInfo packetExtInfo) {
        String rawAlgs = packetExtInfo.getExtNameToValue().get("server-sig-algs");
        if (rawAlgs == null) {
            return new ExtensionInfo(Collections.emptySet());
        }
        HashSet<String> algsSet = new HashSet<String>();
        Collections.addAll(algsSet, rawAlgs.split(","));
        return new ExtensionInfo(algsSet);
    }

    public static ExtensionInfo noExtInfoSeen() {
        return new ExtensionInfo(Collections.emptySet());
    }

    private ExtensionInfo(Set<String> signatureAlgorithmsAccepted) {
        this.signatureAlgorithmsAccepted = Collections.unmodifiableSet(signatureAlgorithmsAccepted);
    }
}

