/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ResourceIdCoder
extends AtomicCoder<ResourceId> {
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> STRING_CODER = StringUtf8Coder.of();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Boolean> BOOL_CODER = BooleanCoder.of();

    public static @UnknownKeyFor @NonNull @Initialized ResourceIdCoder of() {
        return new ResourceIdCoder();
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized ResourceId value, @UnknownKeyFor @NonNull @Initialized OutputStream os) throws @UnknownKeyFor @NonNull @Initialized IOException {
        STRING_CODER.encode(value.toString(), os);
        BOOL_CODER.encode(value.isDirectory(), os);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ResourceId decode(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String spec = STRING_CODER.decode(is);
        boolean isDirectory = BOOL_CODER.decode(is);
        return FileSystems.matchNewResource(spec, isDirectory);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }
}

