/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.util.Set;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MetricFiltering {
    private MetricFiltering() {
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized MetricsFilter filter, @UnknownKeyFor @NonNull @Initialized MetricKey key) {
        if (filter == null) {
            return true;
        }
        @Nullable String stepName = key.stepName();
        if (stepName == null ? !filter.steps().isEmpty() : !MetricFiltering.matchesScope(stepName, filter.steps())) {
            return false;
        }
        return MetricFiltering.matchesName(key.metricName(), filter.names());
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean subPathMatches(@UnknownKeyFor @NonNull @Initialized String haystack, @UnknownKeyFor @NonNull @Initialized String needle) {
        int location = haystack.indexOf(needle);
        int end = location + needle.length();
        if (location == -1) {
            return false;
        }
        if (location != 0 && haystack.charAt(location - 1) != '/') {
            return false;
        }
        return end == haystack.length() || haystack.charAt(end) == '/';
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean matchesScope(@UnknownKeyFor @NonNull @Initialized String actualScope, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> scopes) {
        if (scopes.isEmpty() || scopes.contains(actualScope)) {
            return true;
        }
        for (String scope : scopes) {
            if (!MetricFiltering.subPathMatches(actualScope, scope)) continue;
            return true;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean matchesName(@UnknownKeyFor @NonNull @Initialized MetricName metricName, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized MetricNameFilter> nameFilters) {
        if (nameFilters.isEmpty()) {
            return true;
        }
        for (MetricNameFilter nameFilter : nameFilters) {
            @Nullable String name = nameFilter.getName();
            if (name != null && !name.equals(metricName.getName()) || !Objects.equal((Object)metricName.getNamespace(), (Object)nameFilter.getNamespace())) continue;
            return true;
        }
        return false;
    }
}

