/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DateTime
implements Schema.LogicalType<LocalDateTime, Row> {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "beam:logical_type:datetime:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String DATE_FIELD_NAME = "Date";
    public static final @UnknownKeyFor @NonNull @Initialized String TIME_FIELD_NAME = "Time";
    public static final @UnknownKeyFor @NonNull @Initialized Schema DATETIME_SCHEMA = Schema.builder().addInt64Field("Date").addInt64Field("Time").build();

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema.FieldType getArgumentType() {
        return Schema.FieldType.STRING;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getArgument() {
        return "";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema.FieldType getBaseType() {
        return Schema.FieldType.row(DATETIME_SCHEMA);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Row toBaseType(@UnknownKeyFor @NonNull @Initialized LocalDateTime input) {
        return Row.withSchema(DATETIME_SCHEMA).addValues(input.toLocalDate().toEpochDay(), input.toLocalTime().toNanoOfDay()).build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized LocalDateTime toInputType(@UnknownKeyFor @NonNull @Initialized Row base) {
        return LocalDateTime.of(LocalDate.ofEpochDay(Preconditions.checkArgumentNotNull(base.getInt64(DATE_FIELD_NAME), "While trying to convert to LocalDateTime: Row missing date field")), LocalTime.ofNanoOfDay(Preconditions.checkArgumentNotNull(base.getInt64(TIME_FIELD_NAME), "While trying to convert to LocalDateTime: Row missing time field")));
    }
}

