/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.ByteBuddyDoFnInvokerFactory;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class DoFnInvokers {
    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized DoFnInvoker<InputT, OutputT> invokerFor(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn) {
        return ByteBuddyDoFnInvokerFactory.only().newByteBuddyInvoker(fn);
    }

    private DoFnInvokers() {
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized DoFnInvoker<InputT, OutputT> tryInvokeSetupFor(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        DoFnInvoker doFnInvoker = DoFnInvokers.invokerFor(fn);
        try {
            doFnInvoker.invokeSetup(new DoFnSetupArgumentProvider(options));
        }
        catch (Exception e) {
            try {
                doFnInvoker.invokeTeardown();
            }
            catch (Exception suppressed) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
        return doFnInvoker;
    }

    private static class DoFnSetupArgumentProvider<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized PipelineOptions options;

        private DoFnSetupArgumentProvider(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.options = options;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
            return this.options;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
            return "SimpleDoFnRunner/Setup";
        }
    }
}

