/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.history;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.util.Preconditions;

public class ArchivedJson {
    private static final ObjectMapper MAPPER = RestMapperUtils.getStrictObjectMapper();
    private final String path;
    private final String json;

    public ArchivedJson(String path, String json) {
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.json = (String)Preconditions.checkNotNull((Object)json);
    }

    public ArchivedJson(String path, ResponseBody json) throws IOException {
        this.path = (String)Preconditions.checkNotNull((Object)path);
        StringWriter sw = new StringWriter();
        MAPPER.writeValue((Writer)sw, Preconditions.checkNotNull((Object)json));
        this.json = sw.toString();
    }

    public String getPath() {
        return this.path;
    }

    public String getJson() {
        return this.json;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArchivedJson) {
            ArchivedJson other = (ArchivedJson)obj;
            return this.path.equals(other.path) && this.json.equals(other.json);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.json);
    }

    public String toString() {
        return this.path + ":" + this.json;
    }
}

