/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.kafka.consumer;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.SingleThreadedPipelineExecutor;
import org.apache.hop.pipeline.TransformWithMappingMeta;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineRunConfiguration;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.injector.InjectorMeta;
import org.apache.hop.pipeline.transforms.kafka.consumer.KafkaConsumerInputData;
import org.apache.hop.pipeline.transforms.kafka.consumer.KafkaConsumerInputMeta;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;

public class KafkaConsumerInput
extends BaseTransform<KafkaConsumerInputMeta, KafkaConsumerInputData> {
    private static final Class<?> PKG = KafkaConsumerInputMeta.class;

    public KafkaConsumerInput(TransformMeta transformMeta, KafkaConsumerInputMeta meta, KafkaConsumerInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        boolean superInit = super.init();
        if (!superInit) {
            return false;
        }
        try {
            ((KafkaConsumerInputData)this.data).outputRowMeta = ((KafkaConsumerInputMeta)this.meta).getRowMeta(this.getTransformName(), (IVariables)this);
        }
        catch (HopTransformException e) {
            this.logError("Error determining output row metadata", e);
        }
        ((KafkaConsumerInputData)this.data).incomingRowsBuffer = new ArrayList<Object[]>();
        ((KafkaConsumerInputData)this.data).batchDuration = Const.toInt((String)this.resolve(((KafkaConsumerInputMeta)this.meta).getBatchDuration()), (int)0);
        ((KafkaConsumerInputData)this.data).batchSize = Const.toInt((String)this.resolve(((KafkaConsumerInputMeta)this.meta).getBatchSize()), (int)0);
        ((KafkaConsumerInputData)this.data).consumer = KafkaConsumerInput.buildKafkaConsumer((IVariables)this, (KafkaConsumerInputMeta)this.meta);
        Set topics = ((KafkaConsumerInputMeta)this.meta).getTopics().stream().map(arg_0 -> ((KafkaConsumerInput)this).resolve(arg_0)).collect(Collectors.toSet());
        ((KafkaConsumerInputData)this.data).consumer.subscribe(topics);
        try {
            this.initSubPipeline();
        }
        catch (Exception e) {
            this.logError("Error initializing sub-transformation", e);
            return false;
        }
        ((KafkaConsumerInputData)this.data).isKafkaConsumerClosing = false;
        return true;
    }

    private void initSubPipeline() throws HopException {
        try {
            String realFilename = this.resolve(((KafkaConsumerInputMeta)this.meta).getFilename());
            PipelineMeta subTransMeta = new PipelineMeta(realFilename, this.metadataProvider, (IVariables)this);
            subTransMeta.setMetadataProvider(this.metadataProvider);
            subTransMeta.setFilename(realFilename);
            subTransMeta.setPipelineType(PipelineMeta.PipelineType.SingleThreaded);
            this.logDetailed("Loaded sub-pipeline '" + realFilename + "'");
            PipelineRunConfiguration runConfiguration = new PipelineRunConfiguration("Kafka", "", ((KafkaConsumerInputMeta)this.meta).getExecutionInformationLocation(), new ArrayList(), (IPipelineEngineRunConfiguration)new LocalPipelineRunConfiguration(), ((KafkaConsumerInputMeta)this.meta).getExecutionDataProfile(), false);
            LocalPipelineEngine kafkaPipeline = new LocalPipelineEngine(subTransMeta, (IVariables)this, (ILoggingObject)this);
            kafkaPipeline.setParentPipeline(this.getPipeline());
            kafkaPipeline.setPipelineRunConfiguration(runConfiguration);
            kafkaPipeline.prepareExecution();
            kafkaPipeline.setLogLevel(this.getPipeline().getLogLevel());
            kafkaPipeline.setPreviousResult(new Result());
            TransformWithMappingMeta.replaceVariableValues((IVariables)kafkaPipeline, (IVariables)this);
            TransformWithMappingMeta.addMissingVariables((IVariables)kafkaPipeline, (IVariables)this);
            kafkaPipeline.activateParameters((IVariables)kafkaPipeline);
            this.logDetailed("Initialized sub-pipeline '" + realFilename + "'");
            for (TransformMeta transformMeta : subTransMeta.getTransforms()) {
                ITransformMeta iTransform = transformMeta.getTransform();
                if (!(iTransform instanceof InjectorMeta)) continue;
                if (((KafkaConsumerInputData)this.data).rowProducer != null) {
                    throw new HopException("You can only have one copy of the injector transform '" + transformMeta.getName() + "' to accept the Kafka messages");
                }
                ((KafkaConsumerInputData)this.data).rowProducer = kafkaPipeline.addRowProducer(transformMeta.getName(), 0);
            }
            if (((KafkaConsumerInputData)this.data).rowProducer == null) {
                throw new HopException("Unable to find an Injector transform in the Kafka pipeline. Such a transform is needed to accept data from this Kafka Consumer transform.");
            }
            if (StringUtils.isNotEmpty((String)((KafkaConsumerInputMeta)this.meta).getSubTransform())) {
                ITransform transform = kafkaPipeline.findRunThread(((KafkaConsumerInputMeta)this.meta).getSubTransform());
                if (transform == null) {
                    throw new HopException("Unable to find transform '" + ((KafkaConsumerInputMeta)this.meta).getSubTransform() + "' to retrieve rows from");
                }
                transform.addRowListener((IRowListener)new RowAdapter(){

                    public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                        KafkaConsumerInput.this.putRow(rowMeta, row);
                    }
                });
            }
            kafkaPipeline.setLogChannel(this.getLogChannel());
            kafkaPipeline.startThreads();
            ((KafkaConsumerInputData)this.data).executor = this.errorHandlingConditionIsSatisfied() ? new SingleThreadedPipelineExecutor((Pipeline)kafkaPipeline, true) : new SingleThreadedPipelineExecutor((Pipeline)kafkaPipeline);
            ((KafkaConsumerInputData)this.data).executor.setClearingMetricsPerIteration(StringUtils.isEmpty((String)((KafkaConsumerInputMeta)this.meta).getExecutionInformationLocation()));
            boolean ok = ((KafkaConsumerInputData)this.data).executor.init();
            if (!ok) {
                throw new HopException("Initialization of sub-pipeline failed");
            }
            this.getPipeline().addActiveSubPipeline(this.getTransformName(), (IPipelineEngine)kafkaPipeline);
        }
        catch (Exception e) {
            throw new HopException("Unable to load and initialize sub pipeline", (Throwable)e);
        }
    }

    public void dispose() {
        if (((KafkaConsumerInputData)this.data).consumer != null) {
            ((KafkaConsumerInputData)this.data).consumer.unsubscribe();
            ((KafkaConsumerInputData)this.data).consumer.close();
        }
        super.dispose();
    }

    public static Consumer buildKafkaConsumer(IVariables variables, KafkaConsumerInputMeta meta) {
        int batch;
        Thread.currentThread().setContextClassLoader(meta.getClass().getClassLoader());
        Properties config = new Properties();
        for (String option : meta.getConfig().keySet()) {
            String value = variables.resolve(meta.getConfig().get(option));
            if (!StringUtils.isNotEmpty((String)value)) continue;
            config.put(option, variables.resolve(value));
        }
        config.put("group.id", variables.resolve(Const.NVL((String)meta.getConsumerGroup(), (String)"Apache Hop")));
        config.put("bootstrap.servers", variables.resolve(meta.getDirectBootstrapServers()));
        config.put("enable.auto.commit", (Object)meta.isAutoCommit());
        int timeout = Const.toInt((String)variables.resolve(meta.getBatchDuration()), (int)0);
        if (timeout > 0) {
            config.put("fetch.max.wait.ms", (Object)timeout);
        }
        if ((batch = Const.toInt((String)variables.resolve(meta.getBatchSize()), (int)0)) > 0) {
            config.put("max.poll.records", (Object)batch);
        }
        String keySerializerClass = meta.getKeyField().getOutputType().getKafkaDeserializerClass();
        config.put("key.deserializer", keySerializerClass);
        String valueSerializerClass = meta.getMessageField().getOutputType().getKafkaDeserializerClass();
        config.put("value.deserializer", valueSerializerClass);
        return new KafkaConsumer(config);
    }

    public void stopRunning() throws HopException {
        ((KafkaConsumerInputData)this.data).isKafkaConsumerClosing = true;
        ((KafkaConsumerInputData)this.data).consumer.wakeup();
        super.stopRunning();
    }

    public boolean processRow() throws HopException {
        try {
            Duration duration = Duration.ofMillis(((KafkaConsumerInputData)this.data).batchDuration > 0 ? (long)((KafkaConsumerInputData)this.data).batchDuration : Long.MAX_VALUE);
            ConsumerRecords records = ((KafkaConsumerInputData)this.data).consumer.poll(duration);
            if (!((KafkaConsumerInputData)this.data).isKafkaConsumerClosing && !records.isEmpty()) {
                for (ConsumerRecord record : records) {
                    Object[] outputRow = this.processMessageAsRow((ConsumerRecord<Object, Object>)record);
                    ((KafkaConsumerInputData)this.data).rowProducer.putRow(((KafkaConsumerInputData)this.data).outputRowMeta, outputRow);
                    if (this.errorHandlingConditionIsSatisfied()) {
                        ((KafkaConsumerInputData)this.data).incomingRowsBuffer.add(outputRow);
                    }
                    this.incrementLinesInput();
                }
                if (this.isBasic()) {
                    this.logBasic("Number of rows read: " + ((KafkaConsumerInputData)this.data).rowProducer.getRowSet().size());
                }
                ((KafkaConsumerInputData)this.data).executor.oneIteration();
                if (((KafkaConsumerInputData)this.data).executor.isStopped() || ((KafkaConsumerInputData)this.data).executor.getErrors() > 0L) {
                    if (this.isDebug()) {
                        this.logDebug("Executor's reported errors #: " + ((KafkaConsumerInputData)this.data).executor.getErrors());
                    }
                    if (((KafkaConsumerInputData)this.data).executor.getErrors() > 0L && this.errorHandlingConditionIsSatisfied()) {
                        for (int i = 0; i < ((KafkaConsumerInputData)this.data).incomingRowsBuffer.size(); ++i) {
                            this.putError(((KafkaConsumerInputData)this.data).outputRowMeta, ((KafkaConsumerInputData)this.data).incomingRowsBuffer.get(i), 1L, "An error occurred while processing the subpipeline", null, "KAFKA001");
                        }
                    } else {
                        ((KafkaConsumerInputData)this.data).executor.getPipeline().stopAll();
                        this.setOutputDone();
                        this.stopAll();
                        return false;
                    }
                }
                ((KafkaConsumerInputData)this.data).consumer.commitAsync();
                ((KafkaConsumerInputData)this.data).executor.buildExecutionSummary();
                if (this.errorHandlingConditionIsSatisfied()) {
                    ((KafkaConsumerInputData)this.data).incomingRowsBuffer.clear();
                }
            }
        }
        catch (WakeupException e) {
            ((KafkaConsumerInputData)this.data).executor.getPipeline().stopAll();
            this.setOutputDone();
            this.stopAll();
        }
        if (((KafkaConsumerInputData)this.data).executor.getErrors() > 0L && this.errorHandlingConditionIsSatisfied()) {
            try {
                ((KafkaConsumerInputData)this.data).executor.getPipeline().stopAll();
                ((KafkaConsumerInputData)this.data).executor.dispose();
                ((KafkaConsumerInputData)this.data).rowProducer = null;
                this.initSubPipeline();
            }
            catch (Exception e) {
                this.logError("Error initializing sub-transformation", e);
                return false;
            }
        }
        return true;
    }

    private boolean errorHandlingConditionIsSatisfied() {
        return this.getTransformMeta().isDoingErrorHandling() && ((KafkaConsumerInputData)this.data).batchSize == 1;
    }

    public Object[] processMessageAsRow(ConsumerRecord<Object, Object> record) {
        Object[] rowData = RowDataUtil.allocateRowData((int)((KafkaConsumerInputData)this.data).outputRowMeta.size());
        int index = 0;
        rowData[index++] = record.key();
        rowData[index++] = record.value();
        rowData[index++] = record.topic();
        rowData[index++] = (long)record.partition();
        rowData[index++] = record.offset();
        rowData[index] = record.timestamp();
        return rowData;
    }
}

