/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.admin.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LogicalViewName
implements ResourceName {
    private static final PathTemplate PROJECT_INSTANCE_LOGICAL_VIEW = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/logicalViews/{logical_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;
    private final String logicalView;

    @Deprecated
    protected LogicalViewName() {
        this.project = null;
        this.instance = null;
        this.logicalView = null;
    }

    private LogicalViewName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.logicalView = (String)Preconditions.checkNotNull((Object)builder.getLogicalView());
    }

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getLogicalView() {
        return this.logicalView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LogicalViewName of(String project, String instance, String logicalView) {
        return LogicalViewName.newBuilder().setProject(project).setInstance(instance).setLogicalView(logicalView).build();
    }

    public static String format(String project, String instance, String logicalView) {
        return LogicalViewName.newBuilder().setProject(project).setInstance(instance).setLogicalView(logicalView).build().toString();
    }

    public static LogicalViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_INSTANCE_LOGICAL_VIEW.validatedMatch(formattedString, "LogicalViewName.parse: formattedString not in valid format");
        return LogicalViewName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("logical_view"));
    }

    public static List<LogicalViewName> parseList(List<String> formattedStrings) {
        ArrayList<LogicalViewName> list = new ArrayList<LogicalViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LogicalViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LogicalViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LogicalViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INSTANCE_LOGICAL_VIEW.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LogicalViewName logicalViewName = this;
            synchronized (logicalViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.logicalView != null) {
                        fieldMapBuilder.put((Object)"logical_view", (Object)this.logicalView);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_INSTANCE_LOGICAL_VIEW.instantiate(new String[]{"project", this.project, "instance", this.instance, "logical_view", this.logicalView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LogicalViewName that = (LogicalViewName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.instance, that.instance) && Objects.equals(this.logicalView, that.logicalView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.logicalView);
    }

    public static class Builder {
        private String project;
        private String instance;
        private String logicalView;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getLogicalView() {
            return this.logicalView;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setLogicalView(String logicalView) {
            this.logicalView = logicalView;
            return this;
        }

        private Builder(LogicalViewName logicalViewName) {
            this.project = logicalViewName.project;
            this.instance = logicalViewName.instance;
            this.logicalView = logicalViewName.logicalView;
        }

        public LogicalViewName build() {
            return new LogicalViewName(this);
        }
    }
}

