/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;

@Internal
public class GenericPairComparator<T1, T2>
extends TypePairComparator<T1, T2>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TypeComparator<T1> comparator1;
    private final TypeComparator<T2> comparator2;
    private final TypeComparator<Object>[] comparators1;
    private final TypeComparator<Object>[] comparators2;
    private final Object[] referenceKeyFields;
    private final Object[] candidateKeyFields;

    public GenericPairComparator(TypeComparator<T1> comparator1, TypeComparator<T2> comparator2) {
        this.comparator1 = comparator1;
        this.comparator2 = comparator2;
        this.comparators1 = comparator1.getFlatComparators();
        this.comparators2 = comparator2.getFlatComparators();
        if (this.comparators1.length != this.comparators2.length) {
            throw new IllegalArgumentException("Number of key fields and comparators differ.");
        }
        int numKeys = this.comparators1.length;
        for (int i = 0; i < numKeys; ++i) {
            this.comparators1[i] = this.comparators1[i].duplicate();
            this.comparators2[i] = this.comparators2[i].duplicate();
        }
        this.referenceKeyFields = new Object[numKeys];
        this.candidateKeyFields = new Object[numKeys];
    }

    @Override
    public void setReference(T1 reference) {
        this.comparator1.extractKeys(reference, this.referenceKeyFields, 0);
    }

    @Override
    public boolean equalToReference(T2 candidate) {
        this.comparator2.extractKeys(candidate, this.candidateKeyFields, 0);
        for (int i = 0; i < this.comparators1.length; ++i) {
            if (this.comparators1[i].compare(this.referenceKeyFields[i], this.candidateKeyFields[i]) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareToReference(T2 candidate) {
        this.comparator2.extractKeys(candidate, this.candidateKeyFields, 0);
        for (int i = 0; i < this.comparators1.length; ++i) {
            int res = this.comparators1[i].compare(this.candidateKeyFields[i], this.referenceKeyFields[i]);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }
}

