/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SimpleMapWithFailures<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor FailureT>
extends PTransform<PCollection<InputT>, WithFailures.Result<PCollection<OutputT>, FailureT>> {
    private final transient @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType;
    private final @UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<InputT, OutputT>> fn;
    private final transient @UnknownKeyFor @NonNull @Initialized TypeDescriptor<FailureT> failureType;
    private final @Nullable @UnknownKeyFor @Initialized ProcessFunction< @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler;
    private final @UnknownKeyFor @NonNull @Initialized String transformName;

    SimpleMapWithFailures(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<InputT, OutputT>> fn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType, @Nullable @UnknownKeyFor @Initialized ProcessFunction< @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<FailureT> failureType) {
        this.transformName = transformName;
        this.fn = fn;
        this.outputType = outputType;
        this.exceptionHandler = exceptionHandler;
        this.failureType = failureType;
    }

    @Override
    public  @UnknownKeyFor @NonNull @Initialized WithFailures.Result<@UnknownKeyFor @NonNull @Initialized PCollection<OutputT>, FailureT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        if (this.exceptionHandler == null) {
            throw new NullPointerException(".exceptionsVia() is required");
        }
        return (WithFailures.Result)input.apply(this.transformName, MapElements.into(this.outputType).via(this.fn).exceptionsInto(this.failureType).exceptionsVia(this.exceptionHandler));
    }

    public @UnknownKeyFor @NonNull @Initialized SimpleMapWithFailures<InputT, OutputT, FailureT> exceptionsVia(@UnknownKeyFor @NonNull @Initialized ProcessFunction< @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
        return new SimpleMapWithFailures<InputT, OutputT, FailureT>(this.transformName, this.fn, this.outputType, exceptionHandler, this.failureType);
    }
}

