/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.auto.value.AutoValue;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_StreamingInsertsMetrics_StreamingInsertsMetricsImpl;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySinkMetrics;
import org.apache.beam.sdk.metrics.Histogram;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface StreamingInsertsMetrics {
    public void updateRetriedRowsWithStatus(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized int var2);

    public void updateFailedRpcMetrics(@UnknownKeyFor @NonNull @Initialized Instant var1, @UnknownKeyFor @NonNull @Initialized Instant var2, @UnknownKeyFor @NonNull @Initialized String var3);

    public void updateSuccessfulRpcMetrics(@UnknownKeyFor @NonNull @Initialized Instant var1, @UnknownKeyFor @NonNull @Initialized Instant var2);

    public void updateStreamingInsertsMetrics(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized TableReference var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized int var3);

    @AutoValue
    public static abstract class StreamingInsertsMetricsImpl
    implements StreamingInsertsMetrics {
        static final @UnknownKeyFor @NonNull @Initialized Histogram LATENCY_HISTOGRAM = BigQuerySinkMetrics.createRPCLatencyHistogram(BigQuerySinkMetrics.RpcMethod.STREAMING_INSERTS);

        abstract @UnknownKeyFor @NonNull @Initialized ConcurrentLinkedQueue<@UnknownKeyFor @NonNull @Initialized Duration> rpcLatencies();

        abstract @UnknownKeyFor @NonNull @Initialized ConcurrentLinkedQueue<@UnknownKeyFor @NonNull @Initialized String> rpcErrorStatus();

        abstract @UnknownKeyFor @NonNull @Initialized ConcurrentLinkedQueue<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer>> retriedRowsByStatus();

        abstract @UnknownKeyFor @NonNull @Initialized AtomicInteger successfulRpcsCount();

        abstract @UnknownKeyFor @NonNull @Initialized AtomicBoolean isWritable();

        public static @UnknownKeyFor @NonNull @Initialized StreamingInsertsMetricsImpl create() {
            return new AutoValue_StreamingInsertsMetrics_StreamingInsertsMetricsImpl(new ConcurrentLinkedQueue<Duration>(), new ConcurrentLinkedQueue<String>(), new ConcurrentLinkedQueue<KV<String, Integer>>(), new AtomicInteger(), new AtomicBoolean(true));
        }

        @Override
        public void updateRetriedRowsWithStatus(@UnknownKeyFor @NonNull @Initialized String status, @UnknownKeyFor @NonNull @Initialized int retriedRows) {
            if (this.isWritable().get()) {
                this.retriedRowsByStatus().add((KV<String, Integer>)KV.of((Object)status, (Object)retriedRows));
            }
        }

        @Override
        public void updateFailedRpcMetrics(@UnknownKeyFor @NonNull @Initialized Instant start, @UnknownKeyFor @NonNull @Initialized Instant end, @UnknownKeyFor @NonNull @Initialized String status) {
            if (this.isWritable().get()) {
                this.rpcErrorStatus().add(status);
                this.rpcLatencies().add(Duration.between(start, end));
            }
        }

        @Override
        public void updateSuccessfulRpcMetrics(@UnknownKeyFor @NonNull @Initialized Instant start, @UnknownKeyFor @NonNull @Initialized Instant end) {
            if (this.isWritable().get()) {
                this.successfulRpcsCount().getAndIncrement();
                this.rpcLatencies().add(Duration.between(start, end));
            }
        }

        private void recordRpcLatencyMetrics() {
            for (Duration d : this.rpcLatencies()) {
                LATENCY_HISTOGRAM.update((double)d.toMillis());
            }
        }

        @Override
        public void updateStreamingInsertsMetrics(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized TableReference tableRef, @UnknownKeyFor @NonNull @Initialized int totalRows, @UnknownKeyFor @NonNull @Initialized int failedRows) {
            Integer currentVal;
            if (!this.isWritable().compareAndSet(true, false)) {
                return;
            }
            if (tableRef == null) {
                return;
            }
            String shortTableId = String.join((CharSequence)"/", "datasets", tableRef.getDatasetId(), "tables", tableRef.getTableId());
            HashMap<String, Integer> rpcRequetsRpcStatusMap = new HashMap<String, Integer>();
            HashMap<String, Integer> retriedRowsRpcStatusMap = new HashMap<String, Integer>();
            for (String string : this.rpcErrorStatus()) {
                currentVal = rpcRequetsRpcStatusMap.getOrDefault(string, 0);
                rpcRequetsRpcStatusMap.put(string, currentVal + 1);
            }
            for (KV kV : this.retriedRowsByStatus()) {
                currentVal = retriedRowsRpcStatusMap.getOrDefault(kV.getKey(), 0);
                retriedRowsRpcStatusMap.put((String)kV.getKey(), currentVal + (Integer)kV.getValue());
            }
            for (Map.Entry entry : rpcRequetsRpcStatusMap.entrySet()) {
                BigQuerySinkMetrics.createRPCRequestCounter(BigQuerySinkMetrics.RpcMethod.STREAMING_INSERTS, (String)entry.getKey(), shortTableId).inc((long)((Integer)entry.getValue()).intValue());
            }
            for (Map.Entry entry : retriedRowsRpcStatusMap.entrySet()) {
                BigQuerySinkMetrics.appendRowsRowStatusCounter(BigQuerySinkMetrics.RowStatus.RETRIED, (String)entry.getKey(), shortTableId).inc((long)((Integer)entry.getValue()).intValue());
            }
            if (this.successfulRpcsCount().get() != 0) {
                BigQuerySinkMetrics.createRPCRequestCounter(BigQuerySinkMetrics.RpcMethod.STREAMING_INSERTS, BigQuerySinkMetrics.OK, shortTableId).inc(this.successfulRpcsCount().longValue());
            }
            if (failedRows >= 0) {
                BigQuerySinkMetrics.appendRowsRowStatusCounter(BigQuerySinkMetrics.RowStatus.FAILED, "INTERNAL", shortTableId).inc((long)failedRows);
            }
            if (totalRows - failedRows >= 0) {
                BigQuerySinkMetrics.appendRowsRowStatusCounter(BigQuerySinkMetrics.RowStatus.SUCCESSFUL, BigQuerySinkMetrics.OK, shortTableId).inc((long)(totalRows - failedRows));
            }
            this.recordRpcLatencyMetrics();
        }
    }

    public static class NoOpStreamingInsertsMetrics
    implements StreamingInsertsMetrics {
        private static @UnknownKeyFor @NonNull @Initialized NoOpStreamingInsertsMetrics singleton = new NoOpStreamingInsertsMetrics();

        private NoOpStreamingInsertsMetrics() {
        }

        @Override
        public void updateRetriedRowsWithStatus(@UnknownKeyFor @NonNull @Initialized String status, @UnknownKeyFor @NonNull @Initialized int retriedRows) {
        }

        @Override
        public void updateFailedRpcMetrics(@UnknownKeyFor @NonNull @Initialized Instant start, @UnknownKeyFor @NonNull @Initialized Instant end, @UnknownKeyFor @NonNull @Initialized String status) {
        }

        @Override
        public void updateSuccessfulRpcMetrics(@UnknownKeyFor @NonNull @Initialized Instant start, @UnknownKeyFor @NonNull @Initialized Instant end) {
        }

        @Override
        public void updateStreamingInsertsMetrics(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized TableReference tableRef, @UnknownKeyFor @NonNull @Initialized int totalRows, @UnknownKeyFor @NonNull @Initialized int failedRows) {
        }

        static @UnknownKeyFor @NonNull @Initialized NoOpStreamingInsertsMetrics getInstance() {
            return singleton;
        }
    }
}

